/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;

public class ANTLogToCmtLogAdapter
implements BuildLogger {
    private static final Hashtable HASHTABLE_ANT_TO_CMT_LOG_LEVELS = new Hashtable();
    private static final Logger LOGGER = LoggerFactory.createLogger(ANTLogToCmtLogAdapter.class);
    private static final String S_CLASS_NAME = ANTLogToCmtLogAdapter.class.getName();
    private static final String S_SPACER = " - ";
    private static final String S_BUILD_STARTED = "Build started.";
    private static final String S_BUILD_STOPPED = "Build stopped - ";
    private static final String S_SUCCESS = "SUCCESS";
    private static final String S_FAILURE = "FAILURE";
    private static final String S_TARGET_STARTED = "Target started for: ";
    private static final String S_TARGET_STOPPED = "Target stopped for: ";
    private static final String S_TASK_STARTED = "Task started for: ";
    private static final String S_TASK_STOPPED = "Task stopped for: ";

    public void setMessageOutputLevel(int n) {
    }

    public void setOutputPrintStream(PrintStream printStream) {
    }

    public void setEmacsMode(boolean bl) {
    }

    public void setErrorPrintStream(PrintStream printStream) {
    }

    public void buildStarted(BuildEvent buildEvent) {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildStarted", S_BUILD_STARTED);
    }

    public void buildFinished(BuildEvent buildEvent) {
        String string = this.getBuildEventStatus(buildEvent);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildFinished", S_BUILD_STOPPED + string);
    }

    public void targetStarted(BuildEvent buildEvent) {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "targetStarted", S_TARGET_STARTED + buildEvent.getTarget().getName());
    }

    public void targetFinished(BuildEvent buildEvent) {
        String string = this.getBuildEventStatus(buildEvent);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "targetFinished", S_TARGET_STOPPED + buildEvent.getTarget().getName() + S_SPACER + string);
        if (string.equals(S_FAILURE)) {
            LogUtils.logException(LOGGER, buildEvent.getException());
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "taskStarted", S_TASK_STARTED + buildEvent.getTask().getTaskName());
    }

    public void taskFinished(BuildEvent buildEvent) {
        String string = this.getBuildEventStatus(buildEvent);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "taskFinished", S_TASK_STOPPED + buildEvent.getTask().getTaskName() + S_SPACER + string);
        if (string.equals(S_FAILURE)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "taskFinished", S_TASK_STOPPED + buildEvent.getTask().getTaskName() + S_SPACER + string);
        }
    }

    private String getBuildEventStatus(BuildEvent buildEvent) {
        Throwable throwable = buildEvent.getException();
        String string = S_SUCCESS;
        if (throwable != null) {
            string = S_FAILURE;
        }
        return string;
    }

    public void messageLogged(BuildEvent buildEvent) {
        Level level = (Level)HASHTABLE_ANT_TO_CMT_LOG_LEVELS.get(new Integer(buildEvent.getPriority()));
        if (level == null) {
            level = Level.INFO;
        }
        LOGGER.log(level, buildEvent.getMessage());
    }

    static {
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(4), Level.FINE);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(0), Level.SEVERE);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(2), Level.INFO);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(3), Level.FINER);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(1), Level.WARNING);
    }
}

