/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

public class ANTTargetCaller {
    private static final String S_ANT_CALL = "antcall";
    private static final Logger LOGGER = LoggerFactory.createLogger(ANTTargetCaller.class);
    private static final String S_CLASS_NAME = ANTTargetCaller.class.getName();

    public static void callTargetWithTheseValues(String string, Hashtable hashtable, Project project, Target target) throws BuildException {
        LOGGER.entering(ANTTargetCaller.class.getName(), "callTargetWithTheseValues");
        CallTarget callTarget = ANTTargetCaller.createCallTargetObjectForTheGivenTargetName(string, project, target);
        ANTTargetCaller.transferTheseParamsToThisCallTarget(callTarget, hashtable);
        callTarget.execute();
        LOGGER.exiting(ANTTargetCaller.class.getName(), "callTargetWithTheseValues");
    }

    private static CallTarget createCallTargetObjectForTheGivenTargetName(String string, Project project, Target target) throws BuildException {
        LOGGER.entering(ANTTargetCaller.class.getName(), "createCallTargetObjectForTheGivenTargetName");
        CallTarget callTarget = (CallTarget)project.createTask(S_ANT_CALL);
        callTarget.setOwningTarget(target);
        callTarget.setInheritAll(true);
        callTarget.setInheritRefs(false);
        callTarget.setTarget(string);
        LOGGER.exiting(ANTTargetCaller.class.getName(), "createCallTargetObjectForTheGivenTargetName");
        return callTarget;
    }

    private static void transferTheseParamsToThisCallTarget(CallTarget callTarget, Hashtable hashtable) {
        LOGGER.entering(ANTTargetCaller.class.getName(), "transferTheseParamsToThisCallTarget");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            Property property = callTarget.createParam();
            property.setName(k.toString());
            property.setValue(v.toString());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "transferTheseParamsToThisCallTarget", "Transferred " + k.toString() + "=" + v.toString() + " to " + callTarget.toString());
        }
        LOGGER.exiting(ANTTargetCaller.class.getName(), "transferTheseParamsToThisCallTarget");
    }
}

