/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ChangeStringEncodingAntTask
extends Task {
    private String m_sString = null;
    private String m_sEncodingFrom = null;
    private String m_sEncodingTo = null;
    private String m_sProperty = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(ChangeStringEncodingAntTask.class);
    private static final String S_CLASS_NAME = ChangeStringEncodingAntTask.class.getName();
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_NO_STRING = "Missing string property";
    private static final String S_NO_ENDCODING_TO = "Missing destination character set to property";
    private static final String S_NO_ENCODING_FROM = "Missing the source character set property";
    private static final String S_NO_PROPERTY = "Property name for the property that holds the result must be specified";
    private static final String S_UNSUPPORTED_CHARACTERSET = "Unsupported destination character encoding. ";

    public void init() throws BuildException {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "init");
        super.init();
        this.m_sString = null;
        this.m_sEncodingFrom = null;
        this.m_sEncodingTo = null;
        this.m_sProperty = null;
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the ReplaceStringRegExpAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String string = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Detected file encoding is: " + string);
        if (string.equals(this.m_sEncodingFrom)) {
            String string2 = this.convert(this.m_sString, this.m_sEncodingTo);
            this.getProject().setNewProperty(this.m_sProperty, string2);
        } else {
            this.getProject().setNewProperty(this.m_sProperty, this.m_sString);
        }
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "execute");
    }

    private String convert(String string, String string2) throws BuildException {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "convert");
        String string3 = "";
        try {
            string3 = new String(string.getBytes(), string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "convert", S_UNSUPPORTED_CHARACTERSET + unsupportedEncodingException.getMessage());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "convert", "Converted result: " + string3);
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "convert");
        return string3;
    }

    public void setString(String string) {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "setString");
        this.m_sString = string;
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "setString");
    }

    public void setEncodingFrom(String string) {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "setEncodingFrom");
        this.m_sEncodingFrom = string;
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "setEncodingFrom");
    }

    public void setEncodingTo(String string) {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "setEncodingTo");
        this.m_sEncodingTo = string;
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "setEncodingTo");
    }

    public void setProperty(String string) {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "setProperty");
        this.m_sProperty = string;
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "setProperty");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(ChangeStringEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sString == null) {
            this.m_sErrorMessage = S_NO_STRING;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sEncodingFrom == null) {
            this.m_sErrorMessage = S_NO_ENCODING_FROM;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sEncodingTo == null) {
            this.m_sErrorMessage = S_NO_ENDCODING_TO;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sProperty == null) {
            this.m_sErrorMessage = S_NO_PROPERTY;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(ChangeStringEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

