/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class FileEncodingAntTask
extends Task {
    private String m_sPath = null;
    private String m_sFrom = null;
    private String m_sTo = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(FileEncodingAntTask.class);
    private static final String S_CLASS_NAME = FileEncodingAntTask.class.getName();
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_NO_PATH = "Missing path property";
    private static final String S_NO_FROM_ENCODING = "Missing regular expression property";
    private static final String S_NO_tO_ENCODING = "Missing value property";

    public void init() throws BuildException {
        LOGGER.entering(FileEncodingAntTask.class.getName(), "init");
        super.init();
        this.m_sPath = null;
        this.m_sFrom = null;
        this.m_sTo = null;
        LOGGER.exiting(FileEncodingAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(FileEncodingAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the FileEncodingAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String string = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Detected file encoding is: " + string);
        if (string.equalsIgnoreCase(this.m_sFrom)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Calling convert on file: " + this.m_sPath + " to encoding: " + this.m_sTo);
            this.convert(this.m_sPath, this.m_sTo);
        }
        LOGGER.exiting(FileEncodingAntTask.class.getName(), "execute");
    }

    public void setPath(String string) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "setPath");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setPath", "Incoming path is set to: " + string);
        this.m_sPath = string;
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "setPath");
    }

    public void setFrom(String string) {
        LOGGER.entering(FileEncodingAntTask.class.getName(), "setFrom");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setFrom", "Source file encoding is set to: " + string);
        this.m_sFrom = string;
        LOGGER.exiting(FileEncodingAntTask.class.getName(), "setFrom");
    }

    public void setTo(String string) {
        LOGGER.entering(FileEncodingAntTask.class.getName(), "setTo");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setTo", "Target file encoding is set to: " + string);
        this.m_sTo = string;
        LOGGER.exiting(FileEncodingAntTask.class.getName(), "setTo");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(FileEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sPath == null) {
            this.m_sErrorMessage = S_NO_PATH;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(FileEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sFrom == null) {
            this.m_sErrorMessage = S_NO_FROM_ENCODING;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(FileEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sTo == null) {
            this.m_sErrorMessage = S_NO_tO_ENCODING;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(FileEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(FileEncodingAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }

    private void convert(String string, String string2) {
        LOGGER.entering(FileEncodingAntTask.class.getName(), "convert");
        try {
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                arrayList.add(string3);
            }
            bufferedReader.close();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string2));
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = (String)arrayList.get(i);
                printWriter.println((String)arrayList.get(i));
            }
            printWriter.flush();
            printWriter.close();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "convert", string + " is converted from " + this.m_sFrom + " to " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LOGGER.exiting(FileEncodingAntTask.class.getName(), "convert");
    }
}

