/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.actionengine.ant.utils.ANTTargetCaller;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.FileSetUtils;
import com.ibm.ws.install.configmanager.actionengine.ant.utils.StringFormatUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;

public class ForEachAntTask
extends Task {
    private String m_sList = new String();
    private String m_sTarget = null;
    private String m_sPropertyName = null;
    private Hashtable m_hashtableParams = new Hashtable();
    private Vector m_vfilesets = new Vector();
    private String m_sErrorMessage = new String();
    private static final String S_COMMA = ",";
    private static final String S_DOTS = "...";
    private static final String S_EMPTY = "";
    private static final String S_NO_TARGET = "No target specified";
    private static final String S_NO_PROPERTY_NAME = "Missing property name";
    private static final String S_NO_LIST_OR_PATH = "No list or set of paths was specified";
    private static final String S_ANT_CALL = "antcall";
    private static final Logger LOGGER = LoggerFactory.createLogger(ForEachAntTask.class);
    private static final String S_CLASS_NAME = ForEachAntTask.class.getName();

    public void init() throws BuildException {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "init");
        super.init();
        this.m_sList = new String();
        this.m_sTarget = null;
        this.m_sPropertyName = null;
        this.m_hashtableParams = new Hashtable();
        this.m_sErrorMessage = new String();
        this.m_vfilesets = new Vector();
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        if (this.m_sList.length() != 0) {
            this.callTargetWhileIteratingOverGivenList();
        }
        if (this.m_vfilesets.size() != 0) {
            this.callTargetWhileIteratingOverGivenFileSets();
        }
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "execute");
    }

    public void setTarget(String string) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "setTarget");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setTarget", "Called target set as: " + string);
        this.m_sTarget = string;
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "setTarget");
    }

    public void setList(String string) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "setList");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setList", "Incoming list set to: " + string);
        this.m_sList = this.m_sList + string;
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "setList");
    }

    public void setCounter(String string) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "setCounter");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setCounter", "Incoming counter set as: " + string);
        this.addTheGivenCountersToOurInternalList(string);
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "setCounter");
    }

    public void setPropertyName(String string) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "setPropertyName");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setPropertyName", "Incoming property name set to: " + string);
        this.m_sPropertyName = string;
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "setPropertyName");
    }

    public void addConfiguredParam(Property property) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "addConfiguredParam");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addConfiguredParam", "Adding configured param: " + property.toString());
        this.m_hashtableParams.put(property.getName(), property.getValue());
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "addConfiguredParam");
    }

    public void addConfiguredFileset(FileSet fileSet) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "addConfiguredFileset");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addConfiguredFileset", "Added the fileset: " + fileSet.toString());
        this.m_vfilesets.add(fileSet);
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "addConfiguredFileset");
    }

    private void addTheGivenCountersToOurInternalList(String string) {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "addTheGivenCountersToOurInternalList");
        int n = string.indexOf(S_DOTS);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + S_DOTS.length(), string.length());
        String string4 = StringFormatUtils.getTheseNumbersAsACommaSeparatedList(string2, string3);
        this.m_sList = this.m_sList.length() != 0 ? this.m_sList + S_COMMA + string4 : string4;
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "addTheGivenCountersToOurInternalList");
    }

    private void callTargetWhileIteratingOverGivenList() throws BuildException {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "callTargetWhileIteratingOverGivenList");
        StringTokenizer stringTokenizer = new StringTokenizer(this.m_sList, S_COMMA);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            this.callGivenTargetWithThisIterativePropertyValue(string);
        }
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callTargetWhileIteratingOverGivenList");
    }

    private void callTargetWhileIteratingOverGivenFileSets() throws BuildException {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "callTargetWhileIteratingOverGivenFileSets");
        Vector vector = FileSetUtils.getAllFilesInTheseFileSets(this.m_vfilesets, this.getProject());
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            this.callGivenTargetWithThisIterativePropertyValue(string);
        }
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callTargetWhileIteratingOverGivenFileSets");
    }

    private void callGivenTargetWithThisIterativePropertyValue(String string) throws BuildException {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "callGivenTargetWithThisIterativePropertyValue", "Calling " + this.m_sTarget + " with property " + this.m_sPropertyName + " set to " + string);
        this.m_hashtableParams.put(this.m_sPropertyName, string);
        ANTTargetCaller.callTargetWithTheseValues(this.m_sTarget, this.m_hashtableParams, this.getProject(), this.getOwningTarget());
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "doAllParamsCheckOutOk");
        if (this.m_sTarget == null) {
            this.m_sErrorMessage = S_NO_TARGET;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
            return false;
        }
        if (this.m_sPropertyName == null) {
            this.m_sErrorMessage = S_NO_PROPERTY_NAME;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
            return false;
        }
        if (this.m_sTarget.trim() == S_EMPTY) {
            this.m_sErrorMessage = S_NO_TARGET;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
            return false;
        }
        if (this.m_sPropertyName.trim() == S_EMPTY) {
            this.m_sErrorMessage = S_NO_PROPERTY_NAME;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
            return false;
        }
        if (this.m_vfilesets.size() == 0 && this.m_sList == null) {
            this.m_sErrorMessage = S_NO_LIST_OR_PATH;
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "doAllParamsCheckOutOk", this.m_sErrorMessage);
            LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
            return false;
        }
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "callGivenTargetWithThisIterativePropertyValue");
        return true;
    }
}

