/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.util.JavaEnvUtils;

public class InProcessAntRunner {
    public static final String DEFAULT_BUILD_FILENAME = "wsconfig.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private Vector targets = new Vector(5);
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(5);
    private Vector propertyFiles = new Vector(5);
    private String loggerClassname = null;
    private String inputHandlerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static boolean isLogFileUsed = false;
    private static String antVersion = null;
    private static final Logger LOGGER = LoggerFactory.createLogger(InProcessAntRunner.class);
    private static final String S_CLASS_NAME = InProcessAntRunner.class.getName();

    private static void printMessage(Throwable throwable) {
        LogUtils.logException(LOGGER, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(String[] stringArray, Properties properties, ClassLoader classLoader) {
        String string;
        Object object;
        InProcessAntRunner inProcessAntRunner = null;
        try {
            Diagnostics.validateVersion();
            inProcessAntRunner = new InProcessAntRunner(stringArray);
        }
        catch (Throwable throwable) {
            InProcessAntRunner.printMessage(throwable);
            return false;
        }
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = System.getProperty((String)object);
            inProcessAntRunner.definedProps.put(object, string);
        }
        if (properties != null) {
            object = properties.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                String string2 = properties.getProperty(string);
                inProcessAntRunner.definedProps.put(string, string2);
            }
        }
        try {
            inProcessAntRunner.runBuild(classLoader);
            boolean bl = true;
            return bl;
        }
        catch (BuildException buildException) {
            if (err != System.err) {
                InProcessAntRunner.printMessage(buildException);
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            boolean bl;
            block33: {
                block34: {
                    throwable.printStackTrace();
                    InProcessAntRunner.printMessage(throwable);
                    bl = false;
                    if (!isLogFileUsed) break block33;
                    if (out == null) break block34;
                    try {
                        out.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return bl;
        }
        finally {
            if (isLogFileUsed) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
                if (err != null) {
                    try {
                        err.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        InProcessAntRunner.start(stringArray, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InProcessAntRunner(String[] stringArray) throws BuildException {
        Object object;
        Object object2;
        String string;
        int n;
        String string2 = null;
        PrintStream printStream = null;
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n];
            if (string.equals("-help")) {
                InProcessAntRunner.printUsage();
                return;
            }
            if (string.equals("-version")) {
                InProcessAntRunner.printVersion();
                return;
            }
            if (string.equals("-diagnostics")) {
                Diagnostics.doReport((PrintStream)System.out);
                return;
            }
            if (string.equals("-quiet") || string.equals("-q")) {
                this.msgOutputLevel = 1;
                continue;
            }
            if (string.equals("-verbose") || string.equals("-v")) {
                InProcessAntRunner.printVersion();
                this.msgOutputLevel = 3;
                continue;
            }
            if (string.equals("-debug")) {
                InProcessAntRunner.printVersion();
                this.msgOutputLevel = 4;
                continue;
            }
            if (string.equals("-logfile") || string.equals("-l")) {
                try {
                    object2 = new File(stringArray[n + 1]);
                    ++n;
                    printStream = new PrintStream(new FileOutputStream((File)object2));
                    isLogFileUsed = true;
                    continue;
                }
                catch (IOException iOException) {
                    object = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    InProcessAntRunner.logOutputMessage((String)object);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    object = "You must specify a log file when using the -log argument";
                    InProcessAntRunner.logOutputMessage((String)object);
                    return;
                }
            }
            if (string.equals("-buildfile") || string.equals("-file") || string.equals("-f")) {
                try {
                    this.buildFile = new File(stringArray[n + 1]);
                    ++n;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    object = "You must specify a buildfile when using the -buildfile argument";
                    InProcessAntRunner.logOutputMessage((String)object);
                    return;
                }
            }
            if (string.equals("-listener")) {
                try {
                    this.listeners.addElement(stringArray[n + 1]);
                    ++n;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    object = "You must specify a classname when using the -listener argument";
                    InProcessAntRunner.logOutputMessage((String)object);
                    return;
                }
            }
            if (string.startsWith("-D")) {
                object2 = string.substring(2, string.length());
                object = null;
                int n2 = ((String)object2).indexOf("=");
                if (n2 > 0) {
                    object = ((String)object2).substring(n2 + 1);
                    object2 = ((String)object2).substring(0, n2);
                } else if (n < stringArray.length - 1) {
                    object = stringArray[++n];
                }
                this.definedProps.put(object2, object);
                continue;
            }
            if (string.equals("-logger")) {
                if (this.loggerClassname != null) {
                    InProcessAntRunner.logOutputMessage("Only one logger class may  be specified.");
                    return;
                }
                try {
                    this.loggerClassname = stringArray[++n];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    InProcessAntRunner.logOutputMessage("You must specify a classname when using the -logger argument");
                    return;
                }
            }
            if (string.equals("-inputhandler")) {
                if (this.inputHandlerClassname != null) {
                    InProcessAntRunner.logOutputMessage("Only one input handler class may be specified.");
                    return;
                }
                try {
                    this.inputHandlerClassname = stringArray[++n];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    InProcessAntRunner.logOutputMessage("You must specify a classname when using the -inputhandler argument");
                    return;
                }
            }
            if (string.equals("-emacs")) {
                this.emacsMode = true;
                continue;
            }
            if (string.equals("-projecthelp")) {
                this.projectHelp = true;
                continue;
            }
            if (string.equals("-find")) {
                if (n < stringArray.length - 1) {
                    string2 = stringArray[++n];
                    continue;
                }
                string2 = DEFAULT_BUILD_FILENAME;
                continue;
            }
            if (string.startsWith("-propertyfile")) {
                try {
                    this.propertyFiles.addElement(stringArray[n + 1]);
                    ++n;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    object = "You must specify a property filename when using the -propertyfile argument";
                    InProcessAntRunner.logOutputMessage((String)object);
                    return;
                }
            }
            if (string.startsWith("-")) {
                object2 = "Unknown argument: " + string;
                InProcessAntRunner.logOutputMessage((String)object2);
                InProcessAntRunner.printUsage();
                return;
            }
            this.targets.addElement(string);
        }
        if (this.buildFile == null) {
            this.buildFile = string2 != null ? this.findBuildFile(System.getProperty("user.dir"), string2) : new File(DEFAULT_BUILD_FILENAME);
        }
        if (!this.buildFile.exists()) {
            InProcessAntRunner.logOutputMessage("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            InProcessAntRunner.logOutputMessage("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        for (n = 0; n < this.propertyFiles.size(); ++n) {
            string = (String)this.propertyFiles.elementAt(n);
            object2 = new Properties();
            object = null;
            try {
                object = new FileInputStream(string);
                ((Properties)object2).load((InputStream)object);
            }
            catch (IOException iOException) {
                InProcessAntRunner.logOutputMessage("Could not load property file " + string + ": " + iOException.getMessage());
            }
            finally {
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Enumeration<?> enumeration = ((Properties)object2).propertyNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (this.definedProps.getProperty(string3) != null) continue;
                this.definedProps.put(string3, ((Properties)object2).getProperty(string3));
            }
        }
        if (this.msgOutputLevel >= 2) {
            InProcessAntRunner.logOutputMessage("Buildfile: " + this.buildFile);
        }
        if (printStream != null) {
            out = err = printStream;
            System.setOut(out);
            System.setErr(out);
        }
        this.readyToRun = true;
    }

    private File getParentFile(File file) {
        String string = file.getAbsolutePath();
        file = new File(string);
        if ((string = file.getParent()) != null && this.msgOutputLevel >= 3) {
            InProcessAntRunner.logOutputMessage("Searching in " + string);
        }
        return string == null ? null : new File(string);
    }

    private File findBuildFile(String string, String string2) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            InProcessAntRunner.logOutputMessage("Searching for " + string2 + " ...");
        }
        File file = new File(new File(string).getAbsolutePath());
        File file2 = new File(file, string2);
        while (!file2.exists()) {
            if ((file = this.getParentFile(file)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file2 = new File(file, string2);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBuild(ClassLoader classLoader) throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        Project project = new Project();
        project.setCoreLoader(classLoader);
        Throwable throwable = null;
        try {
            this.addBuildListeners(project);
            this.addInputHandler(project);
            PrintStream printStream = System.err;
            PrintStream printStream2 = System.out;
            SecurityManager securityManager = null;
            if (!JavaEnvUtils.isJavaVersion((String)"1.0") && !JavaEnvUtils.isJavaVersion((String)"1.1")) {
                securityManager = System.getSecurityManager();
            }
            try {
                System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(project, false)));
                System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
                if (!this.projectHelp) {
                    project.fireBuildStarted();
                }
                project.init();
                project.setUserProperty("ant.version", InProcessAntRunner.getAntVersion());
                Enumeration<Object> enumeration = this.definedProps.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)this.definedProps.get(string);
                    project.setUserProperty(string, string2);
                }
                project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                ProjectHelper.configureProject((Project)project, (File)this.buildFile);
                if (this.projectHelp) {
                    InProcessAntRunner.printDescription(project);
                    InProcessAntRunner.printTargets(project, this.msgOutputLevel > 2);
                    return;
                }
                if (this.targets.size() == 0) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
            }
            finally {
                if (securityManager != null) {
                    System.setSecurityManager(securityManager);
                }
                System.setOut(printStream2);
                System.setErr(printStream);
            }
        }
        catch (RuntimeException runtimeException) {
            throwable = runtimeException;
            throw runtimeException;
        }
        catch (Error error) {
            throwable = error;
            throw error;
        }
        finally {
            if (!this.projectHelp) {
                project.fireBuildFinished(throwable);
            }
        }
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener((BuildListener)this.createLogger());
        for (int i = 0; i < this.listeners.size(); ++i) {
            String string = (String)this.listeners.elementAt(i);
            try {
                BuildListener buildListener = (BuildListener)Class.forName(string).newInstance();
                project.addBuildListener(buildListener);
                continue;
            }
            catch (Throwable throwable) {
                throw new BuildException("Unable to instantiate listener " + string, throwable);
            }
        }
    }

    private void addInputHandler(Project project) {
        DefaultInputHandler defaultInputHandler = null;
        if (this.inputHandlerClassname == null) {
            defaultInputHandler = new DefaultInputHandler();
        } else {
            try {
                defaultInputHandler = (InputHandler)Class.forName(this.inputHandlerClassname).newInstance();
            }
            catch (ClassCastException classCastException) {
                String string = "The specified input handler class " + this.inputHandlerClassname + " does not implement the InputHandler interface";
                throw new BuildException(string);
            }
            catch (Exception exception) {
                String string = "Unable to instantiate specified input handler class " + this.inputHandlerClassname + " : " + exception.getClass().getName();
                throw new BuildException(string);
            }
        }
        project.setInputHandler((InputHandler)defaultInputHandler);
    }

    private BuildLogger createLogger() {
        DefaultLogger defaultLogger = null;
        if (this.loggerClassname != null) {
            try {
                defaultLogger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException classCastException) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception exception) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + exception.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            defaultLogger = new DefaultLogger();
        }
        defaultLogger.setMessageOutputLevel(this.msgOutputLevel);
        defaultLogger.setOutputPrintStream(out);
        defaultLogger.setErrorPrintStream(err);
        defaultLogger.setEmacsMode(this.emacsMode);
        return defaultLogger;
    }

    private static void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ant [options] [target [target2 [target3] ...]]" + string);
        stringBuffer.append("Options: " + string);
        stringBuffer.append("  -help                  print this message" + string);
        stringBuffer.append("  -projecthelp           print project help information" + string);
        stringBuffer.append("  -version               print the version information and exit" + string);
        stringBuffer.append("  -diagnostics           print information that might be helpful to" + string);
        stringBuffer.append("                         diagnose or report problems." + string);
        stringBuffer.append("  -quiet, -q             be extra quiet" + string);
        stringBuffer.append("  -verbose, -v           be extra verbose" + string);
        stringBuffer.append("  -debug                 print debugging information" + string);
        stringBuffer.append("  -emacs                 produce logging information without adornments" + string);
        stringBuffer.append("  -logfile <file>        use given file for log" + string);
        stringBuffer.append("    -l     <file>                ''" + string);
        stringBuffer.append("  -logger <classname>    the class which is to perform logging" + string);
        stringBuffer.append("  -listener <classname>  add an instance of class as a project listener" + string);
        stringBuffer.append("  -buildfile <file>      use given buildfile" + string);
        stringBuffer.append("    -file    <file>              ''" + string);
        stringBuffer.append("    -f       <file>              ''" + string);
        stringBuffer.append("  -D<property>=<value>   use value for given property" + string);
        stringBuffer.append("  -propertyfile <name>   load all properties from file with -D" + string);
        stringBuffer.append("                         properties taking precedence" + string);
        stringBuffer.append("  -inputhandler <class>  the class which will handle input requests" + string);
        stringBuffer.append("  -find <file>           search for buildfile towards the root of the" + string);
        stringBuffer.append("                         filesystem and use it" + string);
        InProcessAntRunner.logOutputMessage(stringBuffer.toString());
    }

    private static void printVersion() throws BuildException {
        InProcessAntRunner.logOutputMessage(InProcessAntRunner.getAntVersion());
    }

    private static void logOutputMessage(String string) {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "logOutputMessage", string);
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties properties = new Properties();
                InputStream inputStream = InProcessAntRunner.class.getResourceAsStream("/org/apache/tools/ant/version.txt");
                properties.load(inputStream);
                inputStream.close();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Apache Ant version ");
                stringBuffer.append(properties.getProperty("VERSION"));
                stringBuffer.append(" compiled on ");
                stringBuffer.append(properties.getProperty("DATE"));
                antVersion = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not load the version information:" + iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static void printTargets(Project project, boolean bl) {
        String string;
        int n = 0;
        Enumeration enumeration = project.getTargets().elements();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            int n2;
            Target target = (Target)enumeration.nextElement();
            String string2 = target.getName();
            String string3 = target.getDescription();
            if (string3 == null) {
                n2 = InProcessAntRunner.findTargetPosition(vector3, string2);
                vector3.insertElementAt(string2, n2);
                continue;
            }
            n2 = InProcessAntRunner.findTargetPosition(vector, string2);
            vector.insertElementAt(string2, n2);
            vector2.insertElementAt(string3, n2);
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        InProcessAntRunner.printTargets(project, vector, vector2, "InProcessAntRunner targets:", n);
        if (vector.size() == 0) {
            bl = true;
        }
        if (bl) {
            InProcessAntRunner.printTargets(project, vector3, null, "Subtargets:", 0);
        }
        if ((string = project.getDefaultTarget()) != null && !"".equals(string)) {
            project.log("Default target: " + string);
        }
    }

    private static int findTargetPosition(Vector vector, String string) {
        int n = vector.size();
        for (int i = 0; i < vector.size() && n == vector.size(); ++i) {
            if (string.compareTo((String)vector.elementAt(i)) >= 0) continue;
            n = i;
        }
        return n;
    }

    private static void printTargets(Project project, Vector vector, Vector vector2, String string, int n) {
        String string2 = System.getProperty("line.separator");
        String string3 = "    ";
        while (string3.length() < n) {
            string3 = string3 + string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + string2 + string2);
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(vector.elementAt(i));
            if (vector2 != null) {
                stringBuffer.append(string3.substring(0, n - ((String)vector.elementAt(i)).length() + 2));
                stringBuffer.append(vector2.elementAt(i));
            }
            stringBuffer.append(string2);
        }
        project.log(stringBuffer.toString());
    }
}

