/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ReplaceStringRegExpAntTask
extends Task {
    private String m_sString = null;
    private String m_sRegExp = null;
    private String m_sValue = null;
    private String m_sProperty = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(ReplaceStringRegExpAntTask.class);
    private static final String S_CLASS_NAME = ReplaceStringRegExpAntTask.class.getName();
    private static final String S_NO_STRING = "Missing string property";
    private static final String S_NO_REG_EXP = "Missing regular expression property";
    private static final String S_NO_VALUE = "Missing value property";
    private static final String S_NO_PROPERTY = "Property name for the property that holds the result must be specified";

    public void init() throws BuildException {
        LOGGER.entering(ReplaceStringRegExpAntTask.class.getName(), "init");
        super.init();
        this.m_sString = null;
        this.m_sRegExp = null;
        this.m_sValue = null;
        this.m_sProperty = null;
        LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(ReplaceStringRegExpAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the ReplaceStringRegExpAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String string = this.m_sString.replaceAll(this.m_sRegExp, this.m_sValue);
        this.getProject().setNewProperty(this.m_sProperty, string);
        LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "execute");
    }

    public void setString(String string) {
        LOGGER.entering(ReplaceStringRegExpAntTask.class.getName(), "setString");
        this.m_sString = string;
        LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "setString");
    }

    public void setRegExp(String string) {
        LOGGER.entering(ReplaceStringRegExpAntTask.class.getName(), "setRegExp");
        this.m_sRegExp = string;
        LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "setRegExp");
    }

    public void setValue(String string) {
        LOGGER.entering(ReplaceStringRegExpAntTask.class.getName(), "setValue");
        this.m_sValue = string;
        LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "setValue");
    }

    public void setProperty(String string) {
        LOGGER.entering(ReplaceStringRegExpAntTask.class.getName(), "setProperty");
        this.m_sProperty = string;
        LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "setProperty");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(ReplaceStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sString == null) {
            this.m_sErrorMessage = S_NO_STRING;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sRegExp == null) {
            this.m_sErrorMessage = S_NO_REG_EXP;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sValue == null) {
            this.m_sErrorMessage = S_NO_VALUE;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sProperty == null) {
            this.m_sErrorMessage = S_NO_PROPERTY;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(ReplaceStringRegExpAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

