/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.execengine;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.execengine.ProcessTimeoutThread;
import com.ibm.ws.install.configmanager.execengine.StreamCollectionThread;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecEngine {
    private String m_sOut = null;
    private String m_sErr = null;
    private int m_nRetVal = -1;
    private int m_nTimeOut = 1800000;
    private static final Logger LOGGER = LoggerFactory.createLogger(ExecEngine.class);
    private static final String S_CLASS_NAME = ExecEngine.class.getName();

    public int executeIncomingArguments(String[] stringArray, int n) {
        LOGGER.entering(ExecEngine.class.getName(), "executeIncomingArguments( String[], int )");
        LOGGER.exiting(ExecEngine.class.getName(), "executeIncomingArguments( String[], int )");
        return this.spawnProcess(stringArray);
    }

    public int executeIncomingArguments(Vector vector, int n) {
        LOGGER.entering(ExecEngine.class.getName(), "executeIncomingArguments( Vector, int )");
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        LOGGER.exiting(ExecEngine.class.getName(), "executeIncomingArguments( Vector, int )");
        return this.spawnProcess(stringArray);
    }

    public String getProcessStdOut() {
        LOGGER.entering(ExecEngine.class.getName(), "getProcessStdOut");
        if (this.m_sOut != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getProcessStdOut", "The process' standard out follows\n" + this.m_sOut);
        }
        LOGGER.exiting(ExecEngine.class.getName(), "getProcessStdOut");
        return this.m_sOut;
    }

    public String getProcessStdErr() {
        LOGGER.entering(ExecEngine.class.getName(), "getProcessStdErr");
        if (this.m_sErr != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getProcessStdErr", "The process' standard error follows\n" + this.m_sErr);
        }
        LOGGER.exiting(ExecEngine.class.getName(), "getProcessStdErr");
        return this.m_sErr;
    }

    public int getProcessRetCode() {
        LOGGER.entering(ExecEngine.class.getName(), "getProcessRetCode");
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getProcessRetCode", "The process' return code was: " + this.m_nRetVal);
        LOGGER.exiting(ExecEngine.class.getName(), "getProcessRetCode");
        return this.m_nRetVal;
    }

    protected void doWaitForProcessToTerminateOrTimeOut(Process process) throws InterruptedException {
        LOGGER.entering(ExecEngine.class.getName(), "doWaitForProcessToTerminateOrTimeOut");
        ProcessTimeoutThread processTimeoutThread = new ProcessTimeoutThread(process, ConfigManagerConstants.getProcessTimeOutTime());
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doWaitForProcessToTerminateOrTimeOut", "Starting to time the process");
        processTimeoutThread.startTiming();
        process.waitFor();
        processTimeoutThread.stopTiming();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "doWaitForProcessToTerminateOrTimeOut", "Stopped timing the process (it was not timed out)");
        LOGGER.exiting(ExecEngine.class.getName(), "doWaitForProcessToTerminateOrTimeOut");
    }

    private int spawnProcess(String[] stringArray) {
        LOGGER.entering(ExecEngine.class.getName(), "spawnProcess");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "spawnProcess", "Launching this command: " + LogUtils.getArrayAsALoggableString(stringArray));
        int n = -1;
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "spawnProcess", "The launched process is: " + process.toString());
            StreamCollectionThread streamCollectionThread = new StreamCollectionThread(process.getInputStream());
            StreamCollectionThread streamCollectionThread2 = new StreamCollectionThread(process.getErrorStream());
            streamCollectionThread.startCollecting();
            streamCollectionThread2.startCollecting();
            this.doWaitForProcessToTerminateOrTimeOut(process);
            streamCollectionThread.stopCollecting();
            streamCollectionThread2.stopCollecting();
            this.m_sOut = streamCollectionThread.toString();
            this.m_sErr = streamCollectionThread2.toString();
            n = this.m_nRetVal = process.exitValue();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "spawnProcess", "The process' return code was: " + this.m_nRetVal + ", the command was: " + LogUtils.getArrayAsALoggableString(stringArray));
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException);
            n = -1;
        }
        catch (InterruptedException interruptedException) {
            LogUtils.logException(LOGGER, interruptedException);
            n = -1;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            LogUtils.logException(LOGGER, illegalThreadStateException);
            n = -1;
        }
        LOGGER.exiting(ExecEngine.class.getName(), "spawnProcess");
        return n;
    }
}

