/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.execengine;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessTimeoutThread
extends Thread {
    private Process m_processToTimeout = null;
    private int m_nTimeoutPeriod = 0;
    private boolean m_fStopTimingProcess = true;
    private static final int N_DEFAULT_SLEEP = 5;
    private static final Logger LOGGER = LoggerFactory.createLogger(ProcessTimeoutThread.class);
    private static final String S_CLASS_NAME = ProcessTimeoutThread.class.getName();

    public ProcessTimeoutThread(Process process, int n) {
        LOGGER.entering(ProcessTimeoutThread.class.getName(), "ProcessTimeoutThread");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "ProcessTimeoutThread", "The process to timeout is: " + process.toString() + ", the timeout period is: " + n);
        this.m_processToTimeout = process;
        this.m_nTimeoutPeriod = n;
        LOGGER.exiting(ProcessTimeoutThread.class.getName(), "ProcessTimeoutThread");
    }

    public void run() {
        LOGGER.entering(ProcessTimeoutThread.class.getName(), "run");
        int n = 0;
        while (!this.m_fStopTimingProcess && this.m_nTimeoutPeriod > n) {
            try {
                Thread.sleep(5L);
                n += 5;
            }
            catch (InterruptedException interruptedException) {
                LogUtils.logException(LOGGER, interruptedException);
            }
        }
        if (!this.m_fStopTimingProcess) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "run", "Process " + this.m_processToTimeout.toString() + " timed out, destroying it");
            this.m_processToTimeout.destroy();
        }
        LOGGER.exiting(ProcessTimeoutThread.class.getName(), "run");
    }

    public void startTiming() {
        LOGGER.entering(ProcessTimeoutThread.class.getName(), "startTiming");
        this.m_fStopTimingProcess = false;
        this.start();
        LOGGER.exiting(ProcessTimeoutThread.class.getName(), "startTiming");
    }

    public void stopTiming() {
        LOGGER.entering(ProcessTimeoutThread.class.getName(), "stopTiming");
        this.m_fStopTimingProcess = true;
        this.m_processToTimeout = null;
        LOGGER.exiting(ProcessTimeoutThread.class.getName(), "stopTiming");
    }
}

