/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.execengine;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamCollectionThread
extends Thread {
    private InputStream m_inputstream = null;
    private String m_sBuffer = new String();
    private boolean m_fStopFlag = false;
    private static final String S_EOLN = "\n";
    private static final int N_SLEEP = 5;
    private static final Logger LOGGER = LoggerFactory.createLogger(StreamCollectionThread.class);
    private static final String S_CLASS_NAME = StreamCollectionThread.class.getName();
    private static final String S_I5OS_JOB_ENCODING = "os400.job.file.encoding";

    public StreamCollectionThread(InputStream inputStream) {
        LOGGER.entering(StreamCollectionThread.class.getName(), "StreamCollectionThread");
        this.m_inputstream = inputStream;
        LOGGER.entering(StreamCollectionThread.class.getName(), "StreamCollectionThread");
    }

    public void run() {
        String string;
        LOGGER.entering(StreamCollectionThread.class.getName(), "run");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_inputstream));
        if (PlatformConstants.isCurrentPlatformOS400()) {
            try {
                string = System.getProperty(S_I5OS_JOB_ENCODING);
                if (string != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader(this.m_inputstream, string));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bufferedReader = new BufferedReader(new InputStreamReader(this.m_inputstream));
            }
        }
        string = null;
        do {
            try {
                string = bufferedReader.readLine();
                if (string != null) {
                    LOGGER.logp(Level.FINE, S_CLASS_NAME, "run", "Collected this string from the stream: " + string);
                    this.m_sBuffer = this.m_sBuffer + string + S_EOLN;
                }
                Thread.sleep(5L);
            }
            catch (IOException iOException) {
                LogUtils.logException(LOGGER, iOException);
            }
            catch (InterruptedException interruptedException) {
                LogUtils.logException(LOGGER, interruptedException);
            }
        } while (string != null || !this.shouldWeStopCollecting());
        LOGGER.exiting(StreamCollectionThread.class.getName(), "run");
    }

    public void startCollecting() {
        LOGGER.entering(StreamCollectionThread.class.getName(), "startCollecting");
        this.m_fStopFlag = false;
        this.start();
        LOGGER.exiting(StreamCollectionThread.class.getName(), "startCollecting");
    }

    public void stopCollecting() throws InterruptedException {
        LOGGER.entering(StreamCollectionThread.class.getName(), "stopCollecting");
        this.m_fStopFlag = true;
        this.join();
        LOGGER.exiting(StreamCollectionThread.class.getName(), "stopCollecting");
    }

    public String toString() {
        LOGGER.entering(StreamCollectionThread.class.getName(), "toString");
        LOGGER.exiting(StreamCollectionThread.class.getName(), "toString");
        return this.m_sBuffer.toString();
    }

    private boolean shouldWeStopCollecting() {
        LOGGER.entering(StreamCollectionThread.class.getName(), "shouldWeStopCollecting");
        LOGGER.exiting(StreamCollectionThread.class.getName(), "shouldWeStopCollecting");
        return this.m_fStopFlag;
    }
}

