/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.launcher;

import com.ibm.ws.install.configmanager.launcher.Launcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArgumentValueFetcher {
    private static Hashtable originalCommandLineArguments = new Hashtable();
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(ArgumentValueFetcher.class);
    private static final String S_CLASS_NAME = ArgumentValueFetcher.class.getName();

    public static String getArgumentValue(String string) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        return ArgumentValueFetcher.getArgumentValue(string, true);
    }

    public static String getArgumentValue(String string, boolean bl) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        String string2 = Launcher.getArgumentValue(string);
        if (!ArgumentValueFetcher.isEmptyOrNullString(string2)) {
            if (bl) {
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", "Argument: " + string + ", Value: " + string2 + ", found from incoming command line");
            }
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
            return string2;
        }
        string2 = System.getProperty(string);
        if (!ArgumentValueFetcher.isEmptyOrNullString(string2)) {
            if (bl) {
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", "Argument: " + string + ", Value: " + string2 + ", found from JDK system properties");
            }
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
            return string2;
        }
        string2 = PlatformConstants.getEnvironmentVariableValue(string);
        if (!ArgumentValueFetcher.isEmptyOrNullString(string2)) {
            if (bl) {
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", "Argument: " + string + ", Value: " + string2 + ", found from system environment");
            }
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
            return string2;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getArgumentValue", "Could not resolve this argument: " + string + ", returning null");
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValue");
        return null;
    }

    public static String[] getArgumentValues(String string) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "getArgumentValues");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (ArgumentValueFetcher.isArgumentAvailable(string)) {
            arrayList.add(ArgumentValueFetcher.getArgumentValue(string, false));
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValues");
            return arrayList.toArray(new String[0]);
        }
        int n = 1;
        while (ArgumentValueFetcher.isArgumentAvailable(string + n)) {
            arrayList.add(ArgumentValueFetcher.getArgumentValue(string + n, false));
            ++n;
        }
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getArgumentValues");
        return arrayList.toArray(new String[0]);
    }

    public static boolean isArgumentAvailable(String string) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "isArgumentAvailable");
        String string2 = ArgumentValueFetcher.getArgumentValue(string, false);
        if (string2 != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isArgumentAvailable", string + " could be resolved");
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isArgumentAvailable");
            return true;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "isArgumentAvailable", string + " could not be resolved");
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isArgumentAvailable");
        return false;
    }

    private static boolean isEmptyOrNullString(String string) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
        if (string == null) {
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
            return true;
        }
        if (string.trim().equals(S_EMPTY)) {
            LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
            return true;
        }
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "isEmptyOrNullString");
        return false;
    }

    public static void setCommandLineArguments(Hashtable hashtable) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "setCommandLineArguments");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            if (vector.isEmpty()) continue;
            originalCommandLineArguments.put(string, (String)vector.firstElement());
        }
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "setCommandLineArguments");
    }

    public static String getCommandLineArgumentValue(String string) {
        LOGGER.entering(ArgumentValueFetcher.class.getName(), "getCommandLineArgumentValue");
        LOGGER.exiting(ArgumentValueFetcher.class.getName(), "getCommandLineArgumentValue");
        return (String)originalCommandLineArguments.get(string);
    }
}

