/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.launcher;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import com.ibm.ws.install.configmanager.utils.HashtableUtils;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Launcher {
    private static Hashtable m_hashtableArguments = new Hashtable();
    private static final String S_DASH = "-";
    private static final Logger LOGGER = LoggerFactory.reinitAndCreateLogger(Launcher.class);
    private static final String S_CLASS_NAME = Launcher.class.getName();

    public static void main(String[] stringArray) {
        LOGGER.entering(Launcher.class.getName(), "main");
        Launcher.fillInCommandLineArguments(stringArray);
        LOGGER.exiting(Launcher.class.getName(), "main");
        System.exit(ConfigManager.launch());
    }

    public static int mainForInProcessCMTCallers() {
        LOGGER.entering(Launcher.class.getName(), "main");
        int n = ConfigManager.launch();
        LOGGER.exiting(Launcher.class.getName(), "main");
        return n;
    }

    public static int mainForInProcessCMTCallers(String[] stringArray) {
        LOGGER.entering(Launcher.class.getName(), "main");
        Launcher.fillInCommandLineArguments(stringArray);
        LOGGER.exiting(Launcher.class.getName(), "main");
        return ConfigManager.launch();
    }

    public static String getArgumentValue(String string) {
        LOGGER.entering(Launcher.class.getName(), "getArgumentValue");
        Object v = m_hashtableArguments.get(string);
        if (v != null) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", string + " resolved to: " + v.toString() + " from incoming command line");
            LOGGER.exiting(Launcher.class.getName(), "getArgumentValue");
            return v.toString();
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getArgumentValue", string + " could not be resolved from the incoming command line");
        LOGGER.exiting(Launcher.class.getName(), "getArgumentValue");
        return null;
    }

    private static void fillInCommandLineArguments(String[] stringArray) {
        LOGGER.entering(Launcher.class.getName(), "fillInCommandLineArguments");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "fillInCommandLineArguments", "Incoming arguments are: " + ArrayUtils.join(", ", stringArray));
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(S_DASH) && n + 1 < stringArray.length) {
                String string = stringArray[n].substring(S_DASH.length());
                String string2 = stringArray[n + 1];
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "fillInCommandLineArguments", string + " was found in the incoming command line, its value was: " + string2);
                m_hashtableArguments.put(string, string2);
                n += 2;
                continue;
            }
            ++n;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "fillInCommandLineArguments", "Parsed hashtable of arguments is: " + HashtableUtils.convertHashtableToPropertiesString(m_hashtableArguments));
        LOGGER.exiting(Launcher.class.getName(), "fillInCommandLineArguments");
    }
}

