/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtils {
    private static final String S_EXCEPTION_MESSAGE_TYPE = "Exception was thrown, type of exception is: ";
    private static final String S_EXCEPTION_MESSAGE_ENGLISH = "The exception message is: ";
    private static final String S_EXCEPTION_MESSAGE_TRANSLATED = "The translated exception message is: ";
    private static final String S_EXCEPTION_MESSAGE_STACK_TRACE = "The stack trace follows";
    private static final String S_BRACKET_OPEN = "{";
    private static final String S_BRACKET_CLOSE = "}";
    private static final String S_SPACE = " ";
    private static final String S_QUOTE = "\"";
    private static final String S_COMMA = ",";
    private static final String S_CLASS_NAME = LogUtils.class.getName();

    public static synchronized void logException(Logger logger, Throwable throwable) {
        LogUtils.logException(logger, throwable, Level.WARNING);
    }

    public static synchronized void logException(Logger logger, Throwable throwable, Level level) {
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_TYPE + throwable.getClass());
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_ENGLISH + throwable.getMessage());
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_TRANSLATED + throwable.getLocalizedMessage());
        logger.logp(level, S_CLASS_NAME, "logException", S_EXCEPTION_MESSAGE_STACK_TRACE);
        logger.logp(level, S_CLASS_NAME, "logException", LogUtils.getExceptionStackTraceAsString(throwable));
    }

    public static synchronized String getArrayAsALoggableString(Object[] objectArray) {
        String string = "{ ";
        if (objectArray == null) {
            string = string + S_BRACKET_CLOSE;
            return string;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            string = i != objectArray.length - 1 ? string + S_QUOTE + objectArray[i].toString() + S_QUOTE + S_SPACE + S_COMMA : string + S_QUOTE + objectArray[i].toString() + S_QUOTE;
        }
        string = string + S_SPACE + S_BRACKET_CLOSE;
        return string;
    }

    private static String getExceptionStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

