/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.logging;

import com.ibm.ws.install.configmanager.logging.EmptyLogHandler;
import com.ibm.ws.install.configmanager.logging.LoggerFactoryConstants;
import com.ibm.ws.install.configmanager.logging.XMLAppendFormatter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;

public class LoggerFactory {
    public static final int N_LOG_OFF = 0;
    public static final int N_LOG_SEVERE = 1;
    public static final int N_LOG_WARNING = 2;
    public static final int N_LOG_INFO = 3;
    public static final int N_LOG_CONFIG = 4;
    public static final int N_LOG_FINE = 5;
    public static final int N_LOG_FINER = 6;
    public static final int N_LOG_FINEST = 7;
    private static Handler m_filehandlerRegularLoggers = null;
    private static int m_nCurrentLogLevel = -1;
    private static String m_sCurrentLogFilePath = null;
    private static Vector m_vloggersAll = new Vector();
    private static boolean m_fContextSwitch = false;
    private static final char C_EMPTY = ' ';

    public static Logger createLogger(Class clazz) {
        LoggerFactory.createFileHandlerForRegularLoggersIfNeeded();
        Logger logger = LoggerFactory.createRegularLogger(clazz);
        m_vloggersAll.add(logger);
        return logger;
    }

    public static Logger reinitAndCreateLogger(Class clazz) {
        LoggerFactory.switchLogFilesIfNeeded();
        return LoggerFactory.createLogger(clazz);
    }

    public static void reinitializeInitLoggers(Vector vector, Handler handler2, int n, String string) {
        LoggerFactory.reinitializeLogHandlers(vector, m_filehandlerRegularLoggers, handler2);
        if (m_filehandlerRegularLoggers != null) {
            m_filehandlerRegularLoggers.close();
        }
        m_filehandlerRegularLoggers = handler2;
        m_nCurrentLogLevel = n;
        m_sCurrentLogFilePath = string;
    }

    protected static Vector getAllLoggers() {
        return m_vloggersAll;
    }

    protected static Handler getCurrentLogHandler() {
        return m_filehandlerRegularLoggers;
    }

    protected static int getLogLevel() {
        return m_nCurrentLogLevel;
    }

    protected static String getCurrentLogFilePath() {
        return m_sCurrentLogFilePath;
    }

    protected static void setContextSwitchFlag(boolean bl) {
        m_fContextSwitch = bl;
    }

    private static void switchLogFilesIfNeeded() {
        if (LoggerFactory.isAReInitOfLoggerFactoryRequired()) {
            int n;
            for (n = 0; n < m_vloggersAll.size(); ++n) {
                ((Logger)m_vloggersAll.elementAt(n)).removeHandler(m_filehandlerRegularLoggers);
            }
            if (m_filehandlerRegularLoggers != null && !m_fContextSwitch) {
                m_filehandlerRegularLoggers.close();
            }
            m_filehandlerRegularLoggers = null;
            LoggerFactory.createFileHandlerForRegularLoggersIfNeeded();
            for (n = 0; n < m_vloggersAll.size(); ++n) {
                ((Logger)m_vloggersAll.elementAt(n)).addHandler(m_filehandlerRegularLoggers);
            }
        }
    }

    private static void reinitializeLogHandlers(Vector vector, Handler handler2, Handler handler3) {
        for (int i = 0; i < vector.size(); ++i) {
            ((Logger)vector.elementAt(i)).removeHandler(handler2);
            if (handler3 == null) continue;
            ((Logger)vector.elementAt(i)).addHandler(handler3);
        }
    }

    private static boolean isAReInitOfLoggerFactoryRequired() {
        if (m_nCurrentLogLevel != LoggerFactoryConstants.getDesiredLogLevel()) {
            return true;
        }
        return !LoggerFactoryConstants.getGlobalLogFilePath().equals(m_sCurrentLogFilePath);
    }

    private static void createFileHandlerForRegularLoggersIfNeeded() {
        if (m_filehandlerRegularLoggers != null) {
            return;
        }
        try {
            if (!LoggerFactoryConstants.isEmptyFileHandlerCase()) {
                LoggerFactory.createLogDirectoryIfNeeded();
                m_filehandlerRegularLoggers = new FileHandler(LoggerFactoryConstants.getGlobalLogFilePath(), LoggerFactoryConstants.getDesiredAppendSetting());
                m_filehandlerRegularLoggers.setLevel(LoggerFactory.getCurrentLogLevel());
                try {
                    if (LoggerFactoryConstants.getDesiredAppendSetting()) {
                        RandomAccessFile randomAccessFile = new RandomAccessFile(LoggerFactoryConstants.getGlobalLogFilePath(), "rw");
                        int n = new XMLFormatter().getTail(m_filehandlerRegularLoggers).length();
                        if (randomAccessFile.length() >= (long)n) {
                            randomAccessFile.seek(randomAccessFile.length() - (long)n);
                            for (int i = 0; i < n; ++i) {
                                randomAccessFile.writeByte(32);
                            }
                        }
                        randomAccessFile.close();
                        m_filehandlerRegularLoggers.setFormatter(new XMLAppendFormatter());
                        m_filehandlerRegularLoggers.publish(new LogRecord(Level.INFO, null));
                        m_filehandlerRegularLoggers.setFormatter(new XMLFormatter());
                    }
                }
                catch (IOException iOException) {}
            } else {
                m_filehandlerRegularLoggers = new EmptyLogHandler();
            }
            m_sCurrentLogFilePath = LoggerFactoryConstants.getGlobalLogFilePath();
            m_nCurrentLogLevel = LoggerFactoryConstants.getDesiredLogLevel();
            return;
        }
        catch (IOException iOException) {
            m_filehandlerRegularLoggers = new ConsoleHandler();
            return;
        }
    }

    private static void createLogDirectoryIfNeeded() {
        File file = new File(LoggerFactoryConstants.getGlobalLogDirectory());
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private static Logger createRegularLogger(Class clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        LoggerFactory.initializeLoggerAsRegularLogger(logger);
        return logger;
    }

    private static void initializeLoggerAsRegularLogger(Logger logger) {
        logger.setLevel(LoggerFactory.getCurrentLogLevel());
        if (!LoggerFactory.hasHandler(logger, m_filehandlerRegularLoggers)) {
            logger.addHandler(m_filehandlerRegularLoggers);
        }
        logger.setUseParentHandlers(false);
    }

    private static boolean hasHandler(Logger logger, Handler handler2) {
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            if (!handlerArray[i].equals(handler2)) continue;
            return true;
        }
        return false;
    }

    private static Level getCurrentLogLevel() {
        return LoggerFactory.translateLoggerFactoryLevelToLevelObject(LoggerFactoryConstants.getDesiredLogLevel());
    }

    private static Level translateLoggerFactoryLevelToLevelObject(int n) {
        switch (n) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.CONFIG;
            }
            case 5: {
                return Level.FINE;
            }
            case 6: {
                return Level.FINER;
            }
            case 7: {
                return Level.FINEST;
            }
        }
        return Level.INFO;
    }
}

