/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.logging;

import java.io.File;
import java.io.IOException;

public class LoggerFactoryConstants {
    public static final String S_DEFAULT_LOG_FILE_PATH = "cmtbootstraplog.txt";
    public static int N_DEFAULT_LOG_LEVEL = 3;
    public static final String S_ARG_LOG_LEVEL = "WS_CMT_LOGLEVEL";
    public static final String S_ARG_LOG_HOME = "WS_CMT_LOG_HOME";
    public static final String S_ARG_LOG_FILE_NAME = "WS_CMT_LOG_NAME";
    public static final String S_ARG_APPEND_LOGS = "WS_CMT_APPEND_LOGS";
    private static final String S_CURRENT_DIR = "./";
    private static final String S_TEMP_LOG_PREFIX = "~._cmt";
    private static final String S_JAVA_TEMP = "java.io.tmpdir";
    private static final String S_EMPTY = "";
    private static final String S_LOG_FILE_NAME = "cmtlog.txt";

    public static int getDesiredLogLevel() {
        String string = System.getProperty(S_ARG_LOG_LEVEL);
        if (string == null) {
            return N_DEFAULT_LOG_LEVEL;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return N_DEFAULT_LOG_LEVEL;
        }
    }

    public static String getGlobalLogDirectory() {
        String string = System.getProperty(S_ARG_LOG_HOME);
        if (string == null) {
            string = System.getProperty(S_JAVA_TEMP);
        }
        return new File(string).getAbsolutePath();
    }

    public static String getGlobalLogFilePath() {
        Object object;
        String string = S_LOG_FILE_NAME;
        if (LoggerFactoryConstants.isEmptyFileHandlerCase()) {
            return S_EMPTY;
        }
        if (System.getProperty(S_ARG_LOG_FILE_NAME) != null) {
            string = System.getProperty(S_ARG_LOG_FILE_NAME);
        } else {
            try {
                object = File.createTempFile(S_TEMP_LOG_PREFIX, null);
                if (object != null) {
                    string = ((File)object).getName();
                    ((File)object).delete();
                }
            }
            catch (IOException iOException) {
                string = S_LOG_FILE_NAME;
            }
        }
        object = new File(LoggerFactoryConstants.getGlobalLogDirectory(), string).getAbsolutePath();
        return object;
    }

    public static boolean getDesiredAppendSetting() {
        String string = System.getProperty(S_ARG_APPEND_LOGS);
        return string == String.valueOf(true);
    }

    public static boolean isEmptyFileHandlerCase() {
        return System.getProperty(S_ARG_LOG_HOME) == null && System.getProperty(S_ARG_LOG_FILE_NAME) == null;
    }
}

