/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.osutils;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.execengine.ExecEngine;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.utils.ArrayUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessEnvironment {
    private static Hashtable m_hashtableEnvironment = null;
    private static final String S_SET = "set";
    private static final String S_EQUALS = "=";
    private static final String S_EOLN = "\n";
    private static final String S_COMMA = ",";
    private static final String S_IBM_JAVA = "IBM_JAVA_COMMAND_LINE";
    private static final String S_PASSWORD = "*************************";
    private static final Pattern PATTERN_ENVIRONMENT = Pattern.compile("^(.*?)=(.*)$", 8);
    private static final int N_GROUP_ENVIRONMENT_VARIABLE_NAME = 1;
    private static final int N_GROUP_ENVIRONMENT_VARIABLE_VALUE = 2;
    private static final Logger LOGGER = LoggerFactory.createLogger(ProcessEnvironment.class);
    private static final String S_CLASS_NAME = ProcessEnvironment.class.getName();

    public static String getEnvironmentVariableValue(String string) {
        LOGGER.entering(ProcessEnvironment.class.getName(), "getEnvironmentVariableValue");
        ProcessEnvironment.parseProcessEnvironment();
        String string2 = ProcessEnvironment.convertThisEnvironmentVariableNameToUpperCaseIfWindows(string);
        Object v = m_hashtableEnvironment.get(string2);
        if (v != null) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getEnvironmentVariableValue", "Value of " + string + " from the process environment is: " + v.toString());
            LOGGER.exiting(ProcessEnvironment.class.getName(), "getEnvironmentVariableValue");
            return v.toString();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getEnvironmentVariableValue", "Value of " + string + " could not be extracted from the process environment, returning null");
        LOGGER.exiting(ProcessEnvironment.class.getName(), "getEnvironmentVariableValue");
        return null;
    }

    public static String dumpEnvironment() {
        LOGGER.entering(ProcessEnvironment.class.getName(), "dumpEnvironment");
        Enumeration enumeration = m_hashtableEnvironment.keys();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            string = string + string2 + S_EQUALS + m_hashtableEnvironment.get(string2).toString() + S_EOLN;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "dumpEnvironment", "Process environment dump follows: \n" + string);
        LOGGER.exiting(ProcessEnvironment.class.getName(), "dumpEnvironment");
        return string;
    }

    private static void parseProcessEnvironment() {
        LOGGER.entering(ProcessEnvironment.class.getName(), "parseProcessEnvironment");
        if (m_hashtableEnvironment != null) {
            return;
        }
        m_hashtableEnvironment = new Hashtable();
        String string = ProcessEnvironment.getEnvironmentUnParsed();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "parseProcessEnvironment", "Unparsed JVM process environment follows\n" + ProcessEnvironment.maskLine(string, S_IBM_JAVA, S_EOLN));
        if (string == null) {
            return;
        }
        Matcher matcher = PATTERN_ENVIRONMENT.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            string2 = ProcessEnvironment.convertThisEnvironmentVariableNameToUpperCaseIfWindows(string2);
            String string3 = matcher.group(2);
            m_hashtableEnvironment.put(string2, string3);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "parseProcessEnvironment", "Parsed JVM process environment follows\n" + ProcessEnvironment.maskLine(m_hashtableEnvironment.toString(), S_IBM_JAVA, S_COMMA));
        LOGGER.exiting(ProcessEnvironment.class.getName(), "parseProcessEnvironment");
    }

    private static String convertThisEnvironmentVariableNameToUpperCaseIfWindows(String string) {
        if (PlatformConstants.isCurrentPlatformWindows()) {
            return string.toUpperCase();
        }
        return string;
    }

    private static String getEnvironmentUnParsed() {
        LOGGER.entering(ProcessEnvironment.class.getName(), "getEnvironmentUnParsed");
        String[] stringArray = PlatformConstants.getShellExecPrefixForCurrentPlatform();
        String[] stringArray2 = new String[stringArray.length + 1];
        ArrayUtils.appendArray(stringArray2, stringArray, 0);
        stringArray2[stringArray.length] = S_SET;
        ExecEngine execEngine = new ExecEngine();
        execEngine.executeIncomingArguments(stringArray2, ConfigManagerConstants.getProcessTimeOutTime());
        String string = execEngine.getProcessStdOut();
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "getEnvironmentUnParsed", "Unparsed JVM environment follows\n" + ProcessEnvironment.maskLine(string, S_IBM_JAVA, S_EOLN));
        LOGGER.exiting(ProcessEnvironment.class.getName(), "getEnvironmentUnParsed");
        return string;
    }

    private static String maskLine(String string, String string2, String string3) {
        try {
            int n = string.indexOf(string2);
            if (n != -1) {
                return string.substring(0, n) + string2 + S_EQUALS + S_PASSWORD + string3 + string.substring(string.indexOf(string3, n) + 1);
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }
}

