/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.tests;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestArgumentValueFetcher
extends TestCase {
    private static final String S_EMPTY = "";
    private static final String S_WAS_HOME_UNIX = "/opt/WebSphere/AppServer";
    private static final String S_WAS_HOME_WINDOWS = "C:\\Program Files\\WebSphere\\AppServer";

    public TestArgumentValueFetcher(String string) {
        super(string);
    }

    public void testArgumentValueFetcherWorksWithSystemPropertySet() {
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            System.setProperty(ConfigManagerConstants.S_ARG_WAS_DIR, S_WAS_HOME_UNIX);
            Assert.assertEquals((String)ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_WAS_DIR), (String)S_WAS_HOME_UNIX);
        } else {
            System.setProperty(ConfigManagerConstants.S_ARG_WAS_DIR, S_WAS_HOME_WINDOWS);
            Assert.assertEquals((String)ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_WAS_DIR), (String)S_WAS_HOME_WINDOWS);
        }
        System.setProperty(ConfigManagerConstants.S_ARG_WAS_DIR, S_EMPTY);
    }

    public void testArgumentValueFetcherWorksWithEnvironmentVariableSet() {
        System.setProperty(ConfigManagerConstants.S_ARG_WAS_DIR, S_EMPTY);
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            Assert.assertEquals((String)ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_WAS_DIR), (String)S_WAS_HOME_UNIX);
        } else {
            Assert.assertEquals((String)ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_WAS_DIR), (String)S_WAS_HOME_WINDOWS);
        }
    }
}

