/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.tests;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.execengine.ExecEngine;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestExecEngine
extends TestCase {
    private static final String S_PATH = "PATH";
    private static final String[] AS_EXTRACT_PATH_UNIX = new String[]{"sh", "-c", "echo ${PATH}"};
    private static final String[] AS_EXTRACT_PATH_WINDOWS = new String[]{"cmd.exe", "/c", "echo %PATH%"};

    public TestExecEngine(String string) {
        super(string);
    }

    public void testExecEngineUNIX() {
        ExecEngine execEngine = new ExecEngine();
        execEngine.executeIncomingArguments(AS_EXTRACT_PATH_UNIX, ConfigManagerConstants.getProcessTimeOutTime());
        String string = execEngine.getProcessStdOut();
        String string2 = PlatformConstants.getEnvironmentVariableValue(S_PATH);
        System.out.println("PATH1: " + string);
        System.out.println("PATH2: " + string2);
        Assert.assertEquals((String)string.trim(), (String)string2.trim());
    }

    public void testExecEngineWindows() {
        ExecEngine execEngine = new ExecEngine();
        execEngine.executeIncomingArguments(AS_EXTRACT_PATH_WINDOWS, ConfigManagerConstants.getProcessTimeOutTime());
        String string = execEngine.getProcessStdOut();
        String string2 = PlatformConstants.getEnvironmentVariableValue(S_PATH);
        Assert.assertEquals((String)string.trim(), (String)string2.trim());
    }

    public void testExecEngine() {
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            this.testExecEngineUNIX();
        } else {
            this.testExecEngineWindows();
        }
    }
}

