/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.tests;

import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.tests.TestSetUpEnvironment;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestJACLAction
extends TestCase {
    private ConfigAction m_caTest = null;
    private String m_sTestJACLActionPath = null;
    private String m_sExpectedCmd = null;
    private static final String S_PATH_UNIX = "/opt/WebSphere/App Server/install/full/actions/99Stest.jacl";
    private static final String S_PATH_WINDOWS = "C:\\WebSphere\\App Server\\install\\full\\actions\\99Stest.jacl";
    private static final String S_EXPECTED_CMD_UNIX = "sh -c \"\"/opt/WebSphere/App Server/wsadmin.sh\" -f \"/opt/WebSphere/App Server/install/full/actions/99Stest.jacl\"\"";
    private static final String S_EXPECTED_CMD_WINDOWS = "cmd.exe /c \"\"C:\\Program Files\\WebSphere\\AppServer\\wsadmin.bat\" -f \"C:\\WebSphere\\App Server\\install\\full\\actions\\99Stest.jacl\"\"";
    private static final int N_EXPECTED_ACTION_PRIORITY = 99;
    private static final boolean F_EXPECTED_ACTION_FATALITY_CODE = false;

    public TestJACLAction(String string) {
        super(string);
    }

    public void setUp() {
        TestSetUpEnvironment.setupEnvUsingJDKSysProperties();
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            this.m_sTestJACLActionPath = S_PATH_UNIX;
            this.m_sExpectedCmd = S_EXPECTED_CMD_UNIX;
        } else {
            this.m_sTestJACLActionPath = S_PATH_WINDOWS;
            this.m_sExpectedCmd = S_EXPECTED_CMD_WINDOWS;
        }
        this.m_caTest = ConfigAction.createAction(this.m_sTestJACLActionPath);
    }

    public void testJACLAction() {
        String string = this.m_caTest.getActionManualCommand();
        Assert.assertEquals((String)string, (String)this.m_sExpectedCmd);
    }

    public void testJACLActionPriority() {
        Assert.assertEquals((int)this.m_caTest.getThisActionPriority(), (int)99);
    }

    public void testJACLActionFatalityCode() {
        Assert.assertEquals((boolean)this.m_caTest.isActionFailureFatalToConfiguration(), (boolean)false);
    }
}

