/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.tests;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import com.ibm.ws.install.configmanager.tests.TestSetUpEnvironment;
import java.util.logging.Logger;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestLoggerFactory
extends TestCase {
    private static Logger m_logger = null;
    private static final String S_WAS_HOME_TEST_UNIX = PlatformConstants.getEnvironmentVariableValue("WSBLD") + "/code/install.configmanager/tests/WAS_HOME";
    private static final String S_WAS_HOME_TEST_WINDOWS = PlatformConstants.getEnvironmentVariableValue("WSBLD") + "\\code\\install.configmanager\\tests\\WAS_HOME";

    public TestLoggerFactory(String string) {
        super(string);
    }

    public void setUp() {
        TestSetUpEnvironment.setupEnvUsingJDKSysProperties();
        if (PlatformConstants.isCurrentPlatformUNIX()) {
            System.setProperty(ConfigManagerConstants.S_ARG_WAS_DIR, S_WAS_HOME_TEST_UNIX);
        } else {
            System.setProperty(ConfigManagerConstants.S_ARG_WAS_DIR, S_WAS_HOME_TEST_WINDOWS);
        }
    }

    public void testLoggerFactoryBootstrapping() {
        m_logger = LoggerFactory.createLogger(TestLoggerFactory.class);
        Assert.assertNotNull((Object)m_logger);
    }

    public void testLogger() {
        m_logger.entering(TestLoggerFactory.class.toString(), "testLogger");
        m_logger.severe("Test Severe");
        m_logger.warning("Test Warning");
        m_logger.info("Test Info");
        m_logger.config("Test Config");
        m_logger.fine("Test Fine");
        m_logger.finer("Test Finer");
        m_logger.finest("Test Finest");
        m_logger.exiting(TestLoggerFactory.class.toString(), "testLogger");
    }
}

