/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassPathModifier {
    private static final String S_JAR_FILE_PATTERN = "^.*\\.jar$";
    private static final String S_ERROR_ADDING_TO_CLASSPATH = "Error adding the given URL to the classpath";
    private static final String S_ADD_URL_METHOD_NAME = "addURL";
    private static final Logger LOGGER = LoggerFactory.createLogger(ClassPathModifier.class);
    private static final String S_CLASS_NAME = ClassPathModifier.class.getName();

    public static void addAllJARsInDirectoryToClassPath(String string) throws IOException {
        LOGGER.entering(ClassPathModifier.class.getName(), "addAllJARsInDirectoryToClassPath");
        Object[] objectArray = FileUtils.getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase(string, S_JAR_FILE_PATTERN);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addAllJARsInDirectoryToClassPath", "ListJAR files in found in " + string + " is: " + LogUtils.getArrayAsALoggableString(objectArray));
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = new File(string, (String)objectArray[i]).getAbsolutePath();
            ClassPathModifier.addFileToClassPath(string2);
        }
        LOGGER.exiting(ClassPathModifier.class.getName(), "addAllJARsInDirectoryToClassPath");
    }

    public static void addFileToClassPath(String string) throws IOException {
        LOGGER.entering(ClassPathModifier.class.getName(), "addFileToClassPath");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addFileToClassPath", "Adding this file to the system JVM classpath: " + string);
        ClassPathModifier.addURLToClassPath(new File(string).toURI().toURL());
        LOGGER.exiting(ClassPathModifier.class.getName(), "addFileToClassPath");
    }

    public static void addURLToClassPath(URL uRL) throws IOException {
        LOGGER.entering(ClassPathModifier.class.getName(), "addURLToClassPath");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "addURLToClassPath", "Adding this URL to the system JVM classpath: " + uRL.toString());
        try {
            URLClassLoader uRLClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Class clazz = URLClassLoader.class;
            Method method2 = clazz.getDeclaredMethod(S_ADD_URL_METHOD_NAME, URL.class);
            method2.setAccessible(true);
            method2.invoke((Object)uRLClassLoader, uRL);
        }
        catch (Throwable throwable) {
            LogUtils.logException(LOGGER, throwable);
            LOGGER.throwing(ClassPathModifier.class.getName(), "addURLToClassPath", new IOException(S_ERROR_ADDING_TO_CLASSPATH));
            throw new IOException(S_ERROR_ADDING_TO_CLASSPATH);
        }
        LOGGER.exiting(ClassPathModifier.class.getName(), "addURLToClassPath");
    }
}

