/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultValueManager {
    private Map m_mapDefaulters = null;
    private String m_sTemplatePath = "";
    private String m_sActionRegistry = "";
    private static final String S_DEFAULT_VALUE = null;
    private static final String S_DEFAULT_VALUE_KEY = "defaultValue";
    private static final String S_TEMPLATE_PATH = "templatePath";
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(DefaultValueManager.class);
    private static final String S_CLASS_NAME = DefaultValueManager.class.getName();
    private static final String S_DEFAULTED_VALUE_PATTERN = "(defaultValue=)(.*)";
    private static final Pattern PATTERN_DEFAULTED_VALUE = Pattern.compile("(defaultValue=)(.*)");
    private static final int N_NAME_GROUP_NO_DEFAULT_VALUE = 2;

    public DefaultValueManager(String string, String string2) {
        LOGGER.entering(DefaultValueManager.class.getName(), "DefaultValueManager");
        this.initialize(string, string2);
        LOGGER.exiting(DefaultValueManager.class.getName(), "DefaultValueManager");
    }

    public DefaultValueManager() {
        LOGGER.entering(DefaultValueManager.class.getName(), "DefaultValueManager");
        String string = DefaultValueManager.determineTemplatePath();
        String string2 = DefaultValueManager.determineActionRegistry();
        this.initialize(string, string2);
        LOGGER.exiting(DefaultValueManager.class.getName(), "DefaultValueManager");
    }

    public DefaultValueManager(Map map) {
        LOGGER.entering(DefaultValueManager.class.getName(), "DefaultValueManager");
        String string = DefaultValueManager.determineTemplatePath();
        String string2 = DefaultValueManager.determineActionRegistry();
        this.initialize(string, string2, map);
        LOGGER.exiting(DefaultValueManager.class.getName(), "DefaultValueManager");
    }

    public void reinitialize() {
        LOGGER.entering(DefaultValueManager.class.getName(), "reinitialize");
        this.m_mapDefaulters = null;
        this.initialize(this.m_sTemplatePath, this.m_sActionRegistry);
        LOGGER.exiting(DefaultValueManager.class.getName(), "reinitialize");
    }

    public String getDefaultValue(String string) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValue");
        Map map = this.addTemplateSpecificArguments(new Hashtable());
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map);
        ConfigAction configAction = (ConfigAction)this.m_mapDefaulters.get(string);
        String string2 = this.getDefaultValueFromDefaulter(configAction);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultValue", "Argument " + string + " was defaulted to: " + string2);
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValue");
        return string2;
    }

    public Hashtable getDefaultValues(String[] stringArray, Map map) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValues");
        Map map2 = this.addTemplateSpecificArguments(map);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map2);
        Hashtable hashtable = this.getDefaultValues(stringArray);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValues");
        return hashtable;
    }

    public Hashtable getDefaultValues(List list, Map map) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValues");
        String[] stringArray = this.convertListToStringArray(list);
        Map map2 = this.addTemplateSpecificArguments(map);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map2);
        Hashtable hashtable = this.getDefaultValues(stringArray);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValues");
        return hashtable;
    }

    public String[] getAllArgsInDefaultingOrder(String[] stringArray) {
        int n;
        Hashtable<ConfigAction, String> hashtable = new Hashtable<ConfigAction, String>();
        Vector<ConfigAction> vector = new Vector<ConfigAction>();
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                ConfigAction configAction = (ConfigAction)this.m_mapDefaulters.get(stringArray[n]);
                if (configAction == null) continue;
                vector.add(configAction);
                hashtable.put(configAction, stringArray[n]);
            }
        }
        Collections.sort(vector);
        String[] stringArray2 = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray2[n] = (String)hashtable.get(vector.get(n));
        }
        return stringArray2;
    }

    public boolean isArgumentAvailableForDefaulting(String string) {
        LOGGER.entering(DefaultValueManager.class.getName(), "isArgumentAvailableForDefaulting");
        ConfigAction configAction = (ConfigAction)this.m_mapDefaulters.get(string);
        LOGGER.exiting(DefaultValueManager.class.getName(), "isArgumentAvailableForDefaulting");
        return configAction != null;
    }

    public String getActionRegistry() {
        return this.m_sActionRegistry;
    }

    public String getTemplatePath() {
        return this.m_sTemplatePath;
    }

    public String toString() {
        return this.getActionRegistry();
    }

    private void initialize(String string, String string2) {
        LOGGER.entering(DefaultValueManager.class.getName(), "initialize");
        this.m_sTemplatePath = string;
        this.m_sActionRegistry = string2;
        if (string != null && string2 != null && !string.equals(S_EMPTY) && !string2.equals(S_EMPTY)) {
            Properties properties = SystemPropertiesUtils.getCurrentSystemProperties();
            System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, string2);
            this.m_mapDefaulters = ConfigManager.getDefaulterHashtable(string);
            SystemPropertiesUtils.resetSystemProperties(properties);
        } else {
            this.m_mapDefaulters = new Hashtable();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Created DefaultValueManager with templatePath=" + string + ", actionRegistry=" + string2);
        LOGGER.exiting(DefaultValueManager.class.getName(), "initialize");
    }

    private void initialize(String string, String string2, Map map) {
        LOGGER.entering(DefaultValueManager.class.getName(), "initialize");
        this.m_sTemplatePath = string;
        this.m_sActionRegistry = string2;
        this.m_mapDefaulters = string != null && string2 != null && !string.equals(S_EMPTY) && !string2.equals(S_EMPTY) ? map : new Hashtable();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Created DefaultValueManager with templatePath=" + string + ", actionRegistry=" + string2);
        LOGGER.exiting(DefaultValueManager.class.getName(), "initialize");
    }

    private Hashtable getDefaultValues(String[] stringArray) {
        ConfigAction configAction;
        int n;
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValues");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray.length);
        Vector<ConfigAction> vector = new Vector<ConfigAction>();
        Hashtable<ConfigAction, String> hashtable2 = new Hashtable<ConfigAction, String>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            configAction = (ConfigAction)this.m_mapDefaulters.get(stringArray[n]);
            if (configAction == null) continue;
            vector.add(configAction);
            hashtable2.put(configAction, stringArray[n]);
        }
        Collections.sort(vector);
        for (n = 0; n < vector.size(); ++n) {
            configAction = (ConfigAction)vector.get(n);
            String string = this.getDefaultValueFromDefaulter(configAction);
            String string2 = (String)hashtable2.get(configAction);
            if (string != null) {
                hashtable.put(string2, string);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultValues", "Argument " + string2 + " was defaulted to: " + string);
                System.setProperty(string2, string);
                continue;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getDefaultValues", "Argument " + string2 + " was not defaulted ");
        }
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValues");
        return hashtable;
    }

    private String parseOutputForDefault(String string) {
        LOGGER.entering(DefaultValueManager.class.getName(), "parseOutputForDefault");
        if (string == null) {
            return S_DEFAULT_VALUE;
        }
        Matcher matcher = PATTERN_DEFAULTED_VALUE.matcher(string);
        String string2 = S_DEFAULT_VALUE;
        if (matcher.find()) {
            string2 = matcher.group(2);
        }
        LOGGER.exiting(DefaultValueManager.class.getName(), "parseOutputForDefault");
        return string2;
    }

    private String getDefaultValueFromDefaulter(ConfigAction configAction) {
        LOGGER.entering(DefaultValueManager.class.getName(), "getDefaultValueFromDefaulter");
        if (configAction == null) {
            return S_DEFAULT_VALUE;
        }
        configAction.executeAction();
        String string = configAction.getActionOutput();
        String string2 = this.parseOutputForDefault(string);
        LOGGER.exiting(DefaultValueManager.class.getName(), "getDefaultValueFromDefaulter");
        return string2;
    }

    private Map addTemplateSpecificArguments(Map map) {
        LOGGER.entering(DefaultValueManager.class.getName(), "addTemplateSpecificArguments");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(map);
        if (hashtable.containsKey(S_TEMPLATE_PATH) && this.getTemplatePath() != null) {
            hashtable.put(S_TEMPLATE_PATH, this.getTemplatePath());
        }
        if (this.getTemplatePath() != null) {
            hashtable.put(ConfigManagerConstants.S_ARG_CONFIG_DIR, this.getTemplatePath());
        }
        if (this.getActionRegistry() != null) {
            hashtable.put(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, this.getActionRegistry());
        }
        LOGGER.exiting(DefaultValueManager.class.getName(), "addTemplateSpecificArguments");
        return hashtable;
    }

    private String[] convertListToStringArray(List list) {
        LOGGER.entering(DefaultValueManager.class.getName(), "convertVectorToStringArray");
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = (String)list.get(i);
        }
        LOGGER.exiting(DefaultValueManager.class.getName(), "convertVectorToStringArray");
        return stringArray;
    }

    private static String determineActionRegistry() {
        LOGGER.entering(DefaultValueManager.class.getName(), "determineActionRegistry");
        LOGGER.exiting(DefaultValueManager.class.getName(), "determineActionRegistry");
        return ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_ACTION_REGISTRY);
    }

    private static String determineTemplatePath() {
        LOGGER.entering(DefaultValueManager.class.getName(), "determineTemplatePath");
        LOGGER.exiting(DefaultValueManager.class.getName(), "determineTemplatePath");
        return ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR);
    }
}

