/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUtils {
    private static final String S_UNDERSCORE = "_";
    private static final String S_HTML = ".html";
    private static final String S_FILE_URL = "file://";
    private static final String S_DOT = ".";
    private static final Logger LOGGER = LoggerFactory.createLogger(FileUtils.class);
    private static final String S_CLASS_NAME = FileUtils.class.getName();

    public static String getLocaleFilePath(String string, String string2) {
        LOGGER.entering(FileUtils.class.getName(), "getLocaleFilePath");
        String string3 = Locale.getDefault().toString();
        String string4 = string + S_UNDERSCORE + string3 + S_DOT + string2;
        if (new File(string4).exists()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getLocaleFilePath", "Locale specific path for " + string + " is: " + string4);
            LOGGER.exiting(FileUtils.class.getName(), "getLocaleFilePath");
            return string4;
        }
        string3 = Locale.getDefault().getLanguage();
        string4 = string + S_UNDERSCORE + string3 + S_DOT + string2;
        if (new File(string4).exists()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getLocaleFilePath", "Locale specific path for " + string + " is: " + string4);
            LOGGER.exiting(FileUtils.class.getName(), "getLocaleFilePath");
            return string4;
        }
        string4 = string + S_DOT + string2;
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getLocaleFilePath", "Locale specific path for " + string + " is: " + string4);
        LOGGER.exiting(FileUtils.class.getName(), "getLocaleFilePath");
        return string4;
    }

    public static URL getFileURLForThisFilePath(String string) throws MalformedURLException {
        LOGGER.entering(FileUtils.class.getName(), "getFileURLForThisFilePath");
        if (string.toLowerCase().startsWith(S_FILE_URL)) {
            LOGGER.exiting(FileUtils.class.getName(), "getFileURLForThisFilePath");
            return new URL(string);
        }
        LOGGER.exiting(FileUtils.class.getName(), "getFileURLForThisFilePath");
        return new File(string).toURL();
    }

    public static String[] getAllFilesInThisDirectory(String string) {
        LOGGER.entering(FileUtils.class.getName(), "getAllFilesInThisDirectory");
        if (string == null) {
            return new String[0];
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectory", string + " is not a directory, returning an empty list");
            LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectory");
            return new String[0];
        }
        Object[] objectArray = file.list();
        if (objectArray == null || objectArray.length == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectory", string + " contains no files.");
            LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectory");
            return objectArray;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectory", string + " contains these files: " + LogUtils.getArrayAsALoggableString(objectArray));
        LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectory");
        return objectArray;
    }

    public static String[] getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase(String string, String string2) {
        LOGGER.entering(FileUtils.class.getName(), "getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase");
        String[] stringArray = FileUtils.getAllFilesInThisDirectory(string);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].toLowerCase().matches(string2.toLowerCase())) continue;
            vector.add(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.elementAt(i).toString();
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase", "List of files in " + string + " matching the pattern " + string2 + " is: " + LogUtils.getArrayAsALoggableString(objectArray));
        LOGGER.exiting(FileUtils.class.getName(), "getAllFilesInThisDirectoryMatchingThisPatternIgnoreCase");
        return objectArray;
    }

    public static String readFile(String string) throws IOException, FileNotFoundException {
        LOGGER.entering(FileUtils.class.getName(), "readFile");
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        String string2 = new String(byArray);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "readFile", "Contents read from " + string + " follow\n" + string2);
        fileInputStream.close();
        LOGGER.exiting(FileUtils.class.getName(), "readFile");
        return string2;
    }

    public static String makeSureDirectoryEndsWithASlash(String string) {
        LOGGER.entering(FileUtils.class.getName(), "makeSureDirectoryEndsWithASlash");
        String string2 = new String(string);
        if (!string2.substring(string2.length() - 1).equals(PlatformConstants.getFileSystemPathSeparator())) {
            string2 = string2 + PlatformConstants.getFileSystemPathSeparator();
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "makeSureDirectoryEndsWithASlash", "Incoming path was: " + string + ", outgoing is: " + string2);
        LOGGER.exiting(FileUtils.class.getName(), "makeSureDirectoryEndsWithASlash");
        return string2;
    }
}

