/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HashtableUtils {
    private static final String S_EQUALS = "=";
    private static final String S_EOLN = "\n";
    private static final Logger LOGGER = LoggerFactory.createLogger(HashtableUtils.class);
    private static final String S_CLASS_NAME = HashtableUtils.class.getName();

    public static boolean getHashtableValueAsBoolean(Object object, Hashtable hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "getHashtableValueAsBoolean");
        Object v = hashtable.get(object);
        if (v == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getHashtableValueAsBoolean", "Given key " + object.toString() + " was not found in the given hashtable, returning false");
            return false;
        }
        String string = v.toString();
        LOGGER.exiting(HashtableUtils.class.getName(), "getHashtableValueAsBoolean");
        return Boolean.valueOf(string);
    }

    public static String getHashtableValueAsString(Object object, Hashtable hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "getHashtableValueAsString");
        Object v = hashtable.get(object);
        if (v == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getHashtableValueAsString", "Given key " + object.toString() + " was not found in the given hashtable, returning an empty string");
            LOGGER.exiting(HashtableUtils.class.getName(), "getHashtableValueAsString");
            return new String();
        }
        String string = v.toString();
        LOGGER.exiting(HashtableUtils.class.getName(), "getHashtableValueAsString");
        return string;
    }

    public static void renameKey(Object object, Object object2, Hashtable hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "renameKey");
        Object v = hashtable.get(object);
        hashtable.remove(object);
        hashtable.put(object2, v);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "renameKey", "Renamed this key " + object.toString() + " to this " + object2.toString());
        LOGGER.exiting(HashtableUtils.class.getName(), "renameKey");
    }

    public static String convertHashtableToPropertiesString(Hashtable hashtable) {
        LOGGER.entering(HashtableUtils.class.getName(), "convertHashtableToPropertiesString");
        String string = new String();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                string = string + k.toString() + S_EQUALS + hashtable.get(k).toString() + S_EOLN;
            }
        }
        LOGGER.exiting(HashtableUtils.class.getName(), "convertHashtableToPropertiesString");
        return string;
    }
}

