/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemPropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.createLogger(SystemPropertiesUtils.class);
    private static final String S_CLASS_NAME = SystemPropertiesUtils.class.getName();
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";

    public static Properties setArgumentsIntoSystemProperties(String[] stringArray) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        Properties properties = SystemPropertiesUtils.getCurrentSystemProperties();
        SystemPropertiesUtils.setArgumentsIntoSystemProperties(SystemPropertiesUtils.convertCommandLineToHashtable(stringArray));
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        return properties;
    }

    public static Properties setArgumentsIntoSystemProperties(Map map) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        Properties properties = SystemPropertiesUtils.getCurrentSystemProperties();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            if (map.get(string) instanceof String) {
                object = (String)map.get(string);
                SystemPropertiesUtils.setValue(string, (String)object);
                continue;
            }
            if (map.get(string) instanceof Vector) {
                object = (Vector)map.get(string);
                if (((Vector)object).size() > 1) {
                    for (int i = 0; i < ((Vector)object).size(); ++i) {
                        SystemPropertiesUtils.setValue(string + (i + 1), ((Vector)object).elementAt(i).toString());
                    }
                }
                if (((Vector)object).size() == 1) {
                    SystemPropertiesUtils.setValue(string, ((Vector)object).elementAt(0).toString());
                }
                if (((Vector)object).size() != 0) continue;
                SystemPropertiesUtils.setValue(string, S_EMPTY);
                continue;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setArgumentsIntoSystemProperties", "Improperly formatted values for argument " + string);
        }
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "setArgumentsIntoSystemProperties");
        return properties;
    }

    public static Properties getCurrentSystemProperties() {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "getCurrentSystemProperties");
        Properties properties = (Properties)System.getProperties().clone();
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "getCurrentSystemProperties");
        return properties;
    }

    public static void resetSystemProperties(Properties properties) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "resetSystemProperties");
        System.setProperties(properties);
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "resetSystemProperties");
    }

    private static void setValue(String string, String string2) {
        if (string2 != null && !string2.equals(S_EMPTY)) {
            System.setProperty(string, string2);
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "setValue", "Set System property " + string);
        } else {
            System.setProperty(string, S_EMPTY);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setValue", "Set System property " + string + " with an empty value");
        }
    }

    private static Hashtable convertCommandLineToHashtable(String[] stringArray) {
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        if (stringArray.length == 0) {
            return hashtable;
        }
        if (!stringArray[0].startsWith(S_DASH)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "convertCommandLineToHashtable", "Invalid incoming command line");
            LOGGER.exiting(SystemPropertiesUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
            return hashtable;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n].substring(S_DASH.length());
            Vector vector = SystemPropertiesUtils.getArgumentValues(stringArray, n);
            hashtable.put(string, vector);
            n = n + vector.size() + 1;
        }
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "convertIncomingCommandLineToCommandLineArguments");
        return hashtable;
    }

    private static Vector getArgumentValues(String[] stringArray, int n) {
        String string;
        LOGGER.entering(SystemPropertiesUtils.class.getName(), "getArgumentValues");
        Vector<String> vector = new Vector<String>();
        for (int i = n + 1; i < stringArray.length && !(string = stringArray[i]).startsWith(S_DASH); ++i) {
            vector.add(string);
        }
        LOGGER.exiting(SystemPropertiesUtils.class.getName(), "getArgumentValues");
        return vector;
    }
}

