/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.ConfigManager;
import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidationManager {
    private Map m_mapValidators = null;
    private Map m_mapOmittedValidators = null;
    private Hashtable m_hashtableValidationErrorMessages = null;
    private String m_sTemplatePath = "";
    private String m_sActionRegistry = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(ValidationManager.class);
    private static final String S_CLASS_NAME = ValidationManager.class.getName();
    public static final String S_VALIDATION_ERROR_MSG_KEY = "validationErrorMessage";
    public static final String S_VALIDATION_VALUE_KEY = "validationValue";
    private static final String S_VALIDATION_VALUE_PATTERN = "(validationValue=)(.*)";
    private static final int N_NAME_GROUP_NO_VALIDATION_VALUE = 2;
    private static final Pattern PATTERN_VALIDATION_VALUE = Pattern.compile("(validationValue=)(.*)");
    private static final boolean F_DEFAULT_VALIDATION_VALUE = true;
    public static final String S_VALIDATOR_ARG_KEY = "validatorArgKey";
    private static final String S_TEMPLATE_PATH = "templatePath";
    private static final String S_COLON = ":";
    private static final String S_DELIM = ",";
    private static final String S_ALL_ARG = "all";

    public ValidationManager(String string, String string2) {
        LOGGER.entering(ValidationManager.class.getName(), "ValidationManager");
        this.initialize(string, string2);
        LOGGER.exiting(ValidationManager.class.getName(), "ValidationManager");
    }

    public ValidationManager() {
        LOGGER.entering(ValidationManager.class.getName(), "ValidationManager");
        String string = ValidationManager.determineTemplatePath();
        String string2 = ValidationManager.determineActionRegistry();
        this.initialize(string, string2);
        LOGGER.exiting(ValidationManager.class.getName(), "ValidationManager");
    }

    private void initialize(String string, String string2) {
        LOGGER.entering(ValidationManager.class.getName(), "initialize");
        this.m_sTemplatePath = string;
        this.m_sActionRegistry = string2;
        Properties properties = SystemPropertiesUtils.getCurrentSystemProperties();
        System.setProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, string2);
        this.m_mapValidators = ConfigManager.getValidatorHashtable(string);
        this.m_hashtableValidationErrorMessages = new Hashtable();
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Created ValidationManager with templatePath=" + string + ", actionRegistry=" + string2);
        LOGGER.exiting(ValidationManager.class.getName(), "initialize");
    }

    private Map getOmittedValidators() {
        String[] stringArray = ArgumentValueFetcher.getArgumentValues("omitValidation");
        if (stringArray == null || stringArray.length <= 0) {
            return null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            int n = stringArray[i].indexOf(S_COLON);
            if (n <= 0) continue;
            String string = stringArray[i].substring(0, n);
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i].substring(n + 1), S_DELIM);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (vector.contains(object)) continue;
                vector.add((String)object);
            }
            if (hashtable.get(string) == null) {
                hashtable.put(string, vector);
                continue;
            }
            object = (Vector)hashtable.get(string);
            for (int j = 0; j < vector.size(); ++j) {
                if (((Vector)object).contains(vector.get(j))) continue;
                ((Vector)object).add(vector.get(j));
            }
            hashtable.put(string, object);
        }
        return hashtable;
    }

    public boolean areAllArgumentsValid(Map map) {
        LOGGER.entering(ValidationManager.class.getName(), "areAllArgumentsValid");
        Map map2 = this.addTemplateSpecificArguments(map);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map2);
        this.clearErrorMessages();
        boolean bl = this.areAllArgumentsValid();
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManager.class.getName(), "areAllArgumentsValid");
        return bl;
    }

    public Hashtable getAllErrorMessages() {
        LOGGER.entering(ValidationManager.class.getName(), "getAllErrorMessages");
        LOGGER.exiting(ValidationManager.class.getName(), "getAllErrorMessages");
        return this.m_hashtableValidationErrorMessages;
    }

    public List getErrorMessagesForArgument(String string) {
        LOGGER.entering(ValidationManager.class.getName(), "initialize");
        LOGGER.exiting(ValidationManager.class.getName(), "parseOutputForErrorMessage");
        return (List)this.m_hashtableValidationErrorMessages.get(string);
    }

    public boolean isArgumentValueValid(String string, Map map) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        Map map2 = this.addTemplateSpecificArguments(map);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map2);
        this.clearErrorMessages();
        boolean bl = this.validateAllValidatorsForArgument(string);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return bl;
    }

    public boolean isArgumentValueValid(String string, String string2) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(string, string2);
        Map map = this.addTemplateSpecificArguments(hashtable);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map);
        this.clearErrorMessages();
        boolean bl = this.isArgumentValueValid(string);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return bl;
    }

    public boolean isArgumentValueValid(String string, String string2, Map map) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(map);
        hashtable.put(string, string2);
        Map map2 = this.addTemplateSpecificArguments(hashtable);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map2);
        this.clearErrorMessages();
        boolean bl = this.isArgumentValueValid(string);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return bl;
    }

    public boolean areAllArgumentsValid(List list, Map map) {
        LOGGER.entering(ValidationManager.class.getName(), "areAllArgumentsValid");
        boolean bl = true;
        Map map2 = this.addTemplateSpecificArguments(map);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map2);
        this.clearErrorMessages();
        for (int i = 0; i < list.size(); ++i) {
            if (this.validateAllValidatorsForArgument((String)list.get(i))) continue;
            bl = false;
        }
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return bl;
    }

    public boolean isArgumentAvailableForValidating(String string) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentAvailableForValidating");
        Vector vector = (Vector)this.m_mapValidators.get(string);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentAvailableForValidating");
        return vector != null;
    }

    public void reinitialize() {
        LOGGER.entering(ValidationManager.class.getName(), "reinitialize");
        this.m_mapValidators = null;
        this.m_hashtableValidationErrorMessages = null;
        this.initialize(this.m_sTemplatePath, this.m_sActionRegistry);
        LOGGER.exiting(ValidationManager.class.getName(), "reinitialize");
    }

    public String toString() {
        return this.getActionRegistry();
    }

    public String getActionRegistry() {
        return this.m_sActionRegistry;
    }

    public String getTemplatePath() {
        return this.m_sTemplatePath;
    }

    private boolean areAllArgumentsValid() {
        LOGGER.entering(ValidationManager.class.getName(), "areAllArgumentsValid");
        boolean bl = true;
        Iterator iterator = this.m_mapValidators.keySet().iterator();
        while (iterator.hasNext()) {
            if (this.validateAllValidatorsForArgument((String)iterator.next())) continue;
            bl = false;
        }
        LOGGER.exiting(ValidationManager.class.getName(), "areAllArgumentsValid");
        return bl;
    }

    private boolean isArgumentValueValid(String string) {
        LOGGER.entering(ValidationManager.class.getName(), "isArgumentValueValid");
        boolean bl = this.validateAllValidatorsForArgument(string);
        LOGGER.exiting(ValidationManager.class.getName(), "isArgumentValueValid");
        return bl;
    }

    private List parseOutputForErrorMessages(String string) {
        LOGGER.entering(ValidationManager.class.getName(), "parseOutputForErrorMessages");
        Vector<String> vector = new Vector<String>();
        if (string == null || string.equals("")) {
            return vector;
        }
        String[] stringArray = string.split("validationErrorMessage=");
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray == null || stringArray[i].equals("")) continue;
            vector.add(stringArray[i].trim());
        }
        LOGGER.exiting(ValidationManager.class.getName(), "parseOutputForErrorMessages");
        return vector;
    }

    private boolean parseOutputForValidationValue(String string) {
        LOGGER.entering(ValidationManager.class.getName(), "parseOutputForValidationValue");
        if (string == null || string.equals("")) {
            return true;
        }
        Matcher matcher = PATTERN_VALIDATION_VALUE.matcher(string);
        boolean bl = true;
        if (matcher.find()) {
            bl = Boolean.valueOf(matcher.group(2));
        }
        LOGGER.exiting(ValidationManager.class.getName(), "parseOutputForValidationValue");
        return bl;
    }

    private void storeErrorMessage(String string, String string2) {
        List<String> list;
        LOGGER.entering(ValidationManager.class.getName(), "storeErrorMessage");
        if (this.m_hashtableValidationErrorMessages.containsKey(string) && (list = (List)this.m_hashtableValidationErrorMessages.get(string)) != null && list.size() != 0) {
            List list2 = this.parseOutputForErrorMessages(string2);
            for (int i = 0; i < list2.size(); ++i) {
                String string3 = (String)list2.get(i);
                if (list.contains(string3)) continue;
                list.add(string3);
                LOGGER.exiting((class$com$ibm$ws$install$configmanager$utils$ValidationManager == null ? ValidationManager.class$("com.ibm.ws.install.configmanager.utils.ValidationManager") : class$com$ibm$ws$install$configmanager$utils$ValidationManager).getName(), "storeErrorMessage");
            }
            return;
        }
        list = new Vector();
        List list3 = this.parseOutputForErrorMessages(string2);
        for (int i = 0; i < list3.size(); ++i) {
            String string4 = (String)list3.get(i);
            if (((Vector)list).contains(string4)) continue;
            ((Vector)list).add(string4);
            LOGGER.exiting((class$com$ibm$ws$install$configmanager$utils$ValidationManager == null ? ValidationManager.class$("com.ibm.ws.install.configmanager.utils.ValidationManager") : class$com$ibm$ws$install$configmanager$utils$ValidationManager).getName(), "storeErrorMessage");
        }
        this.m_hashtableValidationErrorMessages.put(string, list);
        LOGGER.exiting(ValidationManager.class.getName(), "storeErrorMessage");
    }

    private void clearErrorMessages() {
        LOGGER.entering(ValidationManager.class.getName(), "clearErrorMessages");
        LOGGER.exiting(ValidationManager.class.getName(), "clearErrorMessages");
        this.m_hashtableValidationErrorMessages = new Hashtable();
    }

    private Map addTemplateSpecificArguments(Map map) {
        LOGGER.entering(ValidationManager.class.getName(), "addTemplateSpecificArguments");
        Hashtable<String, String> hashtable = new Hashtable<String, String>(map);
        if (hashtable.containsKey(S_TEMPLATE_PATH)) {
            hashtable.put(S_TEMPLATE_PATH, this.getTemplatePath());
        }
        hashtable.put(ConfigManagerConstants.S_ARG_CONFIG_DIR, this.getTemplatePath());
        hashtable.put(ConfigManagerConstants.S_ARG_ACTION_REGISTRY, this.getActionRegistry());
        LOGGER.exiting(ValidationManager.class.getName(), "addTemplateSpecificArguments");
        return hashtable;
    }

    private boolean validateAllValidatorsForArgument(String string) {
        List list;
        LOGGER.entering(ValidationManager.class.getName(), "validateAllValidatorsForArgument");
        boolean bl = true;
        this.m_mapOmittedValidators = this.getOmittedValidators();
        if (this.m_mapOmittedValidators == null) {
            this.m_mapOmittedValidators = new Hashtable();
        }
        if ((list = (List)this.m_mapValidators.get(string)) == null || list.size() == 0) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateAllValidatorsForArgument", "No validators found for argument" + string);
            LOGGER.exiting(ValidationManager.class.getName(), "validateAllValidatorsForArgument");
            return true;
        }
        Properties properties = SystemPropertiesUtils.getCurrentSystemProperties();
        System.setProperty(S_VALIDATOR_ARG_KEY, string);
        Vector vector = (Vector)this.m_mapOmittedValidators.get(string);
        if (vector == null) {
            vector = new Vector();
        }
        for (int i = 0; i < list.size(); ++i) {
            ConfigAction configAction = (ConfigAction)list.get(i);
            if (!vector.contains(S_ALL_ARG) && !vector.contains(configAction.getActionName())) {
                configAction.executeAction();
                String string2 = configAction.getActionOutput();
                boolean bl2 = this.parseOutputForValidationValue(string2);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateAllValidatorsForArgument", "Argument " + string + " passed validation? " + bl2);
                if (bl2) continue;
                bl = bl2;
                this.storeErrorMessage(string, string2);
                continue;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateAllValidatorsForArgument", "Skipped execution of:" + configAction.getActionName());
        }
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManager.class.getName(), "validateAllValidatorsForArgument");
        return bl;
    }

    private static String determineActionRegistry() {
        LOGGER.entering(ValidationManager.class.getName(), "determineActionRegistry");
        LOGGER.exiting(ValidationManager.class.getName(), "determineActionRegistry");
        return ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_ACTION_REGISTRY);
    }

    private static String determineTemplatePath() {
        LOGGER.entering(ValidationManager.class.getName(), "determineTemplatePath");
        LOGGER.exiting(ValidationManager.class.getName(), "determineTemplatePath");
        return ArgumentValueFetcher.getArgumentValue(ConfigManagerConstants.S_ARG_CONFIG_DIR);
    }
}

