/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jtaextensions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ImplFactory;

public final class EnhancedFeaturesAvailabilityManager {
    private static final TraceComponent tc = Tr.register(EnhancedFeaturesAvailabilityManager.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final String extendedJTATxImplKey = "com.ibm.ws.transaction.ExtendedJTATransaction";
    private static boolean extendedJTATransactionChecked;
    private static boolean extendedJTATransactionAvailable;
    private static final String workloadCollaboratorImplKey = "com.ibm.ws.transaction.WorkloadCollaborator";
    private static boolean workloadCollaboratorChecked;
    private static boolean workloadCollaboratorAvailable;

    private EnhancedFeaturesAvailabilityManager() {
    }

    public static boolean isExtendedJTATransactionAvailable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isExtendedJTATransactionAvailable");
        }
        if (!extendedJTATransactionChecked) {
            try {
                ImplFactory.loadClassFromKey(extendedJTATxImplKey);
                extendedJTATransactionAvailable = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.jtaextensions.EnhancedFeaturesAvailabilityManager.isExtendedJTATransactionAvailable", "67");
                extendedJTATransactionAvailable = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "extendedJTATransactionAvailable: " + extendedJTATransactionAvailable);
            }
            extendedJTATransactionChecked = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isExtendedJTATransactionAvailable");
        }
        return extendedJTATransactionAvailable;
    }

    public static boolean isWorkloadCollaboratorAvailable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isWorkloadCollaboratorAvailable");
        }
        if (!workloadCollaboratorChecked) {
            try {
                ImplFactory.loadClassFromKey(workloadCollaboratorImplKey);
                workloadCollaboratorAvailable = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.jtaextensions.EnhancedFeaturesAvailabilityManager.isWorkloadCollaboratorAvailable", "112");
                workloadCollaboratorAvailable = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "workload collaborator available: " + workloadCollaboratorAvailable);
            }
            workloadCollaboratorChecked = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isWorkloadCollaboratorAvailable");
        }
        return workloadCollaboratorAvailable;
    }
}

