/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jtaextensions;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.jtaextensions.CallbackNotRegisteredException;
import com.ibm.websphere.jtaextensions.ExtendedJTATransaction;
import com.ibm.websphere.jtaextensions.NotSupportedException;
import com.ibm.websphere.jtaextensions.SynchronizationCallback;
import com.ibm.ws.Transaction.JTA.LocalTIDTable;
import com.ibm.ws.Transaction.JTA.TranManagerSet;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jtaextensions.SynchronizationCallbackWrapper;
import java.util.ArrayList;
import javax.transaction.RollbackException;

public final class ExtendedJTATransactionImpl
implements ExtendedJTATransaction {
    private static final ArrayList _syncLevels = new ArrayList();
    private static int _syncLevel = -1;
    private static final TraceComponent tc = Tr.register(ExtendedJTATransactionImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    public byte[] getGlobalId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getGlobalId");
        }
        byte[] byArray = null;
        TransactionImpl transactionImpl = TranManagerSet.instance().getTransactionImpl();
        if (transactionImpl != null) {
            byArray = transactionImpl.getTID();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getGlobalId", byArray);
        }
        return byArray;
    }

    public int getLocalId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getLocalId");
        }
        int n = 0;
        TransactionImpl transactionImpl = TranManagerSet.instance().getTransactionImpl();
        if (transactionImpl != null) {
            n = (int)transactionImpl.getLocalTID();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalId", new Integer(n));
        }
        return n;
    }

    public synchronized void registerSynchronizationCallback(SynchronizationCallback synchronizationCallback) throws NotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSynchronizationCallback", synchronizationCallback);
        }
        if (synchronizationCallback == null) {
            NullPointerException nullPointerException = new NullPointerException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSynchronizationCallback", nullPointerException);
            }
            throw nullPointerException;
        }
        if (_syncLevel < 0) {
            ArrayList<SynchronizationCallback> arrayList = new ArrayList<SynchronizationCallback>();
            arrayList.add(synchronizationCallback);
            ExtendedJTATransactionImpl.setLevel(arrayList);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSynchronizationCallback", new Integer(_syncLevel));
            }
            return;
        }
        ArrayList arrayList = (ArrayList)_syncLevels.get(_syncLevel);
        if (arrayList == null) {
            ArrayList<SynchronizationCallback> arrayList2 = new ArrayList<SynchronizationCallback>();
            arrayList2.add(synchronizationCallback);
            ExtendedJTATransactionImpl.setLevel(arrayList2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSynchronizationCallback", new Integer(_syncLevel));
            }
            return;
        }
        ArrayList<SynchronizationCallback> arrayList3 = new ArrayList<SynchronizationCallback>(arrayList);
        arrayList3.add(synchronizationCallback);
        ExtendedJTATransactionImpl.setLevel(arrayList3);
        ExtendedJTATransactionImpl.garbageCollectUnusedLevels();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSynchronizationCallback", new Integer(_syncLevel));
        }
    }

    public synchronized void registerSynchronizationCallbackForCurrentTran(SynchronizationCallback synchronizationCallback) throws NotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSynchronizationCallbackForCurrentTran", synchronizationCallback);
        }
        if (synchronizationCallback == null) {
            NullPointerException nullPointerException = new NullPointerException("SynchronizationCallback is null");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSynchronizationCallbackForCurrentTran", nullPointerException);
            }
            throw nullPointerException;
        }
        TransactionImpl transactionImpl = TranManagerSet.instance().getTransactionImpl();
        if (transactionImpl == null) {
            NotSupportedException notSupportedException = new NotSupportedException();
            Tr.event(tc, "No current transaction");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSynchronizationCallbackForCurrentTran", notSupportedException);
            }
            throw notSupportedException;
        }
        SynchronizationCallbackWrapper synchronizationCallbackWrapper = new SynchronizationCallbackWrapper(synchronizationCallback, (int)transactionImpl.getLocalTID(), transactionImpl.getTID());
        try {
            transactionImpl.registerSynchronization(synchronizationCallbackWrapper, 0);
        }
        catch (RollbackException rollbackException) {
            FFDCFilter.processException((Throwable)rollbackException, "com.ibm.ws.jtaextensions.ExtendedJTATransactionImpl.registerSynchronizationCallbackForCurrentTran", "325", this);
            NotSupportedException notSupportedException = new NotSupportedException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSynchronizationCallbackForCurrentTran", notSupportedException);
            }
            throw notSupportedException;
        }
        catch (IllegalStateException illegalStateException) {
            FFDCFilter.processException((Throwable)illegalStateException, "com.ibm.ws.jtaextensions.ExtendedJTATransactionImpl.registerSynchronizationCallbackForCurrentTran", "333", this);
            NotSupportedException notSupportedException = new NotSupportedException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "registerSynchronizationCallbackForCurrentTran", notSupportedException);
            }
            throw notSupportedException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSynchronizationCallbackForCurrentTran");
        }
    }

    public synchronized void unRegisterSynchronizationCallback(SynchronizationCallback synchronizationCallback) throws CallbackNotRegisteredException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterSynchronization", synchronizationCallback);
        }
        if (synchronizationCallback == null || _syncLevel < 0) {
            CallbackNotRegisteredException callbackNotRegisteredException = new CallbackNotRegisteredException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "unregisterSynchronization", callbackNotRegisteredException);
            }
            throw callbackNotRegisteredException;
        }
        ArrayList arrayList = (ArrayList)_syncLevels.get(_syncLevel);
        if (arrayList == null || !arrayList.contains(synchronizationCallback)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "unregisterSynchronization", "Sync not registered");
            }
            throw new CallbackNotRegisteredException();
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        int n = arrayList2.lastIndexOf(synchronizationCallback);
        arrayList2.remove(n);
        ExtendedJTATransactionImpl.setLevel(arrayList2);
        ExtendedJTATransactionImpl.garbageCollectUnusedLevels();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unregisterSynchronization");
        }
    }

    public static void beforeCompletion(TransactionImpl transactionImpl, int n) {
        ArrayList arrayList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion", new Object[]{transactionImpl, new Integer(n)});
        }
        if (n >= 0 && (arrayList = (ArrayList)_syncLevels.get(n)) != null) {
            int n2 = (int)transactionImpl.getLocalTID();
            byte[] byArray = transactionImpl.getTID();
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                ((SynchronizationCallback)arrayList.get(i)).beforeCompletion(n2, byArray);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    public static void afterCompletion(TransactionImpl transactionImpl, int n, int n2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion", new Object[]{transactionImpl, new Integer(n), new Integer(n2)});
        }
        if (n2 >= 0) {
            ArrayList arrayList = (ArrayList)_syncLevels.get(n2);
            if (arrayList != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "syncs.length=" + arrayList.size());
                }
                int n3 = (int)transactionImpl.getLocalTID();
                byte[] byArray = transactionImpl.getTID();
                boolean bl = n != 4;
                int n4 = arrayList.size();
                for (int i = 0; i < n4; ++i) {
                    try {
                        ((SynchronizationCallback)arrayList.get(i)).afterCompletion(n3, byArray, bl);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "WTRN0074_SYNCHRONIZATION_EXCEPTION", new Object[]{"afterCompletion", arrayList.get(i), throwable});
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "syncs is null");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public static boolean callbacksRegistered() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "callbacksRegistered");
        }
        if (_syncLevel < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "callbacksRegistered", Boolean.FALSE);
            }
            return false;
        }
        int n = _syncLevels.size();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList = (ArrayList)_syncLevels.get(_syncLevel);
            if (arrayList == null || arrayList.isEmpty()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "callbacksRegistered", Boolean.TRUE);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "callbacksRegistered", Boolean.FALSE);
        }
        return false;
    }

    private static int nextLevel() {
        int n = _syncLevels.size();
        for (int i = 0; i < n; ++i) {
            if (_syncLevels.get(i) != null) continue;
            return i;
        }
        return n;
    }

    public static int getSyncLevel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Sync level: " + _syncLevel);
        }
        return _syncLevel;
    }

    private static void garbageCollectUnusedLevels() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "garbageCollectUnusedLevels");
        }
        int n = _syncLevels.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Levels: " + n);
        }
        if (n < 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "garbageCollectUnusedLevels", "Doing nothing");
            }
            return;
        }
        int[] nArray = new int[n];
        TransactionImpl[] transactionImplArray = LocalTIDTable.getAllTransactions();
        int n2 = transactionImplArray.length;
        while (--n2 >= 0) {
            int n3 = transactionImplArray[n2].getExtJTASyncLevel();
            if (n3 < 0 || n3 >= n) continue;
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
        }
        n2 = nArray.length;
        while (--n2 >= 0) {
            if (n2 == _syncLevel || nArray[n2] != 0) continue;
            _syncLevels.set(n2, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "garbageCollectUnusedLevels", new Integer(_syncLevels.size()));
        }
    }

    private static void setLevel(ArrayList arrayList) {
        _syncLevel = ExtendedJTATransactionImpl.nextLevel();
        if (_syncLevel == _syncLevels.size()) {
            _syncLevels.add(arrayList);
        } else {
            _syncLevels.set(_syncLevel, arrayList);
        }
    }
}

