/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.leasemanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.leasemanager.Lease;
import com.ibm.ws.leasemanager.LeaseException;
import com.ibm.ws.leasemanager.LeaseHijackedException;
import com.ibm.ws.leasemanager.LeaseManagerNotAvailableException;
import com.ibm.ws.leasemanager.impl.LeaseInfoImpl;
import com.ibm.ws.leasemanager.impl.LeaseStore;
import com.ibm.ws.scheduler.resources.Messages;
import java.util.Map;

public class LeaseImpl
extends LeaseInfoImpl
implements Lease {
    protected static final TraceComponent TC = Tr.register(LeaseImpl.class, "LeaseManager", "");
    private LeaseStore leaseStore = null;
    private boolean isCancelled = false;

    public LeaseImpl(String string, String string2, long l, Map map, LeaseStore leaseStore) {
        super(string, string2, l, map);
        this.leaseName = string;
        this.leaseOwner = string2;
        this.leaseExpireTime = this.getDate(l);
        this.map = map;
        this.leaseStore = leaseStore;
    }

    public synchronized void cancel() throws LeaseException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "cancel()");
        }
        if (this.isCancelled || this.leaseStore == null) {
            throw new LeaseManagerNotAvailableException(Messages.getMessage("SCHD0305E", this.getResourceName()));
        }
        this.leaseStore.cancel(this.leaseName, this.leaseOwner);
        this.isCancelled = true;
        this.reset();
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "cancel()");
        }
    }

    public synchronized void renew(long l) throws LeaseHijackedException, LeaseManagerNotAvailableException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "renew()", String.valueOf(l));
        }
        if (this.isCancelled || this.leaseStore == null) {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "renew() lease canceled or lease store was null");
            }
            throw new LeaseManagerNotAvailableException(Messages.getMessage("SCHD0305E", this.getResourceName()));
        }
        if (l < 1L) {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "renew() wrong renew time");
            }
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new String[]{"intervalInMs", ">=0"}));
        }
        try {
            long l2 = this.leaseStore.renew(this.leaseName, this.leaseOwner, l);
            this.leaseExpireTime = this.getDate(l2);
        }
        catch (LeaseHijackedException leaseHijackedException) {
            this.isCancelled = true;
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "renew() lease hijacked");
            }
            throw leaseHijackedException;
        }
        catch (LeaseException leaseException) {
            FFDCFilter.processException((Throwable)leaseException, "com.ibm.ws.leasemanager.impl.LeaseImpl.renew", "156", this);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "renew() lease exception ");
            }
            throw new LeaseManagerNotAvailableException(leaseException.getLocalizedMessage());
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "renew()");
        }
    }

    public void setResourceProperties(Map map) throws LeaseHijackedException, LeaseManagerNotAvailableException, IllegalArgumentException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "setResourceProperties()", map);
        }
        if (this.isCancelled || this.leaseStore == null) {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "setResourceProperties() lease cancelled or lease store is null");
            }
            throw new LeaseManagerNotAvailableException(Messages.getMessage("SCHD0305E", this.getResourceName()));
        }
        this.map = map;
        long l = System.currentTimeMillis();
        if (this.getDate(l).after(this.leaseExpireTime)) {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "setResourceProperties() lease may be hijacked currentTime > expiryTime, renew needed");
            }
            throw new LeaseHijackedException(Messages.getMessage("SCHD0306E", this.getResourceName()));
        }
        this.leaseStore.setOwnerProperties(this.leaseName, map);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "setResourceProperties()");
        }
    }

    private void reset() {
        this.leaseExpireTime = null;
        this.leaseOwner = null;
        this.map = null;
        this.leaseStore = null;
        this.isCancelled = true;
    }
}

