/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.leasemanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.extensionhelper.DatabaseHelper;
import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.leasemanager.impl.LeaseStore;
import com.ibm.ws.leasemanager.impl.LeaseStoreImpl;
import com.ibm.ws.leasemanager.impl.LeaseStoreImplDB2;
import com.ibm.ws.leasemanager.impl.LeaseStoreImplDerby;
import com.ibm.ws.leasemanager.impl.LeaseStoreImplInformix;
import com.ibm.ws.leasemanager.impl.LeaseStoreImplInformix7;
import com.ibm.ws.leasemanager.impl.LeaseStoreImplMSSQL;
import com.ibm.ws.leasemanager.impl.LeaseStoreImplOracle;
import com.ibm.ws.leasemanager.impl.LeaseStoreImplSybase;
import com.ibm.ws.scheduler.resources.Messages;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class LeaseManagerDBHelper
implements DatabaseHelper {
    private static final TraceComponent TC = Tr.register(LeaseManagerDBHelper.class, "LeaseManager", "");
    private DatabaseHelper dbHelper;
    private boolean tablesSetupProperly = false;

    public LeaseManagerDBHelper(Map map) throws UnableToInitializeException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "LeaseManagerDBHelper()", LeaseManagerDBHelper.hidePassword(map));
        }
        try {
            InitialContext initialContext = new InitialContext();
            Object object = initialContext.lookup("services:websphere/ExtensionHelper");
            if (TC.isDebugEnabled()) {
                Tr.debug(TC, "LeaseManagerDBHelper()", object);
            }
            if (object == null) {
                throw new UnableToInitializeException(Messages.getMessage("ERR_NO_SERVICE", "services:websphere/ExtensionHelper"));
            }
            this.setup((ExtensionHelper)object, map);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.leasemanager.impl.LeaseManagerDBHelper.LeaseManagerDBHelper", "101", this);
            namingException.printStackTrace();
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getLeaseStore()");
        }
    }

    public LeaseManagerDBHelper(ExtensionHelper extensionHelper, Map map) throws UnableToInitializeException {
        this.setup(extensionHelper, map);
    }

    static Map hidePassword(Map hashMap) {
        if (hashMap != null) {
            if ((hashMap = new HashMap<String, String>(hashMap)).containsKey("dbhelper.password")) {
                hashMap.put("dbhelper.password", "******");
            }
            if (hashMap.containsKey("password")) {
                hashMap.put("password", "******");
            }
        }
        return hashMap;
    }

    private void setup(ExtensionHelper extensionHelper, Map map) throws UnableToInitializeException {
        this.dbHelper = extensionHelper.getDatabaseHelper(map);
        if (this.dbHelper.existsTable(this.dbHelper.getRealTableName("LMGR")) && this.dbHelper.existsTable(this.dbHelper.getRealTableName("LMPR"))) {
            this.tablesSetupProperly = true;
        }
    }

    public LeaseStore getLeaseStore() {
        String string;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getLeaseStore()", new Object[0]);
        }
        if ((string = this.dbHelper.getDatabaseType()).equals("ORACLE")) {
            return new LeaseStoreImplOracle(this);
        }
        if (string.equals("DB2") || string.equals("DB2ISERIES") || string.equals("DB2ZSERIES")) {
            return new LeaseStoreImplDB2(this);
        }
        if (string.equals("SYBASE")) {
            return new LeaseStoreImplSybase(this);
        }
        if (string.equals("INFORMIX")) {
            return new LeaseStoreImplInformix(this);
        }
        if (string.equals("INFORMIX7")) {
            return new LeaseStoreImplInformix7(this);
        }
        if (string.equals("MSSQL")) {
            return new LeaseStoreImplMSSQL(this);
        }
        if (string.equals("MSSQL7")) {
            return new LeaseStoreImplMSSQL(this);
        }
        if (string.equals("DERBY")) {
            return new LeaseStoreImplDerby(this);
        }
        return new LeaseStoreImpl(this);
    }

    public TransactionControl getTranControl() {
        return this.getTransactionControl();
    }

    public Connection getConnection() throws SQLException {
        return this.dbHelper.getConnection();
    }

    public String getDatabaseType() {
        return this.dbHelper.getDatabaseType();
    }

    public DataSource getDataSource() {
        return this.dbHelper.getDataSource();
    }

    public String getRealTableName(String string) {
        return this.dbHelper.getRealTableName(string);
    }

    public String getSQLStatement(String string, String string2, String string3) {
        return this.dbHelper.getSQLStatement(string, string2, string3);
    }

    public String getSQLStatement(String string, String string2) {
        return this.dbHelper.getSQLStatement(string, string2);
    }

    public void returnConnection(Connection connection) throws SQLException {
        this.dbHelper.returnConnection(connection);
    }

    public void dumpNestedSQLException(SQLException sQLException) {
        this.dbHelper.dumpNestedSQLException(sQLException);
    }

    public void dumpSQLExceptionInfo(Throwable throwable) {
        this.dbHelper.dumpSQLExceptionInfo(throwable);
    }

    public boolean existsTable(String string) {
        return this.dbHelper.existsTable(string);
    }

    public boolean existsTable(String string, Connection connection) {
        return this.dbHelper.existsTable(string, connection);
    }

    public boolean isTablesSetupProperly() {
        return this.tablesSetupProperly;
    }

    public String getTablePrefixName() {
        return this.dbHelper.getTablePrefixName();
    }

    public Connection getConnection(TxHandle txHandle) throws SQLException {
        return this.getConnection(txHandle);
    }

    public TransactionControl getTransactionControl() {
        return this.dbHelper.getTransactionControl();
    }
}

