/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.leasemanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.extensionhelper.exception.UnableToInitializeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.leasemanager.Lease;
import com.ibm.ws.leasemanager.LeaseException;
import com.ibm.ws.leasemanager.LeaseManagerNotAvailableException;
import com.ibm.ws.leasemanager.LeaseManagerService;
import com.ibm.ws.leasemanager.LeaseNotAvailableException;
import com.ibm.ws.leasemanager.impl.LeaseImpl;
import com.ibm.ws.leasemanager.impl.LeaseManagerDBHelper;
import com.ibm.ws.leasemanager.impl.LeaseStore;
import com.ibm.ws.scheduler.WASSchedulerCfgHelper;
import com.ibm.ws.scheduler.resources.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class LeaseManagerServiceImpl
implements LeaseManagerService {
    protected static final TraceComponent TC = Tr.register(LeaseManagerServiceImpl.class, "LeaseManager", "");
    private static LeaseManagerService leaseManager = null;
    private LeaseManagerDBHelper dbHelper = null;
    private LeaseStore leaseStore = null;
    public static final String DEFAULT_STATEMENT_FILE = "com/ibm/ws/leasemanager/impl/leasemanager_statements.properties";

    private LeaseManagerServiceImpl(Properties properties) throws LeaseManagerNotAvailableException {
        try {
            this.dbHelper = new LeaseManagerDBHelper(this.getDatabaseData(properties));
        }
        catch (UnableToInitializeException unableToInitializeException) {
            FFDCFilter.processException((Throwable)unableToInitializeException, "com.ibm.ws.leasemanager.impl.LeaseManagerServiceImpl.LeaseManagerServiceImpl", "79", this);
            throw new LeaseManagerNotAvailableException(unableToInitializeException.getLocalizedMessage(), unableToInitializeException);
        }
        if (!this.dbHelper.isTablesSetupProperly()) {
            throw new LeaseManagerNotAvailableException(Messages.getMessage("SCHD0121E"));
        }
        this.leaseStore = this.dbHelper.getLeaseStore();
    }

    public static synchronized LeaseManagerService getInstance(Properties properties) throws LeaseManagerNotAvailableException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getInstance()", LeaseManagerDBHelper.hidePassword(properties));
        }
        if (leaseManager == null) {
            leaseManager = LeaseManagerServiceImpl.createInstance(properties);
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getInstance()", leaseManager);
        }
        return leaseManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LeaseManagerService createInstance(Properties properties) throws LeaseManagerNotAvailableException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "createInstance()", LeaseManagerDBHelper.hidePassword(properties));
        }
        try {
            LeaseManagerServiceImpl leaseManagerServiceImpl = new LeaseManagerServiceImpl(properties);
            return leaseManagerServiceImpl;
        }
        finally {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "createInstance()");
            }
        }
    }

    public synchronized Lease acquireLease(String string, String string2, Map map, long l, boolean bl) throws LeaseNotAvailableException, LeaseManagerNotAvailableException, IllegalArgumentException, LeaseException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "acquireLease()", new Object[]{string, string2, map, String.valueOf(l)});
        }
        long l2 = 0L;
        if (l < 1L) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new String[]{"intervalInMs", ">=0"}));
        }
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new String[]{"ownerName", "<> null & <> \"\""}));
        }
        if (string2 == null || string2.length() < 1) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new String[]{"resourceName", "<> null & <> \"\""}));
        }
        try {
            l2 = this.leaseStore.acquire(string2, string, l, map, bl);
        }
        catch (LeaseNotAvailableException leaseNotAvailableException) {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "acquireLease() lease not avail");
            }
            throw leaseNotAvailableException;
        }
        catch (LeaseException leaseException) {
            FFDCFilter.processException((Throwable)leaseException, "com.ibm.ws.leasemanager.impl.LeaseManagerServiceImpl.acquireLease", "218", this);
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "acquireLease() " + leaseException.getMessage(), leaseException);
            }
            throw leaseException;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "acquireLease()", new Object[]{string2, string, String.valueOf(l2), "", map, this.leaseStore});
        }
        return new LeaseImpl(string2, string, l2, map, this.leaseStore);
    }

    public synchronized Iterator findLeasesByResource(String string) throws LeaseManagerNotAvailableException, LeaseException {
        ArrayList arrayList;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "findLeasesByResource()", new Object[]{string});
        }
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new String[]{"pattern", "<> null & <> \"\""}));
        }
        try {
            arrayList = this.leaseStore.findLeaseByName(string);
        }
        catch (LeaseException leaseException) {
            FFDCFilter.processException((Throwable)leaseException, "com.ibm.ws.leasemanager.impl.LeaseManagerServiceImpl.findLeasesByResource", "267", this);
            throw leaseException;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "findLeasesByResource()");
        }
        return arrayList.iterator();
    }

    public void disableLease(String string) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "disableLease()", string);
        }
        if (string == null || string.length() < 1) {
            throw new IllegalArgumentException(Messages.getMessage("SCHD0123E", new String[]{"resourceName", "<> null & <> \"\""}));
        }
        this.leaseStore.disableLease(string);
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "disableLease() disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDatabaseData(Properties properties) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getDatabaseData", LeaseManagerDBHelper.hidePassword(properties));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            if (properties == null) {
                HashMap<String, Object> hashMap2 = hashMap;
                return hashMap2;
            }
            String string = properties.getProperty("LEASEMANAGER_DATASOURCE", "jdbc/DefaulDataSource");
            hashMap.put("dbhelper.jndi.name", string);
            String string2 = properties.getProperty("TABLE_PREFIX", "");
            hashMap.put("dbhelper.table.prefix", string2);
            String string3 = properties.getProperty("username");
            hashMap.put("dbhelper.username", string3);
            String string4 = properties.getProperty("password");
            hashMap.put("dbhelper.password", string4);
            hashMap.put("dbhelper.replacement.map", WASSchedulerCfgHelper.createSQLSubstitutionMap(string2));
            String string5 = properties.getProperty("LEASEMANAGER_STMT_FILE");
            if (string5 == null) {
                string5 = DEFAULT_STATEMENT_FILE;
            }
            hashMap.put("dbhelper.statements.file", string5);
            HashMap<String, Object> hashMap3 = hashMap;
            return hashMap3;
        }
        finally {
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "getDatabaseData", LeaseManagerDBHelper.hidePassword(hashMap));
            }
        }
    }
}

