/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.leasemanager.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.leasemanager.LeaseDataStoreException;
import com.ibm.ws.leasemanager.impl.LeaseManagerDBHelper;
import com.ibm.ws.leasemanager.impl.LeaseStoreImpl;
import com.ibm.ws.scheduler.Utils;
import java.sql.Connection;
import java.sql.SQLException;

public class LeaseStoreImplSybase
extends LeaseStoreImpl {
    private static final TraceComponent tc = Tr.register(LeaseStoreImplSybase.class, "Scheduler", "com.ibm.ws.scheduler.resources.SchedulerMessages");

    public LeaseStoreImplSybase() {
    }

    public LeaseStoreImplSybase(LeaseManagerDBHelper leaseManagerDBHelper) {
        super(leaseManagerDBHelper);
    }

    public boolean createTables(Connection connection) throws LeaseDataStoreException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTables", "Sybase detected - use a new Connection with AutoCommit enabled.");
        }
        Connection connection2 = null;
        try {
            connection2 = this.dbHelper.getConnection();
            connection2.setAutoCommit(true);
            bl = super.createTables(connection2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".createTables", "86", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createTables", sQLException);
            }
            throw new LeaseDataStoreException(Utils.getExceptionMessageWithType(sQLException), sQLException);
        }
        finally {
            if (connection2 != null) {
                try {
                    this.dbHelper.returnConnection(connection2);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".createTables", "102", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTables", "Database was " + (bl ? "" : "not ") + "updated");
        }
        return bl;
    }

    public boolean dropTables(Connection connection) throws LeaseDataStoreException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dropTables", "Sybase detected - use a new Connection with AutoCommit enabled.");
        }
        Connection connection2 = null;
        try {
            connection2 = this.dbHelper.getConnection();
            connection2.setAutoCommit(true);
            bl = super.dropTables(connection2);
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".dropTables", "145", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "dropTables", sQLException);
            }
            throw new LeaseDataStoreException(Utils.getExceptionMessageWithType(sQLException), sQLException);
        }
        finally {
            if (connection2 != null) {
                try {
                    this.dbHelper.returnConnection(connection2);
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, this.getClass().getName() + ".dropTables", "161", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dropTables", "Database was " + (bl ? "" : "not ") + "updated");
        }
        return bl;
    }
}

