/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.channel.framework.ChannelData;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl;
import com.ibm.ws.channel.framework.impl.WSChainData;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.localhttp.channel.LHttpChannelDiagnosticModule;
import com.ibm.ws.localhttp.channel.LocalInboundChainFactory;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.HashMap;
import java.util.Map;

public class LocalHttpChainFactoryImpl
extends WsComponentImpl
implements LocalInboundChainFactory {
    private static final TraceComponent tc = Tr.register(LocalHttpChainFactoryImpl.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private static final String HTTP_CHANNEL_FACTORY = "com.ibm.ws.http.channel.inbound.impl.WSHttpInboundChannelFactory";
    private static final String SSL_CHANNEL_FACTORY = "com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory";
    private static final int DEFAULT_SSL_CHANNEL_INDEX = 1;
    static /* synthetic */ Class class$com$ibm$ws$localhttp$channel$inbound$impl$LHttpsInboundChannelFactory;
    static /* synthetic */ Class class$com$ibm$ws$localhttp$channel$inbound$impl$LHttpInboundChannelFactory;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        try {
            WsServiceRegistry.addService((Object)this, (Class)LocalInboundChainFactory.class);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, this.getClass().getName() + "LocalHttpChainFactoryimpl", "90", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "initialize: addService failed: " + exception);
            }
            throw new ComponentDisabledException("addService failed");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
    }

    public void createLocalChains(ChannelFramework channelFramework, String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createLocalChains: " + string);
        }
        if (null == channelFramework) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createLocalChains: null framework input");
            }
            return;
        }
        int n = 0;
        ChainData[] chainDataArray = channelFramework.getChainGroup(string).getChains();
        String string2 = string + "#LOCAL_HTTP";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "(pre-create) " + chainDataArray.length + " chains");
        }
        for (int i = 0; i < chainDataArray.length; ++i) {
            WSChainData wSChainData = (WSChainData)chainDataArray[i];
            if (!wSChainData.isEnabled()) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Ignoring disabled chain: " + wSChainData.getName());
                continue;
            }
            boolean bl = false;
            ChannelData[] channelDataArray = wSChainData.getChannelList();
            String string3 = channelDataArray[1].getFactoryType().getName();
            if (!string3.equals(HTTP_CHANNEL_FACTORY)) {
                if (!string3.equals(SSL_CHANNEL_FACTORY)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "cannot process channel at " + i);
                    continue;
                }
                bl = true;
            }
            String string4 = (String)wSChainData.getPropertyBag().get("port");
            String string5 = (String)wSChainData.getPropertyBag().get("hostname");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "source chain: " + wSChainData.getName());
                Tr.debug(tc, "  secure: " + bl);
                Tr.debug(tc, "  port: " + string4);
                Tr.debug(tc, "  hostname:" + string5);
            }
            if (null == string4 || null == string5) continue;
            String string6 = wSChainData.getName() + (bl ? "#LOCAL_HTTPS" : "#LOCAL_HTTP") + string4;
            String string7 = string2 + string4;
            String[] stringArray = null;
            int n2 = bl ? 2 : 1;
            try {
                if (null == channelFramework.getChannel(string7)) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    Class clazz = bl ? (class$com$ibm$ws$localhttp$channel$inbound$impl$LHttpsInboundChannelFactory == null ? LocalHttpChainFactoryImpl.class$("com.ibm.ws.localhttp.channel.inbound.impl.LHttpsInboundChannelFactory") : class$com$ibm$ws$localhttp$channel$inbound$impl$LHttpsInboundChannelFactory) : (class$com$ibm$ws$localhttp$channel$inbound$impl$LHttpInboundChannelFactory == null ? LocalHttpChainFactoryImpl.class$("com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundChannelFactory") : class$com$ibm$ws$localhttp$channel$inbound$impl$LHttpInboundChannelFactory);
                    hashMap.put("port", string4);
                    hashMap.put("hostname", string5);
                    if (bl) {
                        hashMap.putAll(channelDataArray[1].getPropertyBag());
                    }
                    this.updateHttpConfig(hashMap, channelDataArray[n2].getPropertyBag());
                    channelFramework.addChannel(string7, clazz, hashMap, 0);
                }
                stringArray = new String[channelDataArray.length - n2];
                int n3 = channelDataArray.length - 1;
                int n4 = stringArray.length - 1;
                while (n3 > n2) {
                    stringArray[n4] = channelDataArray[n3].getName();
                    --n3;
                    --n4;
                }
                stringArray[0] = string7;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating chain: " + string6);
                    Tr.debug(tc, "  channel: " + string7);
                }
                channelFramework.addChain(string6, FlowType.INBOUND, stringArray);
                channelFramework.addChainToGroup(string, string6);
                ++n;
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, this.getClass().getName() + ".createLocalChains", "101", this, new Object[]{string, wSChainData, string7, string6, stringArray, channelFramework});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Failed to create chain: " + string6);
                Tr.debug(tc, "  channel: " + string7);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            chainDataArray = channelFramework.getChainGroup(string).getChains();
            Tr.debug(tc, "(post-create) " + chainDataArray.length + " chains.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createLocalChains: created " + n + " chains");
        }
    }

    private void updateFilename(Map map, String string, String string2) {
        char c;
        int n;
        String string3 = (String)map.get(string);
        if (null == string3) {
            return;
        }
        for (n = string3.length() - 1; n >= 0 && (c = string3.charAt(n)) != '/' && c != '\\'; --n) {
        }
        if (-1 == n) {
            map.put(string, string2 + string3);
        } else {
            map.put(string, string3.substring(0, ++n) + string2 + string3.substring(n));
        }
    }

    private Map updateHttpConfig(Map map, Map map2) {
        map.putAll(map2);
        String string = (String)map2.get("localLogFilenamePrefix");
        if (null == string) {
            return map;
        }
        this.updateFilename(map, "accessLogFileName", string);
        this.updateFilename(map, "errorLogFileName", string);
        return map;
    }

    public String getFFDCDumpData(Object[] objectArray) {
        return this.getFFDCDumpData(null, objectArray);
    }

    public String getFFDCDumpData(StringBuffer stringBuffer, Object[] objectArray) {
        ChannelFrameworkImpl channelFrameworkImpl;
        Object object;
        StringBuffer stringBuffer2 = null == stringBuffer ? new StringBuffer() : stringBuffer;
        String string = (String)objectArray[0];
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("Local chain for group", string, stringBuffer2);
        ChainData chainData = (ChainData)objectArray[1];
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString(" Network chain being replicated : ", chainData.getName(), stringBuffer2);
        if (null != chainData) {
            object = chainData.getChannelList();
            for (int i = 0; i < ((ChannelData[])object).length; ++i) {
                stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("       Channel:", object[i].getName(), stringBuffer2);
            }
        }
        object = (String)objectArray[2];
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString(" Local Channel Name:", (String)object, stringBuffer2);
        String string2 = (String)objectArray[3];
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString(" Local Chain Name:", string2, stringBuffer2);
        String[] stringArray = (String[])objectArray[4];
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("  Channel:", stringArray[i], stringBuffer2);
            }
        }
        if (null != (channelFrameworkImpl = (ChannelFrameworkImpl)objectArray[5])) {
            stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString(" ChannelFramework:", channelFrameworkImpl.toString(), stringBuffer2);
        }
        return stringBuffer2.toString();
    }
}

