/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel;

import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class LocalHttpChannelUtils {
    private static final HttpObjectFactory objectFact = new HttpObjectFactory();
    private static InetAddress localAddress = null;

    public static WsByteBuffer[] copyBuffers(WsByteBuffer[] wsByteBufferArray) {
        WsByteBuffer[] wsByteBufferArray2 = null;
        if (null != wsByteBufferArray) {
            wsByteBufferArray2 = new WsByteBuffer[wsByteBufferArray.length];
            for (int i = 0; i < wsByteBufferArray.length && null != wsByteBufferArray[i]; ++i) {
                wsByteBufferArray2[i] = WsByteBufferPoolManagerImpl.getRef().allocate(wsByteBufferArray[i].limit());
                wsByteBufferArray2[i].put(wsByteBufferArray[i]);
                wsByteBufferArray2[i].flip();
            }
        }
        return wsByteBufferArray2;
    }

    public static WsByteBuffer[] duplicateBuffers(WsByteBuffer[] wsByteBufferArray) {
        WsByteBuffer[] wsByteBufferArray2 = null;
        if (null != wsByteBufferArray) {
            wsByteBufferArray2 = new WsByteBuffer[wsByteBufferArray.length];
            for (int i = 0; i < wsByteBufferArray.length && null != wsByteBufferArray[i]; ++i) {
                wsByteBufferArray2[i] = wsByteBufferArray[i].duplicate();
            }
        }
        return wsByteBufferArray2;
    }

    public static int sizeOf(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (null == wsByteBufferArray[i]) continue;
            n += wsByteBufferArray[i].remaining();
        }
        return n;
    }

    public static HttpObjectFactory getObjectFactory() {
        return objectFact;
    }

    public static InetAddress getLocalAddr() {
        if (null == localAddress) {
            try {
                localAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.localhttp.channel.impl.LocalHttpChannelUtils.getLocalAddr", (String)"105");
                localAddress = new InetSocketAddress("localhost", 9080).getAddress();
            }
        }
        return localAddress;
    }

    public static void removeChunkedEncoding(HttpBaseMessage httpBaseMessage) {
        if (!httpBaseMessage.isChunkedEncodingSet()) {
            return;
        }
        TransferEncodingValues[] transferEncodingValuesArray = httpBaseMessage.getTransferEncoding();
        if (1 == transferEncodingValuesArray.length) {
            httpBaseMessage.removeHeader(HttpConstants.HDR_TRANSFER_ENCODING);
        } else {
            TransferEncodingValues[] transferEncodingValuesArray2 = new TransferEncodingValues[transferEncodingValuesArray.length - 1];
            int n = 0;
            for (int i = 0; i < transferEncodingValuesArray.length; ++i) {
                if (HttpConstants.TRANSFER_ENCODING_CHUNKED.equals(transferEncodingValuesArray[i])) continue;
                transferEncodingValuesArray2[n++] = transferEncodingValuesArray[i];
            }
            httpBaseMessage.setTransferEncoding(transferEncodingValuesArray2);
        }
    }

    public static void addChunkedEncoding(HttpBaseMessage httpBaseMessage) {
        if (httpBaseMessage.isChunkedEncodingSet()) {
            return;
        }
        TransferEncodingValues[] transferEncodingValuesArray = httpBaseMessage.getTransferEncoding();
        if (HttpConstants.TRANSFER_ENCODING_NOTSET.equals(transferEncodingValuesArray[0])) {
            httpBaseMessage.setTransferEncoding(HttpConstants.TRANSFER_ENCODING_CHUNKED);
        } else {
            TransferEncodingValues[] transferEncodingValuesArray2 = new TransferEncodingValues[transferEncodingValuesArray.length + 1];
            for (int i = 0; i < transferEncodingValuesArray.length; ++i) {
                transferEncodingValuesArray2[i] = transferEncodingValuesArray[i];
            }
            transferEncodingValuesArray2[transferEncodingValuesArray.length] = HttpConstants.TRANSFER_ENCODING_CHUNKED;
            httpBaseMessage.setTransferEncoding(transferEncodingValuesArray2);
        }
    }
}

