/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.SSLContext;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.localhttp.channel.LHttpChannelDiagnosticModule;
import com.ibm.ws.localhttp.channel.LocalChannelRegistryService;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundLink;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.ws.ssl.channel.impl.WSSSLChannel;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundConnectorChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;

public class LHttpInboundChannel
extends InboundConnectorChannel {
    private static final TraceComponent tc = Tr.register(LHttpInboundChannel.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private HttpChannelConfig configRef = null;
    private boolean secure;
    private WSSSLChannel sslChannel = null;
    private String portStr;

    public LHttpInboundChannel(ChannelData channelData, boolean bl) {
        super(channelData);
        this.secure = bl;
        this.portStr = (String)channelData.getPropertyBag().get("port");
        this.configRef = new HttpChannelConfig(channelData);
    }

    public Class getDiscriminatoryType() {
        return HttpRequestMessage.class;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        return this.getHttpLink(virtualConnection);
    }

    public LHttpInboundLink getHttpLink(VirtualConnection virtualConnection) {
        return new LHttpInboundLink(this, virtualConnection);
    }

    public void start() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "start: starting channel " + this.getConfig().getExternalName());
        }
        if (null != this.portStr) {
            String string = this.portStr + "#Port";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Registering key: " + string + " for channel: " + (Object)((Object)this));
            }
            this.getService().registerInboundChannel(string, (Channel)this);
        } else {
            ChannelException channelException = new ChannelException("Unable to start local channel (no port)");
            FFDCFilter.processException((Throwable)channelException, ((Object)((Object)this)).getClass().getName() + ".start", "101", (Object)this);
        }
    }

    public void stop(long l) throws ChannelException {
        this.getService().deRegisterInboundChannel(this.getConfig().getExternalName());
    }

    private LocalChannelRegistryService getService() {
        return (LocalChannelRegistryService)this.getConfig().getChannelFramework().lookupService(LocalChannelRegistryService.class);
    }

    public void init() throws ChannelException {
        if (this.isSecure()) {
            this.sslChannel = new WSSSLChannel(this.getConfig());
            this.sslChannel.init();
        }
    }

    public void destroy() throws ChannelException {
    }

    public Class getApplicationInterface() {
        return HttpInboundServiceContext.class;
    }

    public void update(ChannelData channelData) {
    }

    public HttpChannelConfig getHttpConfig() {
        return this.configRef;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public ProtoSSLEngine createSSLEngine(VirtualConnection virtualConnection) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating inbound SSL engine for " + virtualConnection);
        }
        if (!this.isSecure() || null == this.sslChannel) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "createSSLEngine: throwing exception, secure=" + this.isSecure());
            }
            throw new Exception("Attempted secure connection for non-secure channel");
        }
        try {
            SSLContext sSLContext = this.sslChannel.getSSLContextForInboundLink(null, virtualConnection);
            return SSLUtils.getSSLEngine(sSLContext, FlowType.INBOUND, (SSLLinkConfig)virtualConnection.getStateMap().get("SSLLINKCONFIG"));
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, ((Object)((Object)this)).getClass().getName() + ".createSSLEngine", "223");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Error trying to create SSL engine: " + exception);
            }
            throw exception;
        }
    }

    public String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    public String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = null == stringBuffer ? new StringBuffer() : stringBuffer;
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("ChannelName", this.getName(), stringBuffer2);
        if (null != this.configRef) {
            stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString(" HttpChannelConfig : ", this.configRef.toString(), stringBuffer2);
        }
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("      secure:", String.valueOf(this.secure), stringBuffer2);
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("      WSSSLChannel: ", this.sslChannel.toString(), stringBuffer2);
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("  port:", this.portStr, stringBuffer2);
        return stringBuffer2.toString();
    }
}

