/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.InboundTransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelFactory;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.localhttp.channel.LHttpChannelDiagnosticModule;
import com.ibm.ws.localhttp.channel.LocalChannelRegistryService;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundChannel;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpOutboundChannelDefinition;
import com.ibm.wsspi.channel.Channel;
import com.ibm.wsspi.channel.LocalChannelFactory;
import com.ibm.wsspi.channel.WSChannelFactory;
import com.ibm.wsspi.channel.base.ConnectorChannelFactory;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.ChannelFactoryData;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundChannelDefinition;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.channel.framework.exception.ChannelFactoryException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LHttpInboundChannelFactory
extends ConnectorChannelFactory
implements LocalChannelRegistryService,
WSChannelFactory,
LocalChannelFactory {
    private static final TraceComponent tc = Tr.register(LHttpInboundChannelFactory.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private Map localHttpChannels = new HashMap();

    protected Channel createChannel(ChannelData channelData) throws ChannelException {
        Channel channel;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating channel: " + channelData.getName());
        }
        if (null != (channel = this.lookupInboundChannel((String)channelData.getPropertyBag().get("port")))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning portshared lhttp channel");
            }
            return channel;
        }
        return new LHttpInboundChannel(channelData, false);
    }

    public void init(ChannelFactoryData channelFactoryData) throws ChannelFactoryException {
        ChannelFramework channelFramework = channelFactoryData.getChannelFramework();
        if (null == channelFramework.lookupService(LocalChannelRegistryService.class)) {
            channelFramework.registerService(LocalChannelRegistryService.class, (Object)this);
        }
    }

    public void destroy() {
    }

    public Class getApplicationInterface() {
        return HttpInboundServiceContext.class;
    }

    public void registerInboundChannel(String string, Channel channel) {
        this.localHttpChannels.put(string, channel);
    }

    public Channel lookupInboundChannel(String string) {
        return (Channel)this.localHttpChannels.get(string);
    }

    public OutboundChannelDefinition getOutboundChannelDefinition(Map map) {
        return new LHttpOutboundChannelDefinition(map);
    }

    public void deRegisterInboundChannel(String string) {
        this.localHttpChannels.remove(string);
    }

    public Map createFactoryConfigurationMap(TransportChannelFactory transportChannelFactory, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        return null;
    }

    public Map createChannelConfigurationMap(TransportChannel transportChannel, ChannelFrameworkService channelFrameworkService) throws ConfigurationError {
        return null;
    }

    public String determineAcceptorID(InboundTransportChannel inboundTransportChannel) throws ConfigurationError {
        return null;
    }

    public String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    public String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3 = stringBuffer2 = null == stringBuffer ? new StringBuffer() : stringBuffer;
        if (null != this.localHttpChannels) {
            stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("Local Channel Map", this.localHttpChannels.toString(), stringBuffer2);
            Set set = this.localHttpChannels.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.localHttpChannels.get(string);
                stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString(" Key", string, stringBuffer2);
                stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("  Value", v.toString(), stringBuffer2);
            }
        }
        return stringBuffer2.toString();
    }
}

