/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.logging.HTTPLoggingService;
import com.ibm.ws.localhttp.channel.LHttpSSLConnectionContext;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundChannel;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundServiceContext;
import com.ibm.ws.localhttp.channel.outbound.impl.LHttpOutboundLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.ConnectionReadyCallback;
import com.ibm.wsspi.channel.base.InboundConnectorLink;
import com.ibm.wsspi.channel.framework.DiscriminationProcess;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class LHttpInboundLink
extends InboundConnectorLink {
    private static final TraceComponent tc = Tr.register(LHttpInboundLink.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private LHttpInboundChannel channelRef = null;
    private LHttpInboundServiceContext iscRef = null;
    private LHttpOutboundLink outLink = null;
    private LHttpSSLConnectionContext lhttpSSLConnCtxt = null;
    private List appSides = new ArrayList(5);

    LHttpInboundLink(LHttpInboundChannel lHttpInboundChannel, VirtualConnection virtualConnection) {
        this.init(virtualConnection);
        this.channelRef = lHttpInboundChannel;
        this.outLink = (LHttpOutboundLink)virtualConnection.getStateMap().get("LHttpOutboundLink");
        this.iscRef = new LHttpInboundServiceContext(virtualConnection, this, lHttpInboundChannel.getHttpConfig());
    }

    public void destroy(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Destroying inbound link: " + (Object)((Object)this));
        }
        this.outLink.disconnect();
        if (null != this.iscRef) {
            this.iscRef.clear();
            this.iscRef = null;
        }
        this.channelRef = null;
        this.outLink = null;
        if (null != this.lhttpSSLConnCtxt) {
            this.lhttpSSLConnCtxt.destroy();
            this.lhttpSSLConnCtxt = null;
        }
        super.destroy();
        for (int i = this.appSides.size() - 1; i >= 0; --i) {
            ConnectionReadyCallback connectionReadyCallback = (ConnectionReadyCallback)this.appSides.remove(i);
            connectionReadyCallback.destroy(exception);
        }
    }

    public Object getChannelAccessor() {
        return this.iscRef;
    }

    public void ready(VirtualConnection virtualConnection) {
        HTTPLoggingService hTTPLoggingService;
        this.iscRef.init(null, (ConnectionLink)this, this.vc, this.channelRef.getHttpConfig());
        if (this.iscRef.getHttpConfig().isErrorLoggingEnabled()) {
            hTTPLoggingService = this.iscRef.getHttpConfig().getHttpLogger();
            hTTPLoggingService.log(HttpConstants.LOG_INFO, "Received new connection ", (HttpServiceContext)this.iscRef);
            if (this.iscRef.isSecure()) {
                hTTPLoggingService.log(HttpConstants.LOG_INFO, "Connection is secure", (HttpServiceContext)this.iscRef);
            }
        }
        if (this.vc != virtualConnection) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Mismatch in virtual connections");
            }
            this.outLink = (LHttpOutboundLink)this.vc.getStateMap().get("LHttpOutboundLink");
        }
        hTTPLoggingService = this.getApplicationCallback();
        DiscriminationProcess discriminationProcess = this.channelRef.getDiscriminationProcess();
        int n = 0;
        try {
            n = discriminationProcess.discriminate(this.vc, (Object)this.iscRef.getRequest(), (ConnectionLink)this);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught doing discriminate, " + exception);
            }
            this.iscRef.sendErrorMessage(exception);
            return;
        }
        if (1 == n) {
            if (null == hTTPLoggingService) {
                this.appSides.add(this.getApplicationCallback());
            } else if (!this.getApplicationCallback().equals(hTTPLoggingService)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received new appside connlink: " + hTTPLoggingService + " vs " + this.getApplicationCallback());
                }
                if (!this.appSides.contains(this.getApplicationCallback())) {
                    this.appSides.add(this.getApplicationCallback());
                }
            }
            this.getApplicationCallback().ready(this.vc);
        } else {
            this.iscRef.sendErrorMessage(new Exception("Discrimination failed"));
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        boolean bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "close() called: " + (Object)((Object)this));
        }
        boolean bl2 = bl = null != exception || null == this.iscRef;
        if (bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "close() in error state, " + exception);
        }
        if (!bl && !this.iscRef.isMessageSent()) {
            try {
                this.iscRef.finishResponseMessage(null);
            }
            catch (MessageSentException messageSentException) {
                FFDCFilter.processException(messageSentException, "LHttpInboundLink.close", "101");
                return;
            }
            catch (IOException iOException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error: closing connection; caught exception: " + iOException);
                }
                super.close(virtualConnection, (Exception)iOException);
                return;
            }
        }
        if (!bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Keeping connection open for another request");
            }
            if (this.iscRef.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
                this.iscRef.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Reading for another request", (HttpServiceContext)this.iscRef);
            }
            this.iscRef.clear();
        } else {
            if (this.iscRef.getHttpConfig().isErrorLoggingEnabled()) {
                this.iscRef.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_INFO, "Closing connection to client", (HttpServiceContext)this.iscRef);
            }
            super.close(virtualConnection, exception);
        }
    }

    public void complete(VirtualConnection virtualConnection) {
        this.close(virtualConnection, null);
    }

    public void error(VirtualConnection virtualConnection, Throwable throwable) {
        try {
            this.close(virtualConnection, (Exception)throwable);
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException(classCastException, "LHttpInboundLink.error", "102");
            this.close(virtualConnection, new Exception("Problem when finishing response"));
        }
    }

    public boolean isConnected() {
        this.outLink = (LHttpOutboundLink)this.vc.getStateMap().get("LHttpOutboundLink");
        return null != this.outLink;
    }

    public int getPortConnected() {
        return this.outLink.getConnectPort();
    }

    public InetAddress getTargetAddr() {
        return this.outLink.getTargetAddress().getRemoteAddress().getAddress();
    }

    public void transferResponse(HttpResponseMessage httpResponseMessage) {
        if (null != this.outLink) {
            this.outLink.transferResponse(httpResponseMessage);
        }
    }

    public void transferResponseBody(WsByteBuffer[] wsByteBufferArray) {
        if (null != this.outLink) {
            this.outLink.transferResponseBody(wsByteBufferArray);
        }
    }

    public void transferRequest(HttpRequestMessage httpRequestMessage) {
        this.iscRef.transferRequest(httpRequestMessage);
    }

    public void transferRequestBody(WsByteBuffer[] wsByteBufferArray, boolean bl) {
        this.iscRef.transferRequestBody(wsByteBufferArray, bl);
    }

    public SSLConnectionContext getSSLConnectionContext() {
        return this.lhttpSSLConnCtxt;
    }

    public void setSSLConnectionContext(LHttpSSLConnectionContext lHttpSSLConnectionContext) {
        this.lhttpSSLConnCtxt = lHttpSSLConnectionContext;
    }
}

