/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel.inbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.localhttp.channel.LocalHttpChannelUtils;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.IllegalResponseObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.error.HttpError;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.exception.IllegalHttpBodyException;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;
import java.io.IOException;

public class LHttpInboundServiceContext
extends HttpServiceContextImpl
implements HttpInboundServiceContext {
    private static final TraceComponent tc = Tr.register(LHttpInboundServiceContext.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private static final String HTTP_ERROR_IDENTIFIER = "Http Error ID";
    public static final int remotePort = 999999;
    private static final int INCREASE_SIZE = 10;
    private LHttpInboundLink linkRef = null;
    private HttpResponseMessageImpl response = null;
    private HttpRequestMessageImpl request = null;
    private WsByteBuffer[] reqbody = new WsByteBuffer[10];
    private int currentIndex = 0;
    private int lastIndex = 0;
    private boolean reqBodyOwner = false;

    public LHttpInboundServiceContext(VirtualConnection virtualConnection, LHttpInboundLink lHttpInboundLink, HttpChannelConfig httpChannelConfig) {
        this.linkRef = lHttpInboundLink;
        this.init(null, (ConnectionLink)lHttpInboundLink, virtualConnection, httpChannelConfig);
    }

    public void init(TCPConnectionContext tCPConnectionContext, ConnectionLink connectionLink, VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Initializing ISC: " + this);
        }
        this.setVC(virtualConnection);
        this.init(tCPConnectionContext, httpChannelConfig);
        this.linkRef = (LHttpInboundLink)connectionLink;
    }

    protected boolean reconnectAllowed() {
        return false;
    }

    protected HttpBaseMessageImpl getMessageBeingParsed() {
        return this.request;
    }

    protected HttpBaseMessageImpl getMessageBeingSent() {
        return this.response;
    }

    public HttpObjectFactory getObjectFactory() {
        return LocalHttpChannelUtils.getObjectFactory();
    }

    public void setResponse(HttpResponseMessage httpResponseMessage) throws IllegalResponseObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setResponse: " + httpResponseMessage);
        }
        if (this.headersSent()) {
            throw new IllegalResponseObjectException("response message already sent.");
        }
        if (null != this.response && this.isResponseOwner()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setResponse destroying existing msg: " + this.response);
            }
            this.response.destroy();
        }
        this.response = (HttpResponseMessageImpl)httpResponseMessage;
        this.response.setOwner(this);
    }

    private void formatBodyHeaders(WsByteBuffer[] wsByteBufferArray, boolean bl) {
        if (-1 != this.response.getContentLength() || this.response.isChunkedEncodingSet()) {
            return;
        }
        boolean bl2 = HttpConstants.HTTP_VERSION_11.equals(this.response.getVersionValue());
        int n = LocalHttpChannelUtils.sizeOf(wsByteBufferArray);
        if (bl && bl2) {
            LocalHttpChannelUtils.addChunkedEncoding(this.response);
        } else if (0 == n) {
            this.updateBodyLengthHeaders(this.response);
        } else {
            this.response.setContentLength(n);
        }
    }

    public void sendResponseHeaders() throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendResponseHeaders(sync): vc=" + this.getVC());
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        if (!this.linkRef.isConnected()) {
            throw new IOException("Peer unavailable");
        }
        if (this.response.isTemporaryStatusCode()) {
            this.resetWrite();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendResponseHeaders(sync): ignoring temp status");
            }
            return;
        }
        if (this.getHttpConfig().isErrorLoggingEnabledAtDebug()) {
            this.getHttpConfig().getHttpLogger().log(HttpConstants.LOG_DEBUG, "Sending headers to client", (HttpServiceContext)this);
        }
        this.formatBodyHeaders(null, true);
        this.response.headerComplianceCheck();
        this.linkRef.transferResponse(this.response);
        this.setHeadersSent();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendResponseHeaders(sync)");
        }
    }

    public VirtualConnection sendResponseHeaders(InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendResponseHeaders(async): vc=" + this.getVC());
        }
        try {
            this.sendResponseHeaders();
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendResponseHeaders(async): error, ioe=" + iOException);
            }
            return null;
        }
        VirtualConnection virtualConnection = this.getVC();
        if (bl) {
            interChannelCallback.complete(this.getVC());
            virtualConnection = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendResponseHeaders(async): rc=" + virtualConnection);
        }
        return virtualConnection;
    }

    public void sendResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendResponseBody(sync): vc=" + this.getVC());
        }
        if (this.isMessageSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (!this.headersSent()) {
            this.formatBodyHeaders(wsByteBufferArray, true);
            this.sendResponseHeaders();
        }
        this.addBytesWritten(LocalHttpChannelUtils.sizeOf(wsByteBufferArray));
        this.linkRef.transferResponseBody(LocalHttpChannelUtils.duplicateBuffers(wsByteBufferArray));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendResponseBody(sync)");
        }
    }

    public VirtualConnection sendResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendResponseBody(async): vc=" + this.getVC());
        }
        try {
            this.sendResponseBody(wsByteBufferArray);
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendResponseBody(async): error, ioe=" + iOException);
            }
            return null;
        }
        VirtualConnection virtualConnection = this.getVC();
        if (bl) {
            interChannelCallback.complete(this.getVC());
            virtualConnection = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendResponseBody(async): rc=" + virtualConnection);
        }
        return virtualConnection;
    }

    public void sendRawResponseBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.sendResponseBody(wsByteBufferArray);
    }

    public VirtualConnection sendRawResponseBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.sendResponseBody(wsByteBufferArray, interChannelCallback, bl);
    }

    public void finishResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishResponseMessage(sync): vc=" + this.getVC());
        }
        if (!this.headersSent()) {
            this.formatBodyHeaders(wsByteBufferArray, false);
        }
        this.sendResponseBody(wsByteBufferArray);
        this.setMessageSent();
        this.logFinalResponse();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishResponseMessage(sync)");
        }
    }

    public VirtualConnection finishResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishResponseMessage(async): vc=" + this.getVC());
        }
        try {
            if (!this.headersSent()) {
                this.formatBodyHeaders(wsByteBufferArray, false);
            }
            this.sendResponseBody(wsByteBufferArray);
            this.setMessageSent();
            this.logFinalResponse();
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "finishResponseMessage(async): error, ioe=" + iOException);
            }
            return null;
        }
        VirtualConnection virtualConnection = this.getVC();
        if (bl) {
            interChannelCallback.complete(this.getVC());
            virtualConnection = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishResponseMessage(async): rc=" + virtualConnection);
        }
        return virtualConnection;
    }

    public void finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.finishResponseMessage(wsByteBufferArray);
    }

    public VirtualConnection finishRawResponseMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.finishResponseMessage(wsByteBufferArray, interChannelCallback, bl);
    }

    public void sendError(HttpError httpError) throws MessageSentException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Called sendError with: " + httpError);
        }
        if (this.headersSent()) {
            throw new MessageSentException("Message already sent");
        }
        if (null == httpError) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reset null error to Internal Server Error");
            }
            httpError = HttpConstants.STATUS_INTERNAL_ERROR.getHttpError();
        }
        this.getResponse().setStatusCode(httpError.getErrorCode());
        this.getVC().getStateMap().put(HTTP_ERROR_IDENTIFIER, httpError);
        this.getResponse().setConnection(HttpConstants.CONN_CLOSE);
        try {
            this.finishResponseMessage(httpError.getErrorBody());
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "LHttpInboundServiceContext.sendError", "101");
        }
    }

    public WsByteBuffer[] getRequestBodyBuffers() throws IllegalHttpBodyException {
        WsByteBuffer[] wsByteBufferArray = null;
        int n = this.lastIndex - this.currentIndex;
        if (0 < n) {
            wsByteBufferArray = new WsByteBuffer[n];
            int n2 = 0;
            int n3 = this.currentIndex;
            while (n2 < n) {
                wsByteBufferArray[n2] = this.reqbody[n3];
                this.reqbody[n3] = null;
                ++n2;
                ++n3;
            }
            this.currentIndex = this.lastIndex;
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRequestBodyBuffers: forced async");
            }
            interChannelCallback.complete(this.getVC());
            return null;
        }
        return this.getVC();
    }

    public WsByteBuffer getRequestBodyBuffer() throws IllegalHttpBodyException {
        WsByteBuffer wsByteBuffer = null;
        if (this.currentIndex < this.lastIndex) {
            wsByteBuffer = this.reqbody[this.currentIndex];
            this.reqbody[this.currentIndex] = null;
            ++this.currentIndex;
        }
        return wsByteBuffer;
    }

    public VirtualConnection getRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getRequestBodyBuffer: forced async");
            }
            interChannelCallback.complete(this.getVC());
            return null;
        }
        return this.getVC();
    }

    public WsByteBuffer getRawRequestBodyBuffer() throws IllegalHttpBodyException {
        return this.getRequestBodyBuffer();
    }

    public WsByteBuffer[] getRawRequestBodyBuffers() throws IllegalHttpBodyException {
        return this.getRequestBodyBuffers();
    }

    public VirtualConnection getRawRequestBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        return this.getRequestBodyBuffer(interChannelCallback, bl);
    }

    public VirtualConnection getRawRequestBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        return this.getRequestBodyBuffers(interChannelCallback, bl);
    }

    public HttpRequestMessage getRequest() {
        return this.request;
    }

    public HttpResponseMessage getResponse() {
        if (null == this.response) {
            this.response = this.getObjectFactory().getResponse(this);
        }
        return this.response;
    }

    public boolean isIncomingMessageFullyRead() {
        return true;
    }

    public boolean isInboundConnection() {
        return true;
    }

    public void setReadTimeout(int n) throws IllegalArgumentException {
    }

    public void setWriteTimeout(int n) throws IllegalArgumentException {
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clear");
        }
        if (null != this.response) {
            if (!this.headersSent() && this.isResponseOwner()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Destroying response message: " + this.response);
                }
                this.response.destroy();
            }
            this.response = null;
        }
        this.resetMsgParsedState();
        this.resetMsgSentState();
        this.resetBytesWritten();
        if (this.reqBodyOwner) {
            for (int i = this.currentIndex; i < this.lastIndex; ++i) {
                this.reqbody[i].release();
                this.reqbody[i] = null;
            }
        } else {
            for (int i = this.currentIndex; i < this.lastIndex; ++i) {
                this.reqbody[i] = null;
            }
        }
        this.currentIndex = 0;
        this.lastIndex = 0;
        this.reqBodyOwner = false;
        this.request = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public SSLConnectionContext getSSLContext() {
        return this.linkRef.getSSLConnectionContext();
    }

    public void sendErrorMessage(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending a 400 for [" + exception + "]");
        }
        this.sendErrorMessage(HttpConstants.STATUS_BAD_REQUEST);
    }

    private void sendErrorMessage(StatusCodes statusCodes) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Sending an error page back [code: " + statusCodes + "]");
        }
        try {
            this.sendError(statusCodes.getHttpError());
        }
        catch (MessageSentException messageSentException) {
            this.linkRef.close(this.getVC(), new Exception("HTTP Message failure"));
        }
    }

    protected void finishSendError() {
        HttpError httpError;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "finishSendError");
        }
        if (null != (httpError = (HttpError)this.getVC().getStateMap().get(HTTP_ERROR_IDENTIFIER))) {
            this.linkRef.close(this.getVC(), httpError.getClosingException());
        } else {
            this.linkRef.close(this.getVC(), null);
        }
    }

    protected void finishSendError(Exception exception) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "finishSendError(): " + exception);
        }
        this.linkRef.close(this.getVC(), exception);
    }

    public void transferRequest(HttpRequestMessage httpRequestMessage) {
        this.request = (HttpRequestMessageImpl)httpRequestMessage;
        this.setLocalPort(this.linkRef.getPortConnected());
        this.setRemotePort(999999);
        this.setLocalAddr(this.linkRef.getTargetAddr());
        this.setRemoteAddr(LocalHttpChannelUtils.getLocalAddr());
        this.request.setOwner(this);
        this.setHeadersParsed();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "transferRequest: obtained request " + this.getRequest().getRequestURI());
        }
    }

    public void transferRequestBody(WsByteBuffer[] wsByteBufferArray, boolean bl) {
        if (wsByteBufferArray != null) {
            int n;
            this.reqBodyOwner = bl;
            int n2 = 0;
            int n3 = wsByteBufferArray.length - (this.reqbody.length - this.lastIndex);
            if (n3 > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Increasing body storage list: overflow=" + n3);
                }
                n = n3 > 10 ? n3 : 10;
                WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[this.reqbody.length + n];
                System.arraycopy(this.reqbody, 0, wsByteBufferArray2, 0, this.lastIndex);
                this.reqbody = wsByteBufferArray2;
            }
            n = this.lastIndex;
            while (n2 < wsByteBufferArray.length && null != wsByteBufferArray[n2]) {
                this.reqbody[n] = wsByteBufferArray[n2];
                ++n2;
                ++n;
            }
            this.lastIndex = n;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "transferRequestBody: saved (" + n2 + "/" + wsByteBufferArray.length + ") buffers");
            }
        }
    }

    protected void logFinalResponse() {
        if (!this.getHttpConfig().isAccessLoggingEnabled()) {
            return;
        }
        if (HttpConstants.METHOD_UNDEF.equals(this.getRequest().getMethodValue())) {
            return;
        }
        this.getHttpConfig().getHttpLogger().logAccess(this.getRequest(), this.getResponse(), this.getRequestVersion().getName(), null, this.getRemoteAddr().getHostAddress(), this.getNumBytesWritten());
    }

    public boolean cancelOutstandingRead() {
        return false;
    }

    public boolean cancelOutstandingWrite() {
        return false;
    }
}

