/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.jsse2.SSLContext;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.localhttp.channel.LHttpChannelDiagnosticModule;
import com.ibm.ws.localhttp.channel.LocalChannelRegistryService;
import com.ibm.ws.localhttp.channel.outbound.impl.LHttpOutboundLink;
import com.ibm.ws.ssl.channel.impl.SSLLinkConfig;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.ws.ssl.channel.impl.WSSSLChannel;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.OutboundConnectorChannel;
import com.ibm.wsspi.channel.framework.ChannelData;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.tcp.channel.TCPConnectRequestContext;

public class LHttpOutboundChannel
extends OutboundConnectorChannel {
    private static final TraceComponent tc = Tr.register(LHttpOutboundChannel.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private static final Class[] ADDRESS_CLASSES = new Class[]{HttpAddress.class};
    private HttpChannelConfig httpConfig = null;
    private LocalChannelRegistryService svc;
    private VirtualConnectionFactory inboundVCF = null;
    private boolean secure = false;
    private WSSSLChannel sslChannel = null;

    public LHttpOutboundChannel(ChannelData channelData, boolean bl) {
        super(channelData);
        this.secure = bl;
        if (null == this.httpConfig) {
            this.httpConfig = new HttpChannelConfig(channelData);
        }
    }

    public Class[] getApplicationAddress() {
        return ADDRESS_CLASSES;
    }

    public ConnectionLink getConnectionLink(VirtualConnection virtualConnection) {
        LHttpOutboundLink lHttpOutboundLink = new LHttpOutboundLink(virtualConnection, this.inboundVCF, this.svc, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getConnectionLink: returning link " + lHttpOutboundLink);
        }
        return lHttpOutboundLink;
    }

    public void start() throws ChannelException {
        this.svc = (LocalChannelRegistryService)this.getConfig().getChannelFramework().lookupService(LocalChannelRegistryService.class);
        this.inboundVCF = this.getConfig().getChannelFramework().getInboundVCFactory();
        if (this.inboundVCF == null) {
            throw new ChannelException("Channel " + this.getConfig().getExternalName() + " could not find VirtualConnectionFactory");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "start: Obtained inbound vcfactory " + this.inboundVCF);
        }
    }

    public void stop(long l) throws ChannelException {
        this.svc = null;
        this.inboundVCF = null;
    }

    public void init() throws ChannelException {
        if (this.isSecure()) {
            this.sslChannel = new WSSSLChannel(this.getConfig());
            this.sslChannel.init();
        }
    }

    public void destroy() throws ChannelException {
    }

    public Class getApplicationInterface() {
        return HttpOutboundServiceContext.class;
    }

    public void update(ChannelData channelData) {
    }

    public HttpChannelConfig getHttpConfig() {
        return this.httpConfig;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public ProtoSSLEngine createSSLEngine(VirtualConnection virtualConnection, Object object) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating outbound SSLEngine for " + virtualConnection);
        }
        if (!this.isSecure() || null == this.sslChannel) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "createSSLEngine: throwing exception, secure=" + this.isSecure());
            }
            throw new Exception("Attempted secure connection for non-secure channel");
        }
        try {
            TCPConnectRequestContext tCPConnectRequestContext = (TCPConnectRequestContext)object;
            SSLContext sSLContext = this.sslChannel.getSSLContextForOutboundLink(null, virtualConnection, object);
            return SSLUtils.getOutboundSSLEngine(sSLContext, (SSLLinkConfig)virtualConnection.getStateMap().get("SSLLINKCONFIG"), tCPConnectRequestContext.getRemoteAddress().getHostName(), tCPConnectRequestContext.getRemoteAddress().getPort());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)(((Object)((Object)this)).getClass().getName() + ".createSSLEngine"), (String)"202");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "createSSLEngine: received exception->" + exception);
            }
            throw exception;
        }
    }

    public String getFFDCDumpData() {
        return this.getFFDCDumpData(null);
    }

    public String getFFDCDumpData(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = null == stringBuffer ? new StringBuffer() : stringBuffer;
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("ChannelName", this.getName(), stringBuffer2);
        if (null != this.getHttpConfig()) {
            stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString(" HttpChannelConfig : ", this.getHttpConfig().toString(), stringBuffer2);
        }
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("      secure:", String.valueOf(this.secure), stringBuffer2);
        stringBuffer2 = LHttpChannelDiagnosticModule.formatFFDCString("      WSSSLChannel: ", this.sslChannel.toString(), stringBuffer2);
        return stringBuffer2.toString();
    }
}

