/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngine;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.localhttp.channel.LHttpSSLConnectionContext;
import com.ibm.ws.localhttp.channel.LocalChannelRegistryService;
import com.ibm.ws.localhttp.channel.LocalHttpConfigConstants;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundChannel;
import com.ibm.ws.localhttp.channel.inbound.impl.LHttpInboundLink;
import com.ibm.ws.localhttp.channel.outbound.impl.LHttpOutboundChannel;
import com.ibm.ws.localhttp.channel.outbound.impl.LHttpOutboundServiceContext;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.OutboundProtocol;
import com.ibm.wsspi.channel.base.OutboundConnectorLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import javax.security.auth.Subject;

public class LHttpOutboundLink
extends OutboundConnectorLink
implements LocalHttpConfigConstants,
OutboundProtocol {
    private static final TraceComponent tc = Tr.register(LHttpOutboundLink.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private static ContextManager contextManager = SecurityContext.getContextManager();
    private static boolean bSecureEnv = SecurityContext.isSecurityEnabled();
    private LHttpOutboundChannel channelRef;
    private LocalChannelRegistryService svc;
    private LHttpSSLConnectionContext lhttpSSLConnCtxt = null;
    private int connectPort = 0;
    private VirtualConnectionFactory inboundVCF = null;
    private LHttpInboundChannel peerInboundChannel = null;
    private VirtualConnection peerInboundVC;
    private LHttpInboundLink peerInboundLink = null;
    private LHttpOutboundServiceContext oscRef = null;
    private HttpAddress targetAddress;

    LHttpOutboundLink(VirtualConnection virtualConnection, VirtualConnectionFactory virtualConnectionFactory, LocalChannelRegistryService localChannelRegistryService, LHttpOutboundChannel lHttpOutboundChannel) {
        this.init(virtualConnection);
        this.inboundVCF = virtualConnectionFactory;
        this.svc = localChannelRegistryService;
        this.channelRef = lHttpOutboundChannel;
        this.oscRef = null;
    }

    public void connectAsynch(Object object) {
        try {
            this.connect(object);
        }
        catch (Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not connect to peer" + exception);
            }
            this.getApplicationCallback().destroy(exception);
            return;
        }
        this.getApplicationCallback().ready(this.getVirtualConnection());
    }

    public void connect(Object object) throws Exception {
        if (null == this.svc) {
            throw new Exception("Local Channel Registry service unavailable");
        }
        if (null == object) {
            throw new Exception("No port specified");
        }
        this.targetAddress = (HttpAddress)object;
        this.peerInboundVC = this.inboundVCF.createConnection();
        this.connectPort = this.targetAddress.getRemoteAddress().getPort();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Using port: " + this.connectPort + " to locate local inbound channel");
        }
        String string = String.valueOf(this.connectPort) + "#Port";
        this.peerInboundChannel = (LHttpInboundChannel)this.svc.lookupInboundChannel(string);
        if (null == this.peerInboundChannel) {
            throw new Exception("No local channel associated with " + string);
        }
        ProtoSSLEngine protoSSLEngine = null;
        if (this.channelRef.isSecure() && this.peerInboundChannel.isSecure()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Beginning SSL Handshake for local channels");
            }
            ProtoSSLEngine protoSSLEngine2 = this.channelRef.createSSLEngine(this.getVirtualConnection(), object);
            protoSSLEngine = this.peerInboundChannel.createSSLEngine(this.peerInboundVC);
            SSLUtils.handleHandshake(protoSSLEngine2, protoSSLEngine);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Finished SSL Handshake for local channels");
            }
            this.setSSLConnectionContext(new LHttpSSLConnectionContext(protoSSLEngine2));
        } else if (this.channelRef.isSecure() || this.peerInboundChannel.isSecure()) {
            String string2 = "Outbound channel is " + (this.channelRef.isSecure() ? "secure" : "not secure") + " while Inbound channel is " + (this.peerInboundChannel.isSecure() ? "secure" : "not secure");
            throw new Exception(string2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "start: Located inbound channel " + (Object)((Object)this.peerInboundChannel));
        }
        this.peerInboundVC.getStateMap().put("LHttpOutboundLink", this);
        this.peerInboundLink = this.peerInboundChannel.getHttpLink(this.peerInboundVC);
        if (this.peerInboundChannel.isSecure()) {
            this.peerInboundLink.setSSLConnectionContext(new LHttpSSLConnectionContext(protoSSLEngine));
        }
    }

    public int getConnectPort() {
        return this.connectPort;
    }

    public HttpAddress getTargetAddress() {
        return this.targetAddress;
    }

    public Object getChannelAccessor() {
        if (null == this.oscRef) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getChannelAccessor: creating new OutboundService context");
            }
            this.oscRef = new LHttpOutboundServiceContext(this.getVirtualConnection(), this.channelRef.getHttpConfig(), this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getChannelAccessor: returning ctxt " + this.oscRef + "for this link " + this);
        }
        return this.oscRef;
    }

    public String getProtocol() {
        return "HTTP";
    }

    public void ready(VirtualConnection virtualConnection) {
    }

    public void destroy(Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        super.destroy(exception);
        if (null != this.oscRef) {
            this.oscRef.destroy();
            this.oscRef = null;
        }
        this.disconnect();
        if (null != this.lhttpSSLConnCtxt) {
            this.lhttpSSLConnCtxt.destroy();
            this.lhttpSSLConnCtxt = null;
        }
        this.channelRef = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public boolean isConnected() {
        return this.peerInboundLink != null;
    }

    public void transferRequest(HttpRequestMessage httpRequestMessage) {
        if (null != this.peerInboundLink) {
            this.peerInboundLink.transferRequest(httpRequestMessage);
        }
    }

    public void transferRequestBody(WsByteBuffer[] wsByteBufferArray, boolean bl) {
        if (null != this.peerInboundLink) {
            this.peerInboundLink.transferRequestBody(wsByteBufferArray, bl);
        }
    }

    public void transferResponse(HttpResponseMessage httpResponseMessage) {
        this.oscRef.transferResponse(httpResponseMessage);
    }

    public void transferResponseBody(WsByteBuffer[] wsByteBufferArray) {
        this.oscRef.transferResponseBody(wsByteBufferArray);
    }

    public void dispatch() {
        Subject[] subjectArray;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "dispatch : (secure=" + bSecureEnv + ") " + this);
            }
            subjectArray = null;
            if (bSecureEnv && null == (subjectArray = this.saveSecurity())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "dispatch: failure saving security");
                }
                return;
            }
            try {
                this.peerInboundLink.ready(this.peerInboundVC);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "LHttpOutboundLink.dispatch", "101");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception from peer inbound ready(): " + exception);
            }
        }
        this.oscRef.resetRequestOwnership();
        if (bSecureEnv) {
            this.restoreSecurity(subjectArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "dispatch");
        }
    }

    private Subject[] saveSecurity() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Saving security subjects...");
        }
        Subject[] subjectArray = new Subject[2];
        try {
            subjectArray[0] = contextManager.getInvocationSubject();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Saved invokedSubject: " + subjectArray[0]);
            }
            subjectArray[1] = contextManager.getCallerSubject();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Saved receivedSubject: " + subjectArray[1]);
            }
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, "LHttpOutboundLink.saveSecurity", "%C", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception saving security contexts: " + wSSecurityException);
            }
            this.generateError(403);
            return null;
        }
        return subjectArray;
    }

    private boolean restoreSecurity(Subject[] subjectArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Restoring security subjects");
        }
        try {
            if (null != subjectArray[0]) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restoring invokedSub: " + subjectArray[0]);
                }
                contextManager.setInvocationSubject(subjectArray[0]);
            }
            if (null != subjectArray[1]) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Restoring receivedSub: " + subjectArray[1]);
                }
                contextManager.setCallerSubject(subjectArray[1]);
            }
        }
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, "LHttpOutboundLink.restoreSecurity", "%C", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception restoring security contexts: " + wSSecurityException);
            }
            this.generateError(403);
            return false;
        }
        return true;
    }

    private void generateError(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Generating error response message, status=" + n);
        }
        HttpResponseMessage httpResponseMessage = this.oscRef.getResponse();
        httpResponseMessage.clear();
        httpResponseMessage.setStatusCode(n);
        httpResponseMessage.setConnection(HttpConstants.CONN_CLOSE);
        this.oscRef.cleanUnusedResponseBuffers();
    }

    public void disconnect() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "disconnect: " + this);
        }
        if (null != this.peerInboundVC) {
            this.peerInboundVC.getStateMap().remove("LHttpOutboundLink");
        }
        this.peerInboundLink = null;
        this.peerInboundVC = null;
        this.inboundVCF = null;
        this.svc = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "disconnect");
        }
    }

    public SSLConnectionContext getSSLConnectionContext() {
        return this.lhttpSSLConnCtxt;
    }

    public void setSSLConnectionContext(LHttpSSLConnectionContext lHttpSSLConnectionContext) {
        this.lhttpSSLConnCtxt = lHttpSSLConnectionContext;
    }
}

