/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.localhttp.channel.outbound.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.impl.HttpBaseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpChannelConfig;
import com.ibm.ws.http.channel.impl.HttpObjectFactory;
import com.ibm.ws.http.channel.impl.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.impl.HttpResponseMessageImpl;
import com.ibm.ws.http.channel.impl.HttpServiceContextImpl;
import com.ibm.ws.localhttp.channel.LocalHttpChannelUtils;
import com.ibm.ws.localhttp.channel.outbound.impl.LHttpOutboundLink;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.genericbnf.exception.IllegalRequestObjectException;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.exception.BodyCompleteException;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import com.ibm.wsspi.tcp.channel.SSLConnectionContext;
import java.io.IOException;

public class LHttpOutboundServiceContext
extends HttpServiceContextImpl
implements HttpOutboundServiceContext {
    private static final TraceComponent tc = Tr.register(LHttpOutboundServiceContext.class, "LocalHttpChannel", "com.ibm.ws.localhttp.channel.resources.localhttpmessages");
    private static final int INCREASE_SIZE = 10;
    private LHttpOutboundLink linkRef = null;
    private HttpRequestMessageImpl request = null;
    private boolean reqBodyCopied = false;
    private HttpResponseMessageImpl response = null;
    private WsByteBuffer[] respbody = new WsByteBuffer[10];
    private int currentIndex = 0;
    private int lastIndex = 0;
    private InterChannelCallback earlyCB = null;

    public LHttpOutboundServiceContext(VirtualConnection virtualConnection, HttpChannelConfig httpChannelConfig, LHttpOutboundLink lHttpOutboundLink) {
        this.setVC(virtualConnection);
        this.linkRef = lHttpOutboundLink;
        this.resetMsgSentState();
        this.init(null, httpChannelConfig);
        this.setRemotePort(this.linkRef.getConnectPort());
        this.setLocalPort(999999);
        this.setLocalAddr(LocalHttpChannelUtils.getLocalAddr());
        this.setRemoteAddr(this.getTargetAddress().getRemoteAddress().getAddress());
    }

    public boolean init() {
        return true;
    }

    public boolean registerReadAhead(InterChannelCallback interChannelCallback, int n) {
        return true;
    }

    public boolean enableImmediateResponseRead() {
        return true;
    }

    public VirtualConnection readNextResponse(InterChannelCallback interChannelCallback, boolean bl) {
        interChannelCallback.error(this.getVC(), (Throwable)new Exception("Unable to process over local http"));
        return null;
    }

    public void registerEarlyRead(InterChannelCallback interChannelCallback) {
        if (null == interChannelCallback) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "registerEarlyRead: Invalid null callback as input.");
            }
            throw new IllegalArgumentException("Callback is null");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel requesting early response read on " + this.getVC());
        }
        this.earlyCB = interChannelCallback;
    }

    public boolean deregisterEarlyRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "App channel deregistering the early read interest");
        }
        this.earlyCB = null;
        return true;
    }

    protected boolean reconnectAllowed() {
        return false;
    }

    protected HttpBaseMessageImpl getMessageBeingParsed() {
        return this.response;
    }

    protected HttpBaseMessageImpl getMessageBeingSent() {
        return this.request;
    }

    public HttpObjectFactory getObjectFactory() {
        return LocalHttpChannelUtils.getObjectFactory();
    }

    public void setRequest(HttpRequestMessage httpRequestMessage) throws IllegalRequestObjectException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setRequest: " + httpRequestMessage);
        }
        if (this.headersSent()) {
            throw new IllegalRequestObjectException("Message already sent");
        }
        if (null != this.request && this.isRequestOwner()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "setRequest destroying existing msg: " + this.request);
            }
            this.request.destroy();
        }
        this.request = (HttpRequestMessageImpl)httpRequestMessage;
        this.request.setOwner(this);
    }

    private void formatBodyHeaders(WsByteBuffer[] wsByteBufferArray, boolean bl) {
        if (-1 != this.request.getContentLength() || this.request.isChunkedEncodingSet()) {
            return;
        }
        boolean bl2 = HttpConstants.HTTP_VERSION_11.equals(this.request.getVersionValue());
        int n = LocalHttpChannelUtils.sizeOf(wsByteBufferArray);
        if (bl && bl2) {
            LocalHttpChannelUtils.addChunkedEncoding(this.request);
        } else if (0 == n) {
            this.updateBodyLengthHeaders(this.request);
        } else {
            this.request.setContentLength(n);
        }
    }

    public void sendRequestHeaders() throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestHeaders(sync): " + this);
        }
        if (!this.linkRef.isConnected()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not connected to a server.");
            }
            throw new IOException("Not connected locally");
        }
        if (this.headersSent()) {
            throw new MessageSentException("Headers already sent");
        }
        this.formatBodyHeaders(null, true);
        this.request.headerComplianceCheck();
        this.linkRef.transferRequest(this.request);
        this.setHeadersSent();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestHeaders(sync)");
        }
    }

    public VirtualConnection sendRequestHeaders(InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestHeaders(async): vc=" + this.getVC());
        }
        try {
            this.sendRequestHeaders();
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendRequestHeaders(async): error, ioe=" + iOException);
            }
            return null;
        }
        VirtualConnection virtualConnection = this.getVC();
        if (bl) {
            interChannelCallback.complete(this.getVC());
            virtualConnection = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestHeaders(async): rc=" + virtualConnection);
        }
        return virtualConnection;
    }

    private void sendRequestBody(WsByteBuffer[] wsByteBufferArray, boolean bl) throws IOException, MessageSentException {
        if (this.isMessageSent()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message already sent for " + this);
            }
            throw new MessageSentException("Message already sent");
        }
        if (!this.linkRef.isConnected()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Not connected to outbound link");
            }
            throw new IOException("Not connected locally");
        }
        if (!this.headersSent()) {
            this.formatBodyHeaders(wsByteBufferArray, true);
            this.sendRequestHeaders();
        }
        if (null != wsByteBufferArray) {
            if (bl && !this.reqBodyCopied) {
                this.linkRef.transferRequestBody(wsByteBufferArray, false);
            } else {
                this.linkRef.transferRequestBody(LocalHttpChannelUtils.copyBuffers(wsByteBufferArray), true);
                this.reqBodyCopied = true;
            }
        }
    }

    public void sendRequestBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestBody(sync): vc=" + this.getVC());
        }
        this.sendRequestBody(wsByteBufferArray, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestBody(sync)");
        }
    }

    public VirtualConnection sendRequestBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sendRequestBody(async): vc=" + this.getVC());
        }
        try {
            this.sendRequestBody(wsByteBufferArray, false);
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "sendRequestBody(async): error, ioe=" + iOException);
            }
            return null;
        }
        VirtualConnection virtualConnection = this.getVC();
        if (bl) {
            interChannelCallback.complete(this.getVC());
            virtualConnection = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sendRequestBody(async): rc=" + virtualConnection);
        }
        return virtualConnection;
    }

    public void sendRawRequestBody(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.sendRequestBody(wsByteBufferArray);
    }

    public VirtualConnection sendRawRequestBody(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.sendRequestBody(wsByteBufferArray, interChannelCallback, bl);
    }

    public void finishRequestMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRequestMessage(sync): vc=" + this.getVC());
        }
        if (!this.headersSent()) {
            this.formatBodyHeaders(wsByteBufferArray, false);
        }
        this.sendRequestBody(wsByteBufferArray, true);
        this.setMessageSent();
        this.linkRef.dispatch();
        if (null != this.earlyCB) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling app channel early read callback.complete");
            }
            this.earlyCB.complete(this.getVC());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRequestMessage(sync)");
        }
    }

    public VirtualConnection finishRequestMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishRequestMessage(async): vc=" + this.getVC());
        }
        try {
            if (!this.headersSent()) {
                this.formatBodyHeaders(wsByteBufferArray, false);
            }
            this.sendRequestBody(wsByteBufferArray, true);
            this.setMessageSent();
            this.linkRef.dispatch();
        }
        catch (IOException iOException) {
            interChannelCallback.error(this.getVC(), (Throwable)iOException);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "finishRequestMessage(async): error, ioe=" + iOException);
            }
            return null;
        }
        VirtualConnection virtualConnection = this.getVC();
        if (bl) {
            interChannelCallback.complete(this.getVC());
            virtualConnection = null;
        }
        if (null != this.earlyCB) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling app channel early read callback.complete");
            }
            this.earlyCB.complete(this.getVC());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishRequestMessage(async): rc=" + virtualConnection);
        }
        return virtualConnection;
    }

    public void finishRawRequestMessage(WsByteBuffer[] wsByteBufferArray) throws IOException, MessageSentException {
        this.finishRequestMessage(wsByteBufferArray);
    }

    public VirtualConnection finishRawRequestMessage(WsByteBuffer[] wsByteBufferArray, InterChannelCallback interChannelCallback, boolean bl) throws MessageSentException {
        return this.finishRequestMessage(wsByteBufferArray, interChannelCallback, bl);
    }

    public boolean disallowRewrites() {
        return true;
    }

    public boolean allowRewrites() {
        return false;
    }

    public WsByteBuffer[] getResponseBodyBuffers() {
        WsByteBuffer[] wsByteBufferArray = null;
        int n = this.lastIndex - this.currentIndex;
        if (0 < n) {
            wsByteBufferArray = new WsByteBuffer[n];
            int n2 = 0;
            int n3 = this.currentIndex;
            while (n2 < n) {
                wsByteBufferArray[n2] = this.respbody[n3];
                this.respbody[n3] = null;
                ++n2;
                ++n3;
            }
            this.currentIndex = this.lastIndex;
        }
        return wsByteBufferArray;
    }

    public VirtualConnection getResponseBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getResponseBodyBuffers: forced async");
            }
            interChannelCallback.complete(this.getVC());
            return null;
        }
        return this.getVC();
    }

    public WsByteBuffer getResponseBodyBuffer() {
        WsByteBuffer wsByteBuffer = null;
        if (this.currentIndex < this.lastIndex) {
            wsByteBuffer = this.respbody[this.currentIndex];
            this.respbody[this.currentIndex] = null;
            ++this.currentIndex;
        }
        return wsByteBuffer;
    }

    public VirtualConnection getResponseBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        if (bl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getResponseBodyBuffer: forced async");
            }
            interChannelCallback.complete(this.getVC());
            return null;
        }
        return this.getVC();
    }

    public WsByteBuffer getRawResponseBodyBuffer() {
        return this.getResponseBodyBuffer();
    }

    public WsByteBuffer[] getRawResponseBodyBuffers() {
        return this.getResponseBodyBuffers();
    }

    public VirtualConnection getRawResponseBodyBuffer(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        return this.getResponseBodyBuffer(interChannelCallback, bl);
    }

    public VirtualConnection getRawResponseBodyBuffers(InterChannelCallback interChannelCallback, boolean bl) throws BodyCompleteException {
        return this.getResponseBodyBuffers(interChannelCallback, bl);
    }

    public HttpRequestMessage getRequest() {
        if (null == this.request) {
            this.request = this.getObjectFactory().getRequest(this);
            if (null == this.linkRef.getSSLConnectionContext()) {
                this.request.setScheme(HttpConstants.SCHEME_HTTP);
            } else {
                this.request.setScheme(HttpConstants.SCHEME_HTTPS);
            }
        }
        return this.request;
    }

    public HttpResponseMessage getResponse() {
        return this.response;
    }

    public boolean isIncomingMessageFullyRead() {
        return true;
    }

    public boolean isInboundConnection() {
        return false;
    }

    public void setReadTimeout(int n) throws IllegalArgumentException {
    }

    public void setWriteTimeout(int n) throws IllegalArgumentException {
    }

    public SSLConnectionContext getSSLContext() {
        return this.linkRef.getSSLConnectionContext();
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "clear: " + this);
        }
        this.earlyCB = null;
        this.resetMsgParsedState();
        this.resetMsgSentState();
        if (this.isRequestOwner() && null != this.request) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing request message: " + this.request);
            }
            this.request.clear();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing reference to request: " + this.request);
            }
            this.request = null;
        }
        this.reqBodyCopied = false;
        if (this.isResponseOwner() && null != this.response) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Clearing response message: " + this.response);
            }
            this.response.clear();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Removing reference to response: " + this.response);
            }
            this.response = null;
        }
        this.cleanUnusedResponseBuffers();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "clear");
        }
    }

    public void destroy() {
        if (null != this.request && this.isRequestOwner()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Destroying request: " + this.request);
            }
            this.request.destroy();
        }
        this.request = null;
        if (null != this.response && this.isResponseOwner()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Destroying response: " + this.response);
            }
            this.response.destroy();
        }
        this.response = null;
    }

    protected void cleanUnusedResponseBuffers() {
        for (int i = this.currentIndex; i < this.lastIndex; ++i) {
            this.respbody[i].release();
            this.respbody[i] = null;
        }
        this.lastIndex = 0;
        this.currentIndex = 0;
    }

    public void transferResponse(HttpResponseMessage httpResponseMessage) {
        this.response = (HttpResponseMessageImpl)httpResponseMessage;
        this.setHeadersParsed();
        this.response.setOwner(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "transferResponse: obtained response; status = " + this.getResponse().getStatusCodeAsInt());
        }
    }

    public void transferResponseBody(WsByteBuffer[] wsByteBufferArray) {
        if (null != wsByteBufferArray) {
            int n;
            int n2 = 0;
            int n3 = wsByteBufferArray.length - (this.respbody.length - this.lastIndex);
            if (n3 > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Increasing body storage list: overflow=" + n3);
                }
                n = n3 > 10 ? n3 : 10;
                WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[this.respbody.length + n];
                System.arraycopy(this.respbody, 0, wsByteBufferArray2, 0, this.lastIndex);
                this.respbody = wsByteBufferArray2;
            }
            n = this.lastIndex;
            while (n2 < wsByteBufferArray.length && null != wsByteBufferArray[n2]) {
                this.respbody[n] = wsByteBufferArray[n2];
                ++n2;
                ++n;
            }
            this.lastIndex = n;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "transferResponseBody: saved (" + n2 + "/" + wsByteBufferArray.length + ") buffers");
            }
        }
    }

    public boolean cancelOutstandingRead() {
        return true;
    }

    public boolean cancelOutstandingWrite() {
        return true;
    }

    public HttpAddress getTargetAddress() {
        return this.linkRef.getTargetAddress();
    }
}

