/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ws.logging.LoggerHelper;
import com.ibm.ws.logging.WsLogger;
import com.ibm.ws.logging.cbe.EventFactoryHelper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

class WsLoggerConfigurator {
    static final String CLASSNAME = "com.ibm.ws.logging.WsLoggerConfigurator";
    private static final String[] CONFIGURATION_RESOURCE_NAMES = new String[]{"META-INF/Logger.properties", "Logger.properties"};
    private static final String ATTRIBUTE_NAME_ORGANIZATION = "organization";
    private static final String ATTRIBUTE_NAME_PRODUCT = "product";
    private static final String ATTRIBUTE_NAME_COMPONENT = "component";
    private static final String ATTRIBUTE_NAME_MINIMUM_LOCALIZATION_LEVEL = "minimum_localization_level";
    private static final String ATTRIBUTE_NAME_GROUP = "group";
    private static final String ATTRIBUTE_NAME_ASYNC = "async";
    private static final String ATTRIBUTE_NAME_EVENTFACTORY = "eventfactory";
    private static WsLoggerConfigurator singleton = new WsLoggerConfigurator();
    private WeakHashMap ivLoggingConfigurations = null;
    private Logger ivLogger = null;
    private Vector ivLoggingQueue = null;

    private WsLoggerConfigurator() {
    }

    static WsLoggerConfigurator getInstance() {
        return singleton;
    }

    private HashMap getLoggerConfiguration(Logger logger) {
        HashMap hashMap = null;
        HashMap hashMap2 = this.getCurrentLoggingConfiguration();
        if (hashMap2 != null && hashMap2.size() > 0) {
            HashMap<String, String> hashMap3 = null;
            Map.Entry entry = null;
            String string = null;
            String string2 = null;
            Iterator iterator = hashMap2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                string = (String)entry.getKey();
                int n = string.lastIndexOf(46);
                if (n == -1 || n >= string.length() - 1 || !logger.getName().startsWith(string.substring(0, n))) continue;
                if (hashMap3 == null) {
                    hashMap3 = new HashMap<String, String>();
                }
                if (hashMap3.containsKey(string2 = string.substring(n + 1)) && string.length() <= ((String)hashMap3.get(string2)).length()) continue;
                hashMap3.put(string2, string);
            }
            if (hashMap3 != null) {
                hashMap = new HashMap();
                iterator = hashMap3.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    hashMap.put(entry.getKey(), hashMap2.get(entry.getValue()));
                }
            }
        }
        return hashMap;
    }

    private HashMap getExtensionPointLoggingConfiguration() {
        final HashMap hashMap = new HashMap();
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
                if (iExtensionRegistry == null) {
                    WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Unable to get eclipse extension registry", null);
                    return null;
                }
                String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".logger-properties";
                IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
                if (iExtensionPoint == null) {
                    WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Unable to get extension point - " + string, null);
                    return null;
                }
                WsLoggerConfigurator.this.logMessage(Level.FINE, "getExtensionPointLoggingConfiguration", "Processing extension point " + string, null);
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                for (int i = 0; i < iExtensionArray.length; ++i) {
                    IExtension iExtension = iExtensionArray[i];
                    WsLoggerConfigurator.this.logMessage(Level.FINE, "getExtensionPointLoggingConfiguration", "Processing extension " + iExtension.getUniqueIdentifier(), null);
                    IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                    if (iConfigurationElementArray.length == 0) {
                        WsLoggerConfigurator.this.logMessage(Level.FINE, "getExtensionPointLoggingConfiguration", "No data provided for extension.", null);
                        continue;
                    }
                    if (iConfigurationElementArray.length != 1) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid number of main elements - " + iConfigurationElementArray.length, null);
                        continue;
                    }
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
                    if (!iConfigurationElement.getName().equals("logger-properties")) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid name of main element - expecting <logger-properties> but got <" + iConfigurationElement.getName() + ">", null);
                        continue;
                    }
                    IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren();
                    if (iConfigurationElementArray2.length == 0) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <logger> elements", null);
                        continue;
                    }
                    for (int j = 0; j < iConfigurationElementArray2.length; ++j) {
                        IConfigurationElement[] iConfigurationElementArray3;
                        IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[j];
                        if (!iConfigurationElement2.getName().equals("logger")) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid name for element - expecting <logger> but got <" + iConfigurationElement2.getName() + ">", null);
                            continue;
                        }
                        String string2 = iConfigurationElement2.getAttribute("prefix-name");
                        if (string2 == null || string2.length() == 0) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "No value specified for prefix-name", null);
                            continue;
                        }
                        if (!string2.endsWith(".")) {
                            string2 = string2 + ".";
                        }
                        if ((iConfigurationElementArray3 = iConfigurationElement2.getChildren()).length == 0) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <property> elements", null);
                            continue;
                        }
                        for (int k = 0; k < iConfigurationElementArray3.length; ++k) {
                            IConfigurationElement iConfigurationElement3 = iConfigurationElementArray3[k];
                            if (!iConfigurationElement3.getName().equals("property")) {
                                WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Invalid name for element - expecting <property> but got <" + iConfigurationElement3.getName() + ">", null);
                                continue;
                            }
                            String string3 = iConfigurationElement3.getAttribute("key");
                            if (string3 == null || string3.length() == 0) {
                                WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <key> element", null);
                                continue;
                            }
                            String string4 = iConfigurationElement3.getAttribute("value");
                            if (string4 == null || string4.length() == 0) {
                                WsLoggerConfigurator.this.logMessage(Level.WARNING, "getExtensionPointLoggingConfiguration", "Missing required <value> element", null);
                                continue;
                            }
                            hashMap.put(string2 + string3, string4);
                        }
                    }
                }
                return null;
            }
        });
        return hashMap;
    }

    private HashMap getCurrentLoggingConfiguration() {
        String string = "getCurrentLoggingConfiguration";
        HashMap hashMap = null;
        ClassLoader classLoader = this.getContextClassLoader();
        if (classLoader != null) {
            if (this.ivLoggingConfigurations != null) {
                hashMap = (HashMap)this.ivLoggingConfigurations.get(classLoader);
            } else {
                this.ivLoggingConfigurations = new WeakHashMap();
            }
            if (hashMap == null) {
                hashMap = this.getExtensionPointLoggingConfiguration();
                for (int i = 0; i < CONFIGURATION_RESOURCE_NAMES.length; ++i) {
                    Vector vector = this.getResources(classLoader, CONFIGURATION_RESOURCE_NAMES[i]);
                    for (int j = 0; j < vector.size(); ++j) {
                        this.addProperties(hashMap, this.getPropertiesFromURL((URL)vector.elementAt(j)));
                    }
                }
                this.ivLoggingConfigurations.put(classLoader, hashMap);
            }
        } else {
            this.logMessage(Level.WARNING, string, "Obtained context class loader is null.", null);
        }
        return hashMap;
    }

    void configureLogger(Logger logger) {
        String string = "configureLogger";
        if (logger == null) {
            throw new NullPointerException("logger passed as argument to configureLogger must not be null");
        }
        if (!(logger instanceof WsLogger)) {
            throw new IllegalArgumentException("Logger passed as argument to configureLogger must be a named logger");
        }
        HashMap hashMap = this.getLoggerConfiguration(logger);
        String string2 = null;
        if (hashMap != null && !hashMap.isEmpty()) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                boolean bl = false;
                if (!(k instanceof String)) {
                    this.logMessage(Level.WARNING, string, "Supplied Map key " + k.toString() + " is of type " + k.getClass().getName() + ".  Keys must be String typed.  Ignoring key value pair.", null);
                }
                if (!(v instanceof String)) {
                    this.logMessage(Level.WARNING, string, "Supplied Map value " + v.toString() + " is of type " + k.getClass().getName() + ".  Values must be String typed.  Ignoring key value pair.", null);
                } else if (((String)k).equals(ATTRIBUTE_NAME_PRODUCT)) {
                    ((WsLogger)logger).setProduct((String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_COMPONENT)) {
                    ((WsLogger)logger).setComponent((String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_ORGANIZATION)) {
                    ((WsLogger)logger).setOrganization((String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_MINIMUM_LOCALIZATION_LEVEL)) {
                    ((WsLogger)logger).setMinimumLocalizationLevel(Level.parse((String)v));
                } else if (((String)k).equals(ATTRIBUTE_NAME_GROUP)) {
                    LoggerHelper.addLoggerToGroup(logger, (String)v);
                } else if (((String)k).equals(ATTRIBUTE_NAME_ASYNC)) {
                    ((WsLogger)logger).setAsync(((String)v).equalsIgnoreCase("true"));
                } else if (((String)k).equals(ATTRIBUTE_NAME_EVENTFACTORY)) {
                    string2 = (String)v;
                } else {
                    bl = true;
                }
                if (bl) continue;
                iterator.remove();
            }
            if (!hashMap.isEmpty()) {
                LoggerHelper.addExtensions(logger, hashMap);
            }
        }
        ((WsLogger)logger).setEventFactory(EventFactoryHelper.getEventFactory(string2));
    }

    protected ClassLoader getContextClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (Exception exception) {
            this.logMessage(Level.WARNING, "getContextClassLoader", "Exception caught while obtainaing context classloader: " + exception, null);
            classLoader = null;
        }
        return classLoader;
    }

    protected Vector getResources(final ClassLoader classLoader, final String string) {
        final Vector vector = new Vector();
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Enumeration<URL> enumeration = null;
                    try {
                        enumeration = classLoader != null ? classLoader.getResources(string) : ClassLoader.getSystemResources(string);
                    }
                    catch (IOException iOException) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getResources", "Exception caught while obtaining resources named " + string, new Object[]{iOException});
                    }
                    if (enumeration != null && enumeration.hasMoreElements()) {
                        while (enumeration.hasMoreElements()) {
                            vector.add(enumeration.nextElement());
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            this.logMessage(Level.WARNING, "getResources", "Exception caught while obtaining resources named " + string, new Object[]{exception});
        }
        return vector;
    }

    private void addProperties(HashMap hashMap, Properties properties) {
        if (properties != null && properties.size() > 0) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashMap.put(string, properties.get(string));
            }
        }
    }

    private Properties getPropertiesFromURL(final URL uRL) {
        final Properties properties = new Properties();
        try {
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    InputStream inputStream = null;
                    try {
                        inputStream = uRL.openStream();
                    }
                    catch (IOException iOException) {
                        WsLoggerConfigurator.this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught when opening stream for resouce " + uRL.toString(), null);
                    }
                    if (inputStream != null) {
                        try {
                            properties.load(inputStream);
                        }
                        catch (IOException iOException) {
                            WsLoggerConfigurator.this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught when loading properties from stream for resouce " + uRL.toString(), null);
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            this.logMessage(Level.WARNING, "getPropertiesFromURL", "Exception caught from doPrivileged block loading properties frome resource " + uRL.toString(), null);
        }
        return properties;
    }

    private void logMessage(Level level, String string, String string2, Object[] objectArray) {
        if (this.ivLogger != null) {
            if (this.ivLoggingQueue != null) {
                while (!this.ivLoggingQueue.isEmpty()) {
                    this.ivLogger.log((LogRecord)this.ivLoggingQueue.elementAt(0));
                    this.ivLoggingQueue.remove(0);
                }
            }
            this.ivLogger.logp(level, CLASSNAME, string, string2, objectArray);
        } else {
            LogRecord logRecord = new LogRecord(level, string2);
            logRecord.setLoggerName(CLASSNAME);
            logRecord.setSourceClassName(CLASSNAME);
            logRecord.setSourceMethodName(string);
            logRecord.setParameters(objectArray);
            if (this.ivLoggingQueue == null) {
                this.ivLoggingQueue = new Vector();
            }
            this.ivLoggingQueue.add(logRecord);
        }
    }

    void setInternalLogger(Logger logger) {
        if (this.ivLogger == null) {
            this.ivLogger = logger;
            this.logMessage(Level.FINEST, "setInternalLogger", "Internal logger initialized.", null);
        }
    }
}

