/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ws.logging.ZNativeHelper;
import com.ibm.ws.logging.ZNativeHelperImpl;
import com.ibm.ws.security.util.AccessController;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZRasHelper {
    private static ZNativeHelper iZNativeHelper;
    private static ProcessInfo sProcessInfo;
    private static ThreadLocal sThreadInfo;
    private static Logger logger;
    private static final String EMPTY_STRING = "";

    public static final ProcessInfo getProcessInfo() {
        return sProcessInfo;
    }

    public static final ThreadInfo getThreadInfo() {
        return (ThreadInfo)sThreadInfo.get();
    }

    public static String getCorrelator() {
        return iZNativeHelper.getCorrelator();
    }

    private ZRasHelper() {
    }

    public static void initNative() {
        String string = RasHelper.getVersionId();
        String string2 = ZRasHelper.getPlatform();
        String string3 = RasHelper.getServerName();
        String string4 = ZRasHelper.getHostName();
        iZNativeHelper.initNative(string, string2, string3, string4);
    }

    private static String getPlatform() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    String string = System.getProperty("os.name");
                    String string2 = System.getProperty("os.arch");
                    String string3 = System.getProperty("os.version");
                    if (string == null) {
                        string = ZRasHelper.EMPTY_STRING;
                    }
                    if (string2 == null) {
                        string2 = ZRasHelper.EMPTY_STRING;
                    }
                    if (string3 == null) {
                        string3 = ZRasHelper.EMPTY_STRING;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string).append("[").append(string2).append("]#").append(string3);
                    return stringBuffer.toString();
                }
            });
        }
        catch (Throwable throwable) {
            return null;
        }
        return string;
    }

    private static String getHostName() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
        }
        catch (Throwable throwable) {
            logger.logp(Level.WARNING, ZRasHelper.class.getName(), "getHostName", "EXCEPTION_NULL_HOSTNAME", throwable);
            throw new RuntimeException("Unable to obtain host name", throwable);
        }
        if (string == null) {
            logger.logp(Level.WARNING, ZRasHelper.class.getName(), "getHostName", "EXCEPTION_NULL_HOSTNAME");
            throw new RuntimeException("Returned host name is null");
        }
        return string;
    }

    static {
        logger = Logger.getLogger(ZRasHelper.class.getName());
        iZNativeHelper = new ZNativeHelperImpl();
        sProcessInfo = new ProcessInfo();
        sThreadInfo = new ThreadLocal(){

            protected Object initialValue() {
                ThreadInfo threadInfo = new ThreadInfo();
                return threadInfo;
            }
        };
    }

    public static class ThreadInfo {
        private final String iTCBAddress = ZRasHelper.access$200().getTCBAddress();
        private final String iTId = ZRasHelper.access$200().getTId();

        private ThreadInfo() {
        }

        public String getTCBAddress() {
            return this.iTCBAddress;
        }

        public String getTId() {
            return this.iTId;
        }
    }

    public static class ProcessInfo {
        private static String sAddressSpaceId;
        private static String sJobName;
        private static int sLogRecordSize;
        private static String sPId;
        private static String sServer;
        private static String sSystemJobId;
        private static String sSystemName;

        private ProcessInfo() {
        }

        public static final String getAddressSpaceId() {
            return sAddressSpaceId;
        }

        public static final String getJobName() {
            return sJobName;
        }

        public static final int getLogRecordSize() {
            return sLogRecordSize;
        }

        public static final String getPId() {
            return sPId;
        }

        public static final String getServer() {
            return sServer;
        }

        public static final String getSystemJobId() {
            return sSystemJobId;
        }

        public static final String getSystemName() {
            return sSystemName;
        }

        static {
            boolean bl = RasHelper.isServer();
            sLogRecordSize = bl ? iZNativeHelper.getLogRecordSize() : -1;
            sServer = bl ? iZNativeHelper.getServer() : null;
            sSystemJobId = bl ? iZNativeHelper.getSystemJobId() : null;
            sAddressSpaceId = iZNativeHelper.getAddressSpaceId();
            sJobName = iZNativeHelper.getJobName();
            sPId = iZNativeHelper.getPId();
            sSystemName = iZNativeHelper.getSystemName();
        }
    }
}

