/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.cbe;

import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.UnsupportedEncodingException;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CBEHandlerAdapter
extends Handler {
    Handler ivDelegate;
    boolean ibAutoComplete;
    int iCBEConversionLevelInt;

    public CBEHandlerAdapter(Handler handler2, boolean bl, Level level) {
        this.ivDelegate = handler2;
        this.ibAutoComplete = bl;
        this.iCBEConversionLevelInt = level != null ? level.intValue() : Level.ALL.intValue();
    }

    public void publish(LogRecord logRecord) {
        int n;
        int n2 = logRecord.getLevel().intValue();
        if (n2 < (n = this.ivDelegate.getLevel().intValue())) {
            return;
        }
        if (n2 >= this.iCBEConversionLevelInt) {
            CommonBaseEventLogRecord commonBaseEventLogRecord = WsLogRecordFactory.convertToCBELogRecord(logRecord);
            if (this.ibAutoComplete) {
                try {
                    commonBaseEventLogRecord.getCommonBaseEvent().complete();
                }
                catch (CompletionException completionException) {
                    // empty catch block
                }
            }
            this.ivDelegate.publish((LogRecord)commonBaseEventLogRecord);
        } else {
            this.ivDelegate.publish(logRecord);
        }
    }

    public void close() throws SecurityException {
        this.ivDelegate.close();
    }

    public void flush() {
        this.ivDelegate.flush();
    }

    public String getEncoding() {
        return this.ivDelegate.getEncoding();
    }

    public ErrorManager getErrorManager() {
        return this.ivDelegate.getErrorManager();
    }

    public Filter getFilter() {
        return this.ivDelegate.getFilter();
    }

    public Formatter getFormatter() {
        return this.ivDelegate.getFormatter();
    }

    public synchronized Level getLevel() {
        return this.ivDelegate.getLevel();
    }

    public int hashCode() {
        return this.ivDelegate.hashCode();
    }

    public boolean isLoggable(LogRecord logRecord) {
        return this.ivDelegate.isLoggable(logRecord);
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        this.ivDelegate.setEncoding(string);
    }

    public void setErrorManager(ErrorManager errorManager) {
        this.ivDelegate.setErrorManager(errorManager);
    }

    public void setFilter(Filter filter) throws SecurityException {
        this.ivDelegate.setFilter(filter);
    }

    public void setFormatter(Formatter formatter) throws SecurityException {
        this.ivDelegate.setFormatter(formatter);
    }

    public synchronized void setLevel(Level level) throws SecurityException {
        this.ivDelegate.setLevel(level);
    }

    public String toString() {
        return this.ivDelegate.toString();
    }
}

