/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.models.base.resources.jdbc.WAS40DataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.ResourceMgr;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.cred.Credential;
import com.ibm.ws.security.util.PasswordUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.LoginException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class DataSourceConfigHelperMBean
extends RuntimeCollaborator {
    static final String resBundle = "IBMDataStoreAdapterNLS";
    private static final TraceComponent tc = Tr.register(DataSourceConfigHelperMBean.class, "Admin", "IBMDataStoreAdapterNLS");
    private static Class configHelper = null;
    private static Method getPropertiesForDataSource = null;
    private static Method testConnectionToDataSource = null;
    private static Method testConnectionForGUI = null;
    private VariableMap variableMap = null;
    private VariableMap contextMap = null;
    private Repository repository = null;

    public DataSourceConfigHelperMBean(VariableMap variableMap, Repository repository2) throws NoSuchMethodException {
        this.variableMap = variableMap;
        this.repository = repository2;
    }

    private synchronized Class getConfigHelper() throws ClassNotFoundException {
        if (configHelper == null) {
            configHelper = Class.forName("com.ibm.ws.rsadapter.DSConfigurationHelper");
        }
        return configHelper;
    }

    public ArrayList getPropertiesForDataSource(String string, String string2) throws ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesForDataSource", new Object[]{string, string2});
        }
        if (getPropertiesForDataSource == null) {
            try {
                getPropertiesForDataSource = this.getConfigHelper().getMethod("getPropertiesForDataSource", String.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.management.DataSourceConfigHelperMBean.getPropertiesForDataSource", "65", this);
            }
        }
        string2 = this.variableMap.expand(string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expanded libPath to " + string2);
        }
        Object object = null;
        try {
            object = getPropertiesForDataSource.invoke(null, string, string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.management.DataSourceConfigHelperMBean.getPropertiesForDataSource", "74", this);
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.management.DataSourceConfigHelperMBean.getPropertiesForDataSource", "77", this);
            throw (ClassNotFoundException)invocationTargetException.getTargetException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesForDataSource", object);
        }
        return (ArrayList)object;
    }

    public String testConnectionToDataSource(String string, String string2, String string3, Properties properties, String string4, String string5, String string6) throws ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnectionToDataSource", new Object[]{string, string2, properties, string4, string5, string6});
        }
        this.reload();
        if (testConnectionToDataSource == null) {
            try {
                testConnectionToDataSource = this.getConfigHelper().getMethod("testConnectionToDataSource", String.class, String.class, String.class, Properties.class, String.class, String.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.management.DataSourceConfigHelperMBean.testConnectionToDataSource", "141", this);
            }
        }
        string4 = this.variableMap.expand(string4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expanded libPath to " + string4);
        }
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        Object object = properties2.propertyNames();
        while (object.hasMoreElements()) {
            String string7 = (String)object.nextElement();
            String string8 = properties2.getProperty(string7);
            if (string7.equals("databaseName")) {
                string8 = this.variableMap.expand(string8);
            }
            properties2.put(string7, string8);
        }
        object = null;
        try {
            object = testConnectionToDataSource.invoke(null, string, string2, string3, properties2, string4, string5, string6);
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.management.DataSourceConfigHelperMBean.testConnectionToDataSource", "152", this);
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.management.DataSourceConfigHelperMBean.testConnectionToDataSource", "155", this);
            throw (ClassNotFoundException)invocationTargetException.getTargetException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnectionToDataSource", object);
        }
        return (String)object;
    }

    public void reload() {
        try {
            this.variableMap.refresh();
            if (AdminServiceFactory.getAdminService().getProcessType().equals("NodeAgent")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot Call reload() on ResourceMgr because the service: JNDI name space does not exist");
                }
            } else {
                InitialContext initialContext = new InitialContext();
                ResourceMgr resourceMgr = (ResourceMgr)initialContext.lookup("services:websphere/Resources/ResourceManager");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling reload() on ResourceMgr");
                }
                resourceMgr.reload();
            }
        }
        catch (NamingException namingException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "services:websphere/Resources/ResourceManager is not a valid name");
            }
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.management.DataSourceConfigHelperMBean.reload", "275", this);
        }
        catch (RuntimeError runtimeError) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught runtime error exception = " + runtimeError);
            }
            FFDCFilter.processException((Throwable)runtimeError, "com.ibm.ws.management.DataSourceConfigHelperMBean.reload", "279", this);
        }
        catch (RuntimeWarning runtimeWarning) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "caught Runtime Warning exception = " + runtimeWarning);
            }
            FFDCFilter.processException((Throwable)runtimeWarning, "com.ibm.ws.management.DataSourceConfigHelperMBean.reload", "283", this);
        }
    }

    public int testConnection(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection", new Object[]{string});
        }
        this.reload();
        String string2 = null;
        int n = string.lastIndexOf(40);
        int n2 = string.lastIndexOf(41);
        string2 = n != -1 && n2 != -1 ? string.substring(n + 1, n2) : string;
        Hashtable hashtable = null;
        try {
            hashtable = this.extractWCCMCommonInfo(string2);
            String string3 = (String)hashtable.get("dsClassName");
            String string4 = (String)hashtable.get("user");
            String string5 = (String)hashtable.get("password");
            String string6 = (String)hashtable.get("providerLibPath");
            String string7 = (String)hashtable.get("factory");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling testConnection() on " + string7);
            }
            if (string7.equals("DataSource") || string7.equals("WAS40DataSource")) {
                Properties properties = (Properties)hashtable.get("customProperties");
                properties.remove("_Websphere_Config_Data_Type");
                properties.remove("_Websphere_Config_Data_Id");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Going into final test with these : ");
                    Tr.debug(tc, "dsClassName " + string3);
                    Tr.debug(tc, "user " + string4);
                    Tr.debug(tc, "dataSourceProps " + properties.getClass().getName() + properties);
                    Tr.debug(tc, "providerLibPath " + string6);
                }
                return this.testConnectionToDataSource2(string3, string4, string5, properties, string6);
            }
            if (string7.equals("CICSFactory")) {
                Tr.error(tc, "TEST_DS_FAIL", new Object[]{"", "NLS:CICS not yet implmented"});
                throw new Exception("NLS:CICS not yet implmented");
            }
            Tr.error(tc, "TEST_DS_FAIL", new Object[]{"", "NLS:Unknown resource specified"});
            throw new Exception("NLS:Unknown resource specified");
        }
        catch (Throwable throwable) {
            Tr.error(tc, "TEST_DS_FAIL", new Object[]{"", throwable});
            throwable.printStackTrace();
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw new SQLException(throwable.toString());
        }
    }

    private int testConnectionToDataSource2(String string, String string2, String string3, Properties properties, String string4) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnectionForGUI", new Object[]{properties, string, string2, string4});
        }
        Integer n = null;
        try {
            if (testConnectionForGUI == null) {
                testConnectionForGUI = this.getConfigHelper().getMethod("testConnectionForGUI", String.class, String.class, String.class, Properties.class, String.class);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking test connection on the helper");
            }
            n = (Integer)testConnectionForGUI.invoke(null, string, string2, string3, properties, string4);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invocation exception, real exception =  " + throwable.toString());
            }
            throwable.printStackTrace();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnectionForGUI", n);
        }
        return n;
    }

    private synchronized Hashtable extractWCCMCommonInfo(String string) throws Exception {
        Object object;
        String string2;
        Hashtable<String, Object> hashtable;
        block65: {
            String string3;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string4;
            String string5;
            String string6;
            hashtable = new Hashtable<String, Object>();
            ConfigDataId configDataId = new ConfigDataId(string);
            String string7 = AdminServiceFactory.getAdminService().getProcessType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, configDataId.getContextUri() + configDataId.getHref());
                Tr.debug(tc, "MBean is running in a process of type: " + string7);
            }
            ObjectName objectName = new ObjectName("WebSphere", "_Websphere_Config_Data_Id", string);
            Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scope =" + properties);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(17);
            hashMap.put("CELL", this.repository.getCellName());
            hashMap.put("NODE", this.repository.getNodeName());
            hashMap.put("CLUSTER", this.repository.getClusterName());
            if (properties.containsKey("server")) {
                hashMap.put("SERVER", properties.getProperty("server"));
            } else {
                hashMap.put("SERVER", this.repository.getServerName());
            }
            this.contextMap = VariableMapFactory.createVariableMap(hashMap);
            Resource resource = null;
            ConfigRoot configRoot = this.repository.getConfigRoot();
            if (properties.containsKey("server")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for server-scoped resource.");
                    Tr.debug(tc, "ConfigRoot being changed from " + configRoot.getValue(4) + " to " + properties.getProperty("server"));
                }
                configRoot.setValue(4, properties.getProperty("server"));
                resource = configRoot.getResource(4, "resources.xml");
                this.contextMap.addVariableMap(configRoot.getResource(0, "variables.xml"));
                this.contextMap.addVariableMap(configRoot.getResource(3, "variables.xml"));
                this.contextMap.addVariableMap(configRoot.getResource(4, "variables.xml"));
            } else if (properties.containsKey("node")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for node-scoped resource.");
                }
                resource = configRoot.getResource(3, "resources.xml");
                this.contextMap.addVariableMap(configRoot.getResource(0, "variables.xml"));
                this.contextMap.addVariableMap(configRoot.getResource(3, "variables.xml"));
                if (string7.equals("ManagedProcess") || string7.equals("UnManagedProcess")) {
                    this.contextMap.addVariableMap(configRoot.getResource(4, "variables.xml"));
                }
            } else if (properties.containsKey("application")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for application-scoped resource.");
                }
                string6 = properties.getProperty("application");
                string5 = null;
                string5 = string6.length() > 4 && string6.substring(string6.length() - 4).equalsIgnoreCase(".ear") ? string6.substring(0, string6.length() - 4) : string6;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConfigRoot APPLICATION value set to " + properties.getProperty("application"));
                    Tr.debug(tc, "ConfigRoot SERVER value set to " + configRoot.getValue(4));
                    Tr.debug(tc, "ConfigRoot CLUSTER value set to " + configRoot.getValue(2));
                    Tr.debug(tc, "ConfigRoot NODE value set to " + configRoot.getValue(3));
                    Tr.debug(tc, "ConfigRoot CELL value set to " + configRoot.getValue(0));
                }
                configRoot.setValue(1, properties.getProperty("application"));
                resource = configRoot.getResource(1, "deployments" + File.separator + string5 + File.separator + "resources.xml");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding Cell variables to Map...");
                }
                this.contextMap.addVariableMap(configRoot.getResource(0, "variables.xml"));
                if (string7.equals("NodeAgent")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Node variables to Map...");
                    }
                    this.contextMap.addVariableMap(configRoot.getResource(3, "variables.xml"));
                }
                if (string7.equals("ManagedProcess") || string7.equals("UnManagedProcess")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Node and Server variables to Map...");
                    }
                    this.contextMap.addVariableMap(configRoot.getResource(3, "variables.xml"));
                    this.contextMap.addVariableMap(configRoot.getResource(4, "variables.xml"));
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding Application variables to Map...");
                    }
                    this.contextMap.addVariableMap(configRoot.getResource(1, "deployments" + File.separator + string5 + File.separator + "variables.xml"));
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else if (properties.containsKey("cluster")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for cluster-scoped resource.");
                }
                configRoot.setValue(2, properties.getProperty("cluster"));
                resource = configRoot.getResource(2, "resources.xml");
                this.contextMap.addVariableMap(configRoot.getResource(0, "variables.xml"));
                if (string7.equals("NodeAgent") || string7.equals("ManagedProcess")) {
                    this.contextMap.addVariableMap(configRoot.getResource(3, "variables.xml"));
                }
                try {
                    this.contextMap.addVariableMap(configRoot.getResource(2, "variables.xml"));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (string7.equals("ManagedProcess")) {
                    this.contextMap.addVariableMap(configRoot.getResource(4, "variables.xml"));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Do setup for cell-scoped resource.");
                }
                resource = configRoot.getResource(0, "resources.xml");
                this.contextMap.addVariableMap(configRoot.getResource(0, "variables.xml"));
                if (string7.equals("NodeAgent")) {
                    this.contextMap.addVariableMap(configRoot.getResource(3, "variables.xml"));
                }
                if (string7.equals("ManagedProcess") || string7.equals("UnManagedProcess")) {
                    this.contextMap.addVariableMap(configRoot.getResource(3, "variables.xml"));
                    this.contextMap.addVariableMap(configRoot.getResource(4, "variables.xml"));
                }
            }
            string6 = URI.createURI((String)configDataId.getHref());
            String string8 = null;
            try {
                string5 = (DataSource)resource.getEObject(string6.fragment());
                if (string5 == null) {
                    String string9 = TraceNLS.getFormattedMessage(resBundle, "TEST_DS_NOT_FOUND", Locale.getDefault(), new Object[0], "The DataSource was not found.  Be sure that the DataSource has been saved before attempting the Test Connection operation");
                    Tr.error(tc, string9);
                    throw new SQLException(string9);
                }
                hashtable.put("factory", "DataSource");
                string4 = null;
                object5 = null;
                try {
                    object4 = WSDefaultPrincipalMapping.getAuthData(((DataSource)string5).getAuthDataAlias());
                    if (object4 != null) {
                        string4 = ((Credential)object4).getUserName();
                        object5 = ((Credential)object4).getPassword();
                    } else {
                        object3 = ((DataSource)string5).getMapping();
                        if (object3 != null && (object4 = WSDefaultPrincipalMapping.getAuthData(object3.getAuthDataAlias())) != null) {
                            string4 = ((Credential)object4).getUserName();
                            object5 = ((Credential)object4).getPassword();
                        }
                    }
                }
                catch (LoginException loginException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string4 != null) {
                    hashtable.put("user", string4);
                }
                if (object5 != null) {
                    hashtable.put("password", object5);
                }
                string8 = ((DataSource)string5).getDatasourceHelperClassname();
            }
            catch (ClassCastException classCastException) {
                string5 = (WAS40DataSource)resource.getEObject(string6.fragment());
                hashtable.put("factory", "WAS40DataSource");
                object5 = ((WAS40DataSource)string5).getDefaultUser();
                object4 = ((WAS40DataSource)string5).getDefaultPassword();
                if (object5 != null) {
                    hashtable.put("user", object5);
                }
                if (object4 != null) {
                    hashtable.put("password", object4);
                }
            }
            string4 = (JDBCProvider)string5.getProvider();
            object5 = new Properties();
            object4 = string5.getPropertySet();
            if (object4 != null) {
                object3 = object4.getResourceProperties();
                for (int i = 0; i < object3.size(); ++i) {
                    object2 = (J2EEResourceProperty)object3.get(i);
                    string2 = object2.getValue();
                    if (string2 == null) continue;
                    object = object2.getName();
                    if (((String)object).toLowerCase().indexOf("password") != -1) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Decoding property : " + (String)object);
                        }
                        try {
                            ((Properties)object5).put(object, PasswordUtil.passwordDecode(string2));
                            continue;
                        }
                        catch (NullPointerException nullPointerException) {
                            Tr.error(tc, "decode of custom property password " + (String)object + " returned null, the most likely cause of" + "this is the password was encoded using an unsupported encryption algorithm . ");
                            throw nullPointerException;
                        }
                    }
                    ((Properties)object5).put(object, string2);
                }
            }
            if (hashtable.get("factory").equals("WAS40DataSource") && (object3 = ((WAS40DataSource)string5).getDatabaseName()) != null) {
                ((Properties)object5).setProperty("databaseName", (String)object3);
            }
            if ((object3 = ((Properties)object5).getProperty("databaseName")) != null) {
                ((Properties)object5).setProperty("databaseName", this.contextMap.expand((String)object3));
            }
            if ((string3 = ((Properties)object5).getProperty("serverName")) != null) {
                ((Properties)object5).setProperty("serverName", this.contextMap.expand(string3));
            }
            if (string8 != null) {
                ((Properties)object5).setProperty("dataStoreHelperClass", string8);
            }
            if (string7.equals("UnManagedProcess") || string7.equals("ManagedProcess")) {
                ((Properties)object5).setProperty("mbeanProcessType", "server");
            } else {
                ((Properties)object5).setProperty("mbeanProcessType", "other");
            }
            hashtable.put("customProperties", object5);
            hashtable.put("providerLibPath", this.expandPath((List)string4.getClasspath()));
            object2 = string4.getImplementationClassName();
            if (object2 != null) {
                hashtable.put("dsClassName", this.contextMap.expand((String)object2));
            }
            string2 = "";
            try {
                string2 = this.expandPath((List)string4.getNativepath());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!tc.isDebugEnabled()) break block65;
                Tr.debug(tc, "IllegalStateException ignored while expanding nativepath.\nCOULD be due to a referenced variable which is not defined at the testing scope.\n");
            }
        }
        hashtable.put("nativepath", string2);
        if (tc.isDebugEnabled()) {
            object = hashtable.keys();
            Enumeration enumeration = hashtable.elements();
            while (object.hasMoreElements()) {
                Tr.debug(tc, object.nextElement() + " = " + enumeration.nextElement());
            }
        }
        return hashtable;
    }

    private String expandPath(List list) {
        StringBuffer stringBuffer = null;
        Iterator iterator = list.iterator();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Converting " + list.toString());
        }
        while (iterator.hasNext()) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.contextMap.expand((String)iterator.next()));
                continue;
            }
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(this.contextMap.expand((String)iterator.next()));
        }
        if (stringBuffer == null) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String testConnectionToDataSource(String string, String string2, String string3, Properties properties, String string4, Locale locale) throws ClassNotFoundException {
        return this.testConnectionToDataSource(string, string2, string3, properties, string4, locale.getLanguage(), locale.getCountry());
    }
}

