/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import java.util.LinkedList;
import java.util.logging.Logger;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class MBeanConverter {
    private static Logger logger = Logger.getLogger(MBeanConverter.class.getName());

    public static ModelMBeanInfo convert(Object object) throws NotCompliantMBeanException {
        DynamicMBean dynamicMBean;
        logger.entering(MBeanConverter.class.getName(), "convert", object);
        logger.finest("Checking if mbean is standard and if so, creating  a new StandardMBean object.");
        Object[] objectArray = MBeanConverter.isStandardMBean(object);
        Boolean bl = (Boolean)objectArray[0];
        Class clazz = (Class)objectArray[1];
        if (bl.booleanValue()) {
            dynamicMBean = new StandardMBean(object, clazz);
        } else {
            logger.finest("MBean was not standard.");
            dynamicMBean = (DynamicMBean)object;
        }
        logger.finest("Getting mbean info from dynamic mbean.");
        MBeanInfo mBeanInfo = dynamicMBean.getMBeanInfo();
        String string = mBeanInfo.getDescription();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        MBeanConstructorInfo[] mBeanConstructorInfoArray = mBeanInfo.getConstructors();
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        MBeanNotificationInfo[] mBeanNotificationInfoArray = mBeanInfo.getNotifications();
        logger.finest("Creating model mbean info objects from dynamic mbean.");
        Object[] objectArray2 = MBeanConverter.getModelMBeanAttributeInfo(mBeanAttributeInfoArray, bl);
        MBeanAttributeInfo[] mBeanAttributeInfoArray2 = (ModelMBeanAttributeInfo[])objectArray2[0];
        LinkedList linkedList = (LinkedList)objectArray2[1];
        MBeanConstructorInfo[] mBeanConstructorInfoArray2 = MBeanConverter.getModelMBeanConstructorInfo(mBeanConstructorInfoArray);
        MBeanOperationInfo[] mBeanOperationInfoArray2 = MBeanConverter.getModelMBeanOperationInfo(mBeanOperationInfoArray, bl, linkedList);
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = MBeanConverter.getModelMBeanNotificationInfo(mBeanNotificationInfoArray);
        logger.finest("Creating the ModelMBeanInfo object.");
        ModelMBeanInfoSupport modelMBeanInfoSupport = new ModelMBeanInfoSupport(object.getClass().getName(), string, (ModelMBeanAttributeInfo[])mBeanAttributeInfoArray2, (ModelMBeanConstructorInfo[])mBeanConstructorInfoArray2, (ModelMBeanOperationInfo[])mBeanOperationInfoArray2, (ModelMBeanNotificationInfo[])mBeanNotificationInfoArray2);
        logger.finest("Now printing the newly created ModelMBeanInfo objects...");
        MBeanConverter.logMBeanAttributeInfo(mBeanAttributeInfoArray2);
        MBeanConverter.logMBeanConstructorInfo(mBeanConstructorInfoArray2);
        MBeanConverter.logMBeanOperationInfo(mBeanOperationInfoArray2);
        MBeanConverter.logMBeanNotificationInfo(mBeanNotificationInfoArray2);
        logger.finest("Now done printing ModelMBeanInfo objects for mbean " + object + "...");
        MBeanConverter.logMBeanAttributeDescriptorInfo((ModelMBeanAttributeInfo[])mBeanAttributeInfoArray2);
        logger.exiting(MBeanConverter.class.getName(), "convert");
        return modelMBeanInfoSupport;
    }

    private static Object[] getModelMBeanAttributeInfo(MBeanAttributeInfo[] mBeanAttributeInfoArray, Boolean bl) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanAttributeInfo", new Object[]{mBeanAttributeInfoArray, bl});
        LinkedList<ModelMBeanOperationInfo> linkedList = new LinkedList<ModelMBeanOperationInfo>();
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = new ModelMBeanAttributeInfo[mBeanAttributeInfoArray.length];
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            ModelMBeanOperationInfo modelMBeanOperationInfo;
            DescriptorSupport descriptorSupport;
            logger.finest("Setting descriptors for attribute " + mBeanAttributeInfoArray[i].getName() + ".");
            DescriptorSupport descriptorSupport2 = new DescriptorSupport();
            descriptorSupport2.setField("name", mBeanAttributeInfoArray[i].getName());
            descriptorSupport2.setField("descriptorType", "attribute");
            logger.finest("Creating ModelMBeanAttributeInfo object for attribute " + mBeanAttributeInfoArray[i].getName() + ".");
            modelMBeanAttributeInfoArray[i] = new ModelMBeanAttributeInfo(mBeanAttributeInfoArray[i].getName(), mBeanAttributeInfoArray[i].getType(), mBeanAttributeInfoArray[i].getDescription(), mBeanAttributeInfoArray[i].isReadable(), mBeanAttributeInfoArray[i].isWritable(), mBeanAttributeInfoArray[i].isIs(), descriptorSupport2);
            if (mBeanAttributeInfoArray[i].isReadable()) {
                logger.finest("Attribute " + mBeanAttributeInfoArray[i].getName() + " isReadable.");
                descriptorSupport2.setField("getMethod", "get" + mBeanAttributeInfoArray[i].getName());
                if (bl.booleanValue()) {
                    logger.finest("Creating descriptor for newly created getter for attribute " + mBeanAttributeInfoArray[i].getName() + ".");
                    descriptorSupport = new DescriptorSupport();
                    descriptorSupport.setField("name", "get" + mBeanAttributeInfoArray[i].getName());
                    descriptorSupport.setField("descriptorType", "operation");
                    descriptorSupport.setField("role", "getter");
                    logger.finest("Creating ModelMBeanOperationInfo object for newly created getter for attribute " + mBeanAttributeInfoArray[i].getName());
                    modelMBeanOperationInfo = new ModelMBeanOperationInfo("get" + mBeanAttributeInfoArray[i].getName(), "Getter for attribute: " + mBeanAttributeInfoArray[i].getName(), null, mBeanAttributeInfoArray[i].getType(), 0, descriptorSupport);
                    linkedList.add(modelMBeanOperationInfo);
                }
            } else if (mBeanAttributeInfoArray[i].isIs()) {
                logger.finest("Attribute: " + mBeanAttributeInfoArray[i].getName() + " isIs.");
                descriptorSupport2.setField("getMethod", "is" + mBeanAttributeInfoArray[i].getName());
                if (bl.booleanValue()) {
                    logger.finest("Creating descriptors for newly created boolean getter operation for attribute " + mBeanAttributeInfoArray[i].getName() + ".");
                    descriptorSupport = new DescriptorSupport();
                    descriptorSupport.setField("name", "is" + mBeanAttributeInfoArray[i].getName());
                    descriptorSupport.setField("descriptorType", "operation");
                    descriptorSupport.setField("role", "getter");
                    logger.finest("Creating ModelMBeanOperationInfo object for newly created boolean getter operation for attribute " + mBeanAttributeInfoArray[i].getName() + ".");
                    modelMBeanOperationInfo = new ModelMBeanOperationInfo("get" + mBeanAttributeInfoArray[i].getName(), "Getter for attribute: " + mBeanAttributeInfoArray[i].getName(), null, mBeanAttributeInfoArray[i].getType(), 0, descriptorSupport);
                    linkedList.add(modelMBeanOperationInfo);
                }
            }
            if (mBeanAttributeInfoArray[i].isWritable()) {
                logger.finest("Attribute: " + mBeanAttributeInfoArray[i].getName() + " isWritable.");
                descriptorSupport2.setField("setMethod", "set" + mBeanAttributeInfoArray[i].getName());
                if (bl.booleanValue()) {
                    logger.finest("Creating descriptors for newly created setter operation attribute " + mBeanAttributeInfoArray[i].getName() + ".");
                    descriptorSupport = new DescriptorSupport();
                    descriptorSupport.setField("name", "set" + mBeanAttributeInfoArray[i].getName());
                    descriptorSupport.setField("descriptorType", "operation");
                    descriptorSupport.setField("role", "setter");
                    logger.finest("Creating ModelMBeanOperationInfo object for newly created setter operation for attribute " + mBeanAttributeInfoArray[i].getName() + ".");
                    modelMBeanOperationInfo = new ModelMBeanOperationInfo("set" + mBeanAttributeInfoArray[i].getName(), "Setter for attribute: " + mBeanAttributeInfoArray[i].getName(), new MBeanParameterInfo[]{new MBeanParameterInfo(mBeanAttributeInfoArray[i].getType(), mBeanAttributeInfoArray[i].getType(), null)}, Void.TYPE.getName(), 1, descriptorSupport);
                    linkedList.add(modelMBeanOperationInfo);
                }
            }
            modelMBeanAttributeInfoArray[i] = new ModelMBeanAttributeInfo(mBeanAttributeInfoArray[i].getName(), mBeanAttributeInfoArray[i].getType(), mBeanAttributeInfoArray[i].getDescription(), mBeanAttributeInfoArray[i].isReadable(), mBeanAttributeInfoArray[i].isWritable(), mBeanAttributeInfoArray[i].isIs(), descriptorSupport2);
        }
        Object[] objectArray = new Object[]{modelMBeanAttributeInfoArray, linkedList};
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanAttributeInfo", objectArray);
        return objectArray;
    }

    private static ModelMBeanConstructorInfo[] getModelMBeanConstructorInfo(MBeanConstructorInfo[] mBeanConstructorInfoArray) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanConstructorInfo", mBeanConstructorInfoArray);
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray = new ModelMBeanConstructorInfo[mBeanConstructorInfoArray.length];
        for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
            logger.finest("Creating ModelMBeanConstructorInfo object for constructor " + mBeanConstructorInfoArray[i].getName() + ".");
            modelMBeanConstructorInfoArray[i] = new ModelMBeanConstructorInfo(mBeanConstructorInfoArray[i].getName(), mBeanConstructorInfoArray[i].getDescription(), mBeanConstructorInfoArray[i].getSignature());
        }
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanConstructorInfo", modelMBeanConstructorInfoArray);
        return modelMBeanConstructorInfoArray;
    }

    private static ModelMBeanOperationInfo[] getModelMBeanOperationInfo(MBeanOperationInfo[] mBeanOperationInfoArray, Boolean bl, LinkedList linkedList) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanOperationInfo", new Object[]{mBeanOperationInfoArray, bl, linkedList});
        ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = new ModelMBeanOperationInfo[mBeanOperationInfoArray.length];
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            logger.finest("Creating ModelMBeanOperationInfo object for operation " + mBeanOperationInfoArray[i].getName() + ".");
            modelMBeanOperationInfoArray[i] = new ModelMBeanOperationInfo(mBeanOperationInfoArray[i].getName(), mBeanOperationInfoArray[i].getDescription(), mBeanOperationInfoArray[i].getSignature(), mBeanOperationInfoArray[i].getReturnType(), 3);
        }
        if (bl.booleanValue()) {
            int n;
            Object[] objectArray = linkedList.toArray();
            ModelMBeanOperationInfo[] modelMBeanOperationInfoArray2 = new ModelMBeanOperationInfo[modelMBeanOperationInfoArray.length + objectArray.length];
            logger.finest("Copying operations obtained from mbean conversion.");
            for (n = 0; n < modelMBeanOperationInfoArray.length; ++n) {
                modelMBeanOperationInfoArray2[n] = modelMBeanOperationInfoArray[n];
            }
            logger.finest("Copying newly created mbean operations.");
            for (n = 0; n < objectArray.length; ++n) {
                modelMBeanOperationInfoArray2[n + modelMBeanOperationInfoArray.length] = (ModelMBeanOperationInfo)objectArray[n];
            }
            modelMBeanOperationInfoArray = modelMBeanOperationInfoArray2;
        }
        String string = "";
        for (int i = 0; i < modelMBeanOperationInfoArray.length; ++i) {
            string = string + modelMBeanOperationInfoArray[i].getName() + modelMBeanOperationInfoArray[i].getDescription() + modelMBeanOperationInfoArray[i].getImpact() + modelMBeanOperationInfoArray[i].getClass() + " ; ";
        }
        logger.finest("ModelMBeanOperations that are being returned are: " + string);
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanOperationInfo", modelMBeanOperationInfoArray);
        return modelMBeanOperationInfoArray;
    }

    private static ModelMBeanNotificationInfo[] getModelMBeanNotificationInfo(MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        logger.entering(MBeanConverter.class.getName(), "getModelMBeanNotificationInfo", mBeanNotificationInfoArray);
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[mBeanNotificationInfoArray.length];
        for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
            logger.finest("Creating descriptors for notification " + mBeanNotificationInfoArray[i].getName() + ".");
            DescriptorSupport descriptorSupport = new DescriptorSupport();
            descriptorSupport.setField("name", mBeanNotificationInfoArray[i].getName());
            descriptorSupport.setField("descriptorType", "notification");
            logger.finest("Creating ModelMBeanNotificationInfo object for notification " + mBeanNotificationInfoArray[i].getName() + ".");
            modelMBeanNotificationInfoArray[i] = new ModelMBeanNotificationInfo(mBeanNotificationInfoArray[i].getNotifTypes(), mBeanNotificationInfoArray[i].getName(), mBeanNotificationInfoArray[i].getDescription(), descriptorSupport);
        }
        logger.exiting(MBeanConverter.class.getName(), "getModelMBeanNotificationInfo", modelMBeanNotificationInfoArray);
        return modelMBeanNotificationInfoArray;
    }

    private static Object[] isStandardMBean(Object object) throws NotCompliantMBeanException {
        Class<?> clazz;
        logger.entering(MBeanConverter.class.getName(), "isStandardMBean", object);
        Class<?>[] classArray = object.getClass().getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            clazz = classArray[i];
            if (classArray[i].getName().equals("javax.management.DynamicMBean")) {
                logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(false));
                return new Object[]{new Boolean(false), null};
            }
            if (!classArray[i].getName().equals(object.getClass().getName() + "MBean")) continue;
            logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(true));
            return new Object[]{new Boolean(true), clazz};
        }
        for (Class<?> clazz2 = object.getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            classArray = clazz2.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                clazz = classArray[i];
                if (classArray[i].getName().equals("javax.management.DynamicMBean")) {
                    logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(false));
                    return new Object[]{new Boolean(false), null};
                }
                if (!classArray[i].getName().equals(clazz2.getName() + "MBean")) continue;
                logger.exiting(MBeanConverter.class.getName(), "isStandardMBean", new Boolean(true));
                return new Object[]{new Boolean(true), clazz};
            }
        }
        throw new NotCompliantMBeanException();
    }

    private static void logMBeanAttributeInfo(MBeanAttributeInfo[] mBeanAttributeInfoArray) {
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            String string = mBeanAttributeInfoArray[i].getName();
            logger.finest(string + " attribute Name: " + string);
            logger.finest(string + " attribute Type: " + mBeanAttributeInfoArray[i].getType());
            logger.finest(string + " attribute Description: " + mBeanAttributeInfoArray[i].getDescription());
            logger.finest(string + " attribute isReadable: " + mBeanAttributeInfoArray[i].isReadable());
            logger.finest(string + " attribute isWritable: " + mBeanAttributeInfoArray[i].isWritable());
            logger.finest(string + " attribute isIs: " + mBeanAttributeInfoArray[i].isIs());
        }
    }

    private static void logMBeanConstructorInfo(MBeanConstructorInfo[] mBeanConstructorInfoArray) {
        String string = null;
        String string2 = null;
        MBeanParameterInfo[] mBeanParameterInfoArray = null;
        for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
            string = mBeanConstructorInfoArray[i].getName();
            logger.finest(string + " constructor Name: " + string);
            logger.finest(string + " constructor Description: " + mBeanConstructorInfoArray[i].getDescription());
            logger.finest(string + " constructor Class: " + mBeanConstructorInfoArray[i].getClass());
            mBeanParameterInfoArray = mBeanConstructorInfoArray[i].getSignature();
            if (mBeanParameterInfoArray.length == 0 || mBeanParameterInfoArray == null) {
                logger.finest(string + " constructor has a null signature. " + "Not printing parameter info.");
                continue;
            }
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                string2 = mBeanParameterInfoArray[j].getName();
                logger.finest(string2 + " parameter Name: " + mBeanParameterInfoArray[j].getName());
                logger.finest(string2 + " parameter Description: " + mBeanParameterInfoArray[j].getDescription());
                logger.finest(string2 + " parameter Type: " + mBeanParameterInfoArray[j].getType());
                logger.finest(string2 + " parameter Class: " + mBeanParameterInfoArray[j].getClass());
            }
        }
    }

    private static void logMBeanOperationInfo(MBeanOperationInfo[] mBeanOperationInfoArray) {
        String string = null;
        String string2 = null;
        MBeanParameterInfo[] mBeanParameterInfoArray = null;
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            string = mBeanOperationInfoArray[i].getName();
            logger.finest(string + " operation Name: " + string);
            logger.finest(string + " operation Description: " + mBeanOperationInfoArray[i].getDescription());
            logger.finest(string + " operation Class: " + mBeanOperationInfoArray[i].getClass());
            logger.finest(string + " operation Return Type: " + mBeanOperationInfoArray[i].getReturnType());
            logger.finest(string + " operation Impact: " + mBeanOperationInfoArray[i].getImpact());
            mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
            if (mBeanParameterInfoArray.length == 0 || mBeanParameterInfoArray == null) {
                logger.finest(string + " constructor has a null signature. " + "Not printing parameter info.");
                continue;
            }
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                string2 = mBeanParameterInfoArray[j].getName();
                logger.finest(string2 + " parameter Name: " + mBeanParameterInfoArray[j].getName());
                logger.finest(string2 + " parameter Description: " + mBeanParameterInfoArray[j].getDescription());
                logger.finest(string2 + " parameter Type: " + mBeanParameterInfoArray[j].getType());
                logger.finest(string2 + " parameter Class: " + mBeanParameterInfoArray[j].getClass());
            }
        }
    }

    private static void logMBeanNotificationInfo(MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
            String string = mBeanNotificationInfoArray[i].getName();
            logger.finest(string + " Name: " + string);
            logger.finest(string + " Description: " + mBeanNotificationInfoArray[i].getDescription());
            logger.finest(string + " Class: " + mBeanNotificationInfoArray[i].getClass());
            String[] stringArray = mBeanNotificationInfoArray[i].getNotifTypes();
            for (int j = 0; j < stringArray.length; ++j) {
                logger.finest(string + " notification type: " + stringArray[j]);
            }
        }
    }

    private static void logMBeanAttributeDescriptorInfo(ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray) {
        for (int i = 0; i < modelMBeanAttributeInfoArray.length; ++i) {
            String string = modelMBeanAttributeInfoArray[i].getName();
            Descriptor descriptor = modelMBeanAttributeInfoArray[i].getDescriptor();
            String[] stringArray = descriptor.getFields();
            String string2 = "";
            for (int j = 0; j < stringArray.length; ++j) {
                string2 = string2 + stringArray[j] + " ; ";
            }
            logger.finest("Descriptor information for attribute, " + string + ": " + string2);
        }
    }
}

