/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.MBeanRoute;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class MBeanRouter {
    private static String resBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceComponent tc = Tr.register(MBeanRouter.class, "Admin", resBundleName);
    private static TraceNLS nls = TraceNLS.getTraceNLS(resBundleName);
    private static Vector routers = new Vector();
    private static MBeanRouter[] routersArray = new MBeanRouter[0];
    private int priority = 0;

    protected MBeanRouter() {
        this(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanRouter(int n) {
        this.priority = n;
        Vector vector = routers;
        synchronized (vector) {
            int n2 = routers.size();
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                MBeanRouter mBeanRouter = (MBeanRouter)routers.get(i);
                if (n >= mBeanRouter.getPriority()) continue;
                routers.insertElementAt(this, i);
                bl = true;
                break;
            }
            if (!bl) {
                routers.add(this);
            }
            routersArray = new MBeanRouter[routers.size()];
            routers.copyInto(routersArray);
        }
    }

    public MBeanRoute findRoute(ObjectName objectName) {
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    private static MBeanRouter[] getAllRouters() {
        return routersArray;
    }

    static ObjectName transformObjectName(ObjectName objectName) throws InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transformObjectName", objectName);
        }
        if (objectName.isPattern()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transformObjectName", objectName);
            }
            return objectName;
        }
        MBeanRouter[] mBeanRouterArray = MBeanRouter.getAllRouters();
        ObjectName objectName2 = objectName;
        for (int i = 0; i < mBeanRouterArray.length; ++i) {
            MBeanRoute mBeanRoute = null;
            try {
                mBeanRoute = mBeanRouterArray[i].findRoute(objectName);
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMN1200W", new Object[]{mBeanRouterArray[i].getClass().getName(), throwable});
                FFDCFilter.processException(throwable, "com.ibm.ws.management.MBeanRouter.transformObjectName", "121");
            }
            if (mBeanRoute == null) continue;
            int n = mBeanRoute.getRouteType();
            switch (n) {
                case 0: {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "transformObjectName: UNREACHABLE_ROUTE", objectName);
                    }
                    throw new InstanceNotFoundException(objectName + " is unreachable");
                }
                case 1: {
                    objectName2 = mBeanRoute.getObjectName();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "transformObjectName", objectName2);
                    }
                    return objectName2;
                }
            }
            MBeanRouter.outputWarningAndFFDC("ADMN1201W", new Object[]{new Integer(n), mBeanRouterArray[i].getClass().getName()}, "com.ibm.ws.management.MBeanRouter.transformObjectName", "139");
            throw new InstanceNotFoundException("Unexpected MBean route type " + n + " while processing MBean ObjectName " + objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transformObjectName", objectName2);
        }
        return objectName2;
    }

    private static void outputWarningAndFFDC(String string, Object[] objectArray, String string2, String string3) {
        Tr.warning(tc, string, objectArray);
        RuntimeException runtimeException = new RuntimeException(nls.getFormattedMessage(string, objectArray, null));
        FFDCFilter.processException(runtimeException, string2, string3);
    }
}

