/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.sync.NodeSync;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public final class RoutingTable
implements NotificationListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RoutingTable.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static RoutingTable _instance;
    private Map _rt;
    private Map _rtStateMachine;
    private Map _disabled_rt;
    private Map _disabled_rtStateMachine;
    private List _routingListeners;
    private RoutingListener[] listenerArray;
    private Accessor parent;
    private StateMachine parentStateMachine;
    private StateMachineCallback parentStateMachineCallback;
    private StateMachineCallback childStateMachineCallback;
    private int numMonitorThreads = 0;
    private boolean nodeAgentListenerAdded = false;
    private ServerInfo ownInfo;
    private Map agentPingThreads = new HashMap();
    public static final String[] eventNames;
    public static final String[] stateNames;

    private RoutingTable() {
        this._rt = Collections.synchronizedMap(new HashMap());
        this._rtStateMachine = Collections.synchronizedMap(new HashMap());
        this._disabled_rt = Collections.synchronizedMap(new HashMap());
        this._disabled_rtStateMachine = Collections.synchronizedMap(new HashMap());
        this.parentStateMachine = new StateMachine();
        this.parentStateMachineCallback = new ParentStateMachineCallback();
        this.childStateMachineCallback = new ChildStateMachineCallback();
        this._routingListeners = new ArrayList();
        this.listenerArray = new RoutingListener[0];
    }

    public static synchronized RoutingTable getInstance() {
        if (_instance == null) {
            _instance = new RoutingTable();
        }
        return _instance;
    }

    public synchronized void shutdown() {
        this.parentStateMachineCallback.stopMonitor(this.parent);
        this.childStateMachineCallback.stopMonitor(this.parent);
    }

    public synchronized void addRoutingListener(RoutingListener routingListener) {
        if (routingListener != null && routingListener instanceof NodeSync) {
            this._routingListeners.add(0, routingListener);
        } else {
            this._routingListeners.add(routingListener);
        }
        this.listenerArray = this._routingListeners.toArray(new RoutingListener[0]);
    }

    public synchronized void removeRoutingListener(RoutingListener routingListener) {
        this._routingListeners.remove(routingListener);
        this.listenerArray = this._routingListeners.toArray(new RoutingListener[0]);
    }

    public String getProductVersion(String string) {
        Accessor accessor = (Accessor)this._rt.get(string);
        if (accessor != null) {
            return accessor.getServerInfo().getVersion();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminClient getParent() throws ConnectorException {
        boolean bl = false;
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parentStateMachine.getState() == 1) {
                bl = true;
            }
        }
        if (bl) {
            return this.parent.getConnector();
        }
        throw new ConnectorNotAvailableException();
    }

    public boolean connectedToParent(long l) {
        while (this.parent == null && l > 0L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l -= 500L;
        }
        return this.parent != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(String string) {
        Accessor accessor = (Accessor)this._rt.get(string);
        if (accessor != null) {
            return accessor.getSession();
        }
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parent.getName().equals(string)) {
                return this.parent.getSession();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPid(String string) {
        Accessor accessor = (Accessor)this._rt.get(string);
        if (accessor != null) {
            return accessor.getPid();
        }
        RoutingTable routingTable = this;
        synchronized (routingTable) {
            if (this.parent != null && this.parent.getName().equals(string)) {
                return this.parent.getPid();
            }
            return "";
        }
    }

    public void setOwnInfo(ServerInfo serverInfo) {
        this.ownInfo = serverInfo;
    }

    public ServerInfo getOwnInfo() {
        return this.ownInfo;
    }

    public boolean isRoutable(String string) {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRoutable", string);
        }
        if ((accessor = (Accessor)this._rt.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isRoutable - false");
            }
            return false;
        }
        boolean bl = accessor.isRoutable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRoutable: " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminClient[] getAdminClients() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClients");
        }
        AdminClient[] adminClientArray = this;
        synchronized (this) {
            Accessor[] accessorArray = new Accessor[this._rt.size()];
            accessorArray = this._rt.values().toArray(accessorArray);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            adminClientArray = new AdminClient[accessorArray.length];
            for (int i = 0; i < adminClientArray.length; ++i) {
                try {
                    adminClientArray[i] = accessorArray[i].getConnector();
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.RoutingTable.getAdminClients", "177", (Object)this);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "failed to get one AdminClient", exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminClients");
            }
            return adminClientArray;
        }
    }

    public AdminClient getAdminClient(String string) throws ConnectorException {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", string);
        }
        if ((accessor = (Accessor)this._rt.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return accessor.getConnector();
    }

    public AdminClient getAdminClient(String string, String string2) throws ConnectorException {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", new Object[]{string, string2});
        }
        if ((accessor = (Accessor)this._rt.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return accessor.getConnector(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addChild", serverInfo);
        }
        Subject subject = null;
        try {
            Accessor accessor;
            Session session;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = this.pushServerSubject();
            }
            if ((session = (accessor = new Accessor(serverInfo)).resetSession()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can't get session");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addChild", serverInfo);
                }
                return;
            }
            String string = serverInfo.getRole().equals("NodeAgent") ? serverInfo.getNode() : serverInfo.getName();
            RoutingTable routingTable = this;
            synchronized (routingTable) {
                StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(string);
                if (stateMachine == null) {
                    stateMachine = new StateMachine();
                    this._rtStateMachine.put(string, stateMachine);
                }
                stateMachine.transition(0, session, accessor, this.childStateMachineCallback);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.addChild", "247", this);
        }
        finally {
            if (subject != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChild:", serverInfo);
        }
    }

    private void childRouteAdded(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childRouteAdded", accessor);
        }
        try {
            ServerInfo serverInfo = accessor.getServerInfo();
            String string = serverInfo.getName();
            if (serverInfo.getRole().equals("NodeAgent")) {
                string = serverInfo.getNode();
            }
            this._rt.put(string, accessor);
            new AddChildThread(serverInfo).start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.addChild", "203", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChild");
        }
    }

    private void childRouteRemoved(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childRouteRemoved", accessor);
        }
        try {
            ServerInfo serverInfo = accessor.getServerInfo();
            String string = serverInfo.getName();
            if (serverInfo.getRole().equals("NodeAgent")) {
                string = serverInfo.getNode();
            }
            this._rt.remove(string);
            new RemoveChildThread(serverInfo).start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.childRouteRemoved", "314", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addChild");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeAgentListener() {
        Object object = this;
        synchronized (object) {
            if (this.nodeAgentListenerAdded) {
                return;
            }
            this.nodeAgentListenerAdded = true;
        }
        try {
            object = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.stopping");
            AdminServiceFactory.getAdminService().addNotificationListenerExtended((ObjectName)object, this, notificationFilterSupport, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    public boolean isChildDisabled(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableChild", string);
        }
        boolean bl = this._disabled_rt.containsKey(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableChild", new Boolean(bl));
        }
        return bl;
    }

    public AdminClient getDisabledAdminClient(String string) throws ConnectorException {
        Accessor accessor;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdminClient", string);
        }
        if ((accessor = (Accessor)this._disabled_rt.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAdminClient - fail");
            }
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdminClient");
        }
        return accessor.getConnector();
    }

    public void disableChild(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableChild", string);
        }
        Accessor accessor = (Accessor)this._rt.get(string);
        StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Accessor, StateMachine", new Object[]{accessor, stateMachine});
        }
        if (accessor != null) {
            this._disabled_rt.put(string, accessor);
            this._rt.remove(string);
        }
        if (stateMachine != null) {
            this._disabled_rtStateMachine.put(string, stateMachine);
            this._rtStateMachine.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableChild");
        }
    }

    public synchronized void enableChild(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enableChild", string);
        }
        Accessor accessor = (Accessor)this._disabled_rt.get(string);
        StateMachine stateMachine = (StateMachine)this._disabled_rtStateMachine.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Accessor, StateMachine", new Object[]{accessor, stateMachine});
        }
        if (accessor != null) {
            this._rt.put(string, accessor);
            this._disabled_rt.remove(string);
        }
        if (stateMachine != null) {
            this._rtStateMachine.put(string, stateMachine);
            this._disabled_rtStateMachine.remove(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enableChild");
        }
    }

    public synchronized void removeChild(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeChild", string);
        }
        this.enableChild(string);
        boolean bl = false;
        Accessor accessor = (Accessor)this._rt.get(string);
        StateMachine stateMachine = (StateMachine)this._rtStateMachine.get(string);
        if (stateMachine != null) {
            stateMachine.transition(3, null, accessor, this.childStateMachineCallback);
            this._rtStateMachine.remove(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RoutingTable removeChild:" + string + " removed from _rtStateMachine");
            }
        }
        if (accessor == null && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove - not in cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeChild");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParent(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addParent");
        }
        Subject subject = null;
        try {
            Accessor accessor;
            Session session;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = this.pushServerSubject();
            }
            if ((session = (accessor = new Accessor(serverInfo)).resetSession()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "null tmpSession");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "addParent");
                }
                return;
            }
            RoutingTable routingTable = this;
            synchronized (routingTable) {
                this.parentStateMachine.transition(0, session, accessor, this.parentStateMachineCallback);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.addParent", "399", this);
        }
        finally {
            if (subject != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addParent");
        }
    }

    private void notifyParentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyParentAdded");
        }
        for (int i = 0; i < this.listenerArray.length; ++i) {
            try {
                new notifyParentAddedThread(serverInfo, this.listenerArray[i]).start();
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.notifyParentAdded", "449", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyParentAdded");
        }
    }

    private void parentRouteAdded(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRouteAdded");
        }
        this.parent = accessor;
        try {
            new AddParentThread(accessor.getServerInfo()).start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.parentRouteAdded", "469", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentRouteAdded");
        }
    }

    private void parentRouteRemoved(Accessor accessor) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRouteRemoved");
        }
        if (this.parent == null) {
            return;
        }
        this.parent = null;
        ServerInfo serverInfo = accessor.getServerInfo();
        for (int i = 0; i < this.listenerArray.length; ++i) {
            try {
                this.listenerArray[i].parentRemoved(serverInfo);
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.removeParent", "392", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "exception thrown from the routing listener: parentRouteRemoved", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeParent");
        }
    }

    private Subject pushServerSubject() {
        Subject subject = null;
        Subject subject2 = null;
        try {
            subject2 = SecurityHelper.getOwnedSubject();
            if (subject2 != null) {
                subject = SecurityHelper.pushInvocationSubject(subject2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.RoutingTable.pushServerSubject", "612", this);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", notification);
        }
        String string = ((ObjectName)notification.getSource()).getKeyProperty("node");
        Map map = this.agentPingThreads;
        synchronized (map) {
            List list = (List)this.agentPingThreads.get(string);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ((Thread)iterator.next()).interrupt();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private synchronized void incrMonitorThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incrMonitorThreads");
        }
        ++this.numMonitorThreads;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numMonitorThread: " + this.numMonitorThreads);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incrMonitorThreads");
        }
    }

    private synchronized void decrMonitorThreads() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrMonitorThreads");
        }
        --this.numMonitorThreads;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "numMonitorThread: " + this.numMonitorThreads);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrMonitorThreads");
        }
    }

    static {
        eventNames = new String[]{"DISCOVERY_EVENT", "REACHABLE_EVENT", "NOT_REACHABLE_EVENT", "RESET_EVENT"};
        stateNames = new String[]{"INIT_STATE", "MONITOR_STATE", "RECOVERY_STATE"};
    }

    public class StateMachine {
        public static final int INIT_STATE = 0;
        public static final int MONITOR_STATE = 1;
        public static final int RECOVERY_STATE = 2;
        public static final int DISCOVERY_EVENT = 0;
        public static final int REACHABLE_EVENT = 1;
        public static final int NOT_REACHABLE_EVENT = 2;
        public static final int RESET_EVENT = 3;
        private int nodeState = 0;
        private Accessor nodeAccessor = null;

        public void transition(int n, Session session, Accessor accessor, StateMachineCallback stateMachineCallback) {
            boolean bl = false;
            try {
                String string;
                String string2 = string = session == null ? "null" : session.toString();
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "transition", new Object[]{eventNames[n], string});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "currentState: " + stateNames[this.nodeState]);
                }
                boolean bl2 = false;
                if (n == 3) {
                    switch (this.nodeState) {
                        case 0: {
                            bl = true;
                            break;
                        }
                        case 1: {
                            bl = true;
                            stateMachineCallback.routeRemoved(this.nodeAccessor);
                            this.nodeState = 0;
                            break;
                        }
                        case 2: {
                            bl = true;
                            this.nodeState = 0;
                        }
                    }
                    this.nodeAccessor = null;
                } else {
                    boolean bl3 = false;
                    Session session2 = null;
                    if (this.nodeAccessor != null) {
                        session2 = this.nodeAccessor.getSession();
                    }
                    if (session != null && session.equals(session2)) {
                        bl3 = true;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sameSession:" + bl3);
                    }
                    if (n == 0) {
                        switch (this.nodeState) {
                            case 0: {
                                this.nodeAccessor = accessor;
                                stateMachineCallback.routeAdded(accessor);
                                this.nodeState = 1;
                                bl2 = true;
                                break;
                            }
                            case 1: {
                                if (bl3) break;
                                stateMachineCallback.routeRemoved(this.nodeAccessor);
                                this.nodeAccessor = accessor;
                                stateMachineCallback.routeAdded(this.nodeAccessor);
                                bl2 = true;
                                break;
                            }
                            case 2: {
                                this.nodeAccessor = accessor;
                                stateMachineCallback.routeAdded(this.nodeAccessor);
                                this.nodeState = 1;
                                if (bl3) break;
                                bl2 = true;
                            }
                        }
                    } else if (n == 1) {
                        switch (this.nodeState) {
                            case 0: {
                                bl = true;
                                break;
                            }
                            case 1: {
                                if (bl3) break;
                                bl = true;
                                break;
                            }
                            case 2: {
                                if (bl3) {
                                    stateMachineCallback.routeAdded(this.nodeAccessor);
                                    this.nodeState = 1;
                                    break;
                                }
                                bl = true;
                            }
                        }
                    } else if (n == 2) {
                        switch (this.nodeState) {
                            case 0: {
                                bl = true;
                                break;
                            }
                            case 1: {
                                if (bl3) {
                                    stateMachineCallback.routeRemoved(this.nodeAccessor);
                                    this.nodeState = 2;
                                    break;
                                }
                                bl = true;
                                break;
                            }
                            case 2: {
                                if (bl3) break;
                                bl = true;
                            }
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unknown event: " + n);
                    }
                }
                if (bl2) {
                    stateMachineCallback.startMonitor(this.nodeAccessor);
                }
                if (bl) {
                    stateMachineCallback.stopMonitor(accessor);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.StateMachine", "602", this);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nextState: " + stateNames[this.nodeState]);
                Tr.debug(tc, "stopMonitor:" + bl);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "transition");
            }
        }

        public int getState() {
            return this.nodeState;
        }
    }

    public class ParentStateMachineCallback
    implements StateMachineCallback {
        private UpstreamPing p = null;

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeAdded");
            }
            RoutingTable.this.parentRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeRemoved");
            }
            RoutingTable.this.parentRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor");
            }
            try {
                String string = accessor.getName();
                this.p = new UpstreamPing(string, accessor, RoutingTable.this.parentStateMachine);
                this.p.setName("UpstreamPing");
                this.p.setDaemon(true);
                this.p.start();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.AddChildStateMachineCallback", "996", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startMonitor");
            }
        }

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor");
            }
            if (this.p != null) {
                this.p.stopMonitor(accessor);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopMonitor");
            }
        }
    }

    public class ChildStateMachineCallback
    implements StateMachineCallback {
        NodeAgentPing p = null;

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeAdded");
            }
            RoutingTable.this.childRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "routeRemoved");
            }
            RoutingTable.this.childRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "startMonitor");
            }
            try {
                String string;
                ServerInfo serverInfo = accessor.getServerInfo();
                String string2 = serverInfo.getName();
                if (serverInfo.getRole().equals("NodeAgent")) {
                    string2 = serverInfo.getNode();
                }
                if ((string = AdminServiceFactory.getAdminService().getProcessType()).equals("DeploymentManager")) {
                    RoutingTable.this.addNodeAgentListener();
                    StateMachine stateMachine = (StateMachine)RoutingTable.this._rtStateMachine.get(string2);
                    this.p = new NodeAgentPing(string2, accessor, stateMachine);
                    this.p.setName("NodeAgentPing");
                    this.p.setDaemon(true);
                    this.p.start();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.AddChildStateMachineCallback", "996", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "startMonitor");
            }
        }

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "stopMonitor");
            }
            if (this.p != null) {
                this.p.stopMonitor(accessor);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stopMonitor");
            }
        }
    }

    public static interface StateMachineCallback {
        public void routeAdded(Accessor var1);

        public void routeRemoved(Accessor var1);

        public void startMonitor(Accessor var1);

        public void stopMonitor(Accessor var1);
    }

    private class RemoveChildThread
    extends Thread {
        ServerInfo serverInfo;

        RemoveChildThread(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RemoveChildThread.run");
            }
            Subject subject = null;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = RoutingTable.this.pushServerSubject();
            }
            try {
                for (int i = 0; i < RoutingTable.this.listenerArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RoutingListner.parentRemoved: " + RoutingTable.this.listenerArray[i].getClass().getName());
                    }
                    try {
                        RoutingTable.this.listenerArray[i].childRemoved(this.serverInfo);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.remove", "246", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "exception thrown from the routing listener: parentRemoved", throwable);
                    }
                }
            }
            finally {
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RemoveChildThread.run");
            }
        }
    }

    private class AddParentThread
    extends Thread {
        ServerInfo serverInfo;

        AddParentThread(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AddParentThread.run");
            }
            RoutingTable.this.notifyParentAdded(this.serverInfo);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AddParentThread.run");
            }
        }
    }

    private class AddChildThread
    extends Thread {
        ServerInfo serverInfo;

        AddChildThread(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "AddChildThread.run");
            }
            Subject subject = null;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = RoutingTable.this.pushServerSubject();
            }
            try {
                for (int i = 0; i < RoutingTable.this.listenerArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RoutingListner.childAdded: " + RoutingTable.this.listenerArray[i].getClass().getName());
                    }
                    try {
                        RoutingTable.this.listenerArray[i].childAdded(this.serverInfo);
                        continue;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.addChild", "194", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "failed to execute RoutingListener.childAdded");
                    }
                }
            }
            finally {
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "AddChildThread.run");
            }
        }
    }

    private class NodeAgentPing
    extends PingThread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        NodeAgentPing(String string, Accessor accessor, StateMachine stateMachine) {
            super(string, accessor, stateMachine);
            Map map = RoutingTable.this.agentPingThreads;
            synchronized (map) {
                ArrayList<NodeAgentPing> arrayList = (ArrayList<NodeAgentPing>)RoutingTable.this.agentPingThreads.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<NodeAgentPing>();
                    RoutingTable.this.agentPingThreads.put(string, arrayList);
                }
                arrayList.add(this);
            }
        }

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NodeAgentPing.routeAdded");
            }
            RoutingTable.this.childRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "NodeAgentPing.routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NodeAgentPing.routeRemoved");
            }
            RoutingTable.this.childRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "NodeAgentPing.routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "NodeAgentPing.startMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "NodeAgentPing.startMonitor");
            }
        }
    }

    private class UpstreamPing
    extends PingThread {
        UpstreamPing(String string, Accessor accessor, StateMachine stateMachine) {
            super(string, accessor, stateMachine);
        }

        public void routeAdded(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UpstreamPing.routeAdded");
            }
            RoutingTable.this.parentRouteAdded(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "UpstreamPing.routeAdded");
            }
        }

        public void routeRemoved(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UpstreamPing.routeRemoved");
            }
            RoutingTable.this.parentRouteRemoved(accessor);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "UpstreamPing.routeRemoved");
            }
        }

        public void startMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "UpstreamPing.startMonitor");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "UpstreamPing.startMonitor");
            }
        }
    }

    private abstract class PingThread
    extends Thread
    implements StateMachineCallback {
        protected String name;
        protected Accessor accessor;
        protected StateMachine stateMachine;
        protected boolean stopMonitor = false;

        PingThread(String string, Accessor accessor, StateMachine stateMachine) {
            this.name = string;
            this.accessor = accessor;
            this.stateMachine = stateMachine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "PingThread.run", this.name);
            }
            Subject subject = null;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = RoutingTable.this.pushServerSubject();
            }
            RoutingTable.this.incrMonitorThreads();
            try {
                object = System.getProperty("com.ibm.websphere.management.monitoring.pingInterval", "60");
                int n = new Integer((String)object);
                object = System.getProperty("com.ibm.websphere.management.monitoring.pingMaximumAttempts", "1");
                int n2 = new Integer((String)object);
                int n3 = 0;
                object = System.getProperty("com.ibm.websphere.management.monitoring.shortPingInterval", "5");
                int n4 = new Integer((String)object);
                object = System.getProperty("com.ibm.websphere.management.monitoring.shortPingMaximumAttempts", "10");
                int n5 = new Integer((String)object);
                boolean bl = false;
                AdminClient adminClient = this.accessor.getConnector();
                Session session = this.accessor.getSession();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pingInterval is: " + n);
                    Tr.debug(tc, "pingMaxiumAttempts is: " + n2);
                    Tr.debug(tc, "session is: " + session);
                }
                int n6 = 0;
                while (!this.stopMonitor) {
                    try {
                        RoutingTable routingTable;
                        boolean bl2;
                        block41: {
                            bl2 = false;
                            Session session2 = null;
                            try {
                                session2 = adminClient.isAlive();
                                if (session2 == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "got null session");
                                    }
                                    break block41;
                                }
                                if (!session2.equals(session)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "got new session:" + session2);
                                    }
                                    break;
                                }
                                bl2 = true;
                            }
                            catch (Throwable throwable) {
                                if (!tc.isDebugEnabled()) break block41;
                                Tr.debug(tc, "unable to reach parent. Got exception " + throwable);
                            }
                        }
                        if (bl2) {
                            n6 = 0;
                            routingTable = RoutingTable.this;
                            synchronized (routingTable) {
                                this.stateMachine.transition(1, session, this.accessor, this);
                            }
                        } else if (++n6 == n2) {
                            n6 = 0;
                            routingTable = RoutingTable.this;
                            synchronized (routingTable) {
                                this.stateMachine.transition(2, session, this.accessor, this);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "node not reachable, curAttempts : " + n6);
                        }
                        if (this.stopMonitor) continue;
                        if (n3 > 0) {
                            if (++n3 >= n5) {
                                n3 = 0;
                            }
                            Thread.sleep(n4 * 1000);
                            continue;
                        }
                        if (bl2) {
                            Thread.sleep(n * 1000);
                            continue;
                        }
                        Thread.sleep(n * 2000);
                    }
                    catch (InterruptedException interruptedException) {
                        n3 = 1;
                        try {
                            Thread.sleep(n4 * 1000);
                        }
                        catch (InterruptedException interruptedException2) {
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.PingThread.run", "1080", this);
                        }
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.PingThread.run", "1082", this);
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.PingThread.run", "1137", this);
            }
            finally {
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
            }
            object = RoutingTable.this.agentPingThreads;
            synchronized (object) {
                List list = (List)RoutingTable.this.agentPingThreads.get(this.name);
                if (list != null) {
                    list.remove(this);
                }
            }
            RoutingTable.this.decrMonitorThreads();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PingThread.run", this.name);
            }
        }

        public abstract void routeAdded(Accessor var1);

        public abstract void routeRemoved(Accessor var1);

        public abstract void startMonitor(Accessor var1);

        public void stopMonitor(Accessor accessor) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "PingThread.stopMonitor");
            }
            this.stopMonitor = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "PingThread.stopMonitor");
            }
        }
    }

    public class Accessor {
        String name;
        String pid;
        String defaultType;
        ServerInfo serverInfo;
        Map connectorCfgs = new HashMap();
        Session session;

        Accessor(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.setConnectors(serverInfo.getConnectors());
        }

        public Accessor(Session session) {
            this.session = session;
        }

        String getName() {
            return this.serverInfo.getName();
        }

        String getPid() {
            return this.serverInfo.getPid();
        }

        public String toString() {
            return this.serverInfo.toString();
        }

        void setServerInfo(ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
            this.setConnectors(serverInfo.getConnectors());
        }

        ServerInfo getServerInfo() {
            return this.serverInfo;
        }

        private void setConnectors(List list) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setConnectors");
            }
            String string = null;
            this.connectorCfgs.clear();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Properties properties = (Properties)iterator.next();
                string = properties.getProperty("type");
                if (properties.getProperty("preferred") != null) {
                    this.defaultType = string;
                }
                this.connectorCfgs.put(string, properties);
            }
            if (this.defaultType == null) {
                this.defaultType = string;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setConnectors");
            }
        }

        void clear() {
            this.connectorCfgs.clear();
        }

        boolean isRoutable() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isRoutable: " + !this.connectorCfgs.isEmpty());
            }
            return !this.connectorCfgs.isEmpty();
        }

        boolean isReachAble() {
            boolean bl;
            block2: {
                bl = false;
                try {
                    bl = this.getConnector().isAlive() != null;
                    bl = true;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block2;
                    Tr.debug(tc, "can not reach: ", this.getName());
                }
            }
            return bl;
        }

        AdminClient getConnector(String string) throws ConnectorException {
            AdminClient adminClient;
            block7: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getConnector(type)", string);
                }
                adminClient = null;
                Properties properties = (Properties)this.connectorCfgs.get(string);
                if (properties == null) {
                    throw new ConnectorNotAvailableException();
                }
                try {
                    adminClient = AdminClientFactory.createAdminClient(properties);
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.RoutingTable.Accessor.getConnector", "583", this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "unable to create connector with properties:", properties);
                }
            }
            if (adminClient == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnector(type) - failed");
                }
                throw new ConnectorNotAvailableException();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConnector(type)");
            }
            return adminClient;
        }

        AdminClient getConnector() throws ConnectorException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getConnector");
            }
            AdminClient adminClient = null;
            if (this.defaultType != null) {
                try {
                    adminClient = this.getConnector(this.defaultType);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.RoutingTable.Accessor.getConnector", "610", this);
                }
            }
            if (adminClient == null) {
                Iterator iterator = this.connectorCfgs.keySet().iterator();
                while (adminClient == null && iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (this.defaultType != null && this.defaultType.equals(string)) continue;
                    try {
                        adminClient = this.getConnector(string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.RoutingTable.Accessor.getConnector", "523", this);
                    }
                }
            }
            if (adminClient == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getConnector - failed");
                }
                throw new ConnectorNotAvailableException();
            }
            return adminClient;
        }

        Session resetSession() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resetSession");
            }
            try {
                AdminClient adminClient = this.getConnector();
                this.session = adminClient.isAlive();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.RoutingTable.getAllAdminClients", "492", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resetSession");
            }
            return this.session;
        }

        Session getSession() {
            return this.session;
        }
    }

    private class notifyParentAddedThread
    extends Thread {
        ServerInfo serverInfo;
        RoutingListener routingListener;

        notifyParentAddedThread(ServerInfo serverInfo, RoutingListener routingListener) {
            this.serverInfo = serverInfo;
            this.routingListener = routingListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "notifyParentAddedThread.run");
            }
            Subject subject = null;
            if (SecurityHelper.getHelper().isSecurityEnabled()) {
                subject = RoutingTable.this.pushServerSubject();
            }
            try {
                this.routingListener.parentAdded(this.serverInfo);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.RoutingTable.notifyParentAddedThread", "594", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error in thread notifying that parent was added", throwable);
                }
            }
            finally {
                if (SecurityHelper.getHelper().isSecurityEnabled()) {
                    SecurityHelper.pushInvocationSubject(subject);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "notifyParentAddedThread.run");
            }
        }
    }
}

