/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appcfg.AppcfgFactory;
import com.ibm.websphere.models.config.appcfg.EJBModuleConfiguration;
import com.ibm.websphere.models.config.appcfg.ModuleConfig;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentFactory;
import com.ibm.websphere.models.config.appdeployment.AppdeploymentPackage;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.ClusteredTarget;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.EJBModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.impl.AppdeploymentPackageImpl;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.HostFactory;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppManagementImpl;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.application.task.ConfigureTask;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class AppAssociation {
    private static TraceComponent tc = Tr.register(AppAssociation.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static AppdeploymentFactory appFactory = null;
    private static boolean isReg = false;
    AppManagementImpl appM;
    String workspaceID;
    Hashtable prefs;
    ResourceBundle resBundle;

    private static AppdeploymentFactory getAppFactory() {
        if (appFactory == null) {
            AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            appFactory = appdeploymentPackage.getAppdeploymentFactory();
        }
        return appFactory;
    }

    public AppAssociation(AppManagementImpl appManagementImpl, Hashtable hashtable, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppAssociation: , " + string);
        }
        this.appM = appManagementImpl;
        this.workspaceID = string;
        this.prefs = hashtable;
        this.resBundle = AppUtils.getBundle(this.prefs);
        if (!isReg) {
            ConfigInit.init();
            AppdeploymentPackage appdeploymentPackage = (AppdeploymentPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/appdeployment.xmi");
            AppdeploymentPackageImpl.init();
            isReg = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppAssociation");
        }
    }

    public static void handleCatch(Throwable throwable, String string, String string2, Object object) throws AdminException {
        FFDCFilter.processException(throwable, object.getClass().getName() + "." + string, string2, object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Exception thrown in " + string + ": " + throwable);
        }
        if (throwable instanceof AdminException) {
            throw (AdminException)throwable;
        }
        throw new AdminException(throwable, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppsFromNode(String string, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromNode: " + string + ", " + string2);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string2, null, null, workSpace, true);
            if (repositoryContext == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string2}));
            }
            RepositoryContext repositoryContext2 = AppUtils.findContext("nodes", string, null, repositoryContext, workSpace, false);
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5040E", new String[]{string}));
            }
            URI uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + repositoryContext2 + " SI doc res: " + resource);
            }
            if (resource != null) {
                ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                Vector<String> vector = new Vector<String>();
                EList eList = serverIndex.getServerEntries();
                for (int i = 0; i < eList.size(); ++i) {
                    vector.addElement(((ServerEntry)eList.get(i)).getServerName());
                }
                Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
                hashtable.put(string, vector);
                this.removeAppAssociation(string2, hashtable, new Vector(), workSpace);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error getting serverindex.xml");
            }
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "removeAllAppsFromNode", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeAllAppsFromNode");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeAllAppsFromNode");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromNode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAppsFromServer(ObjectName objectName) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromServer: " + objectName);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            String string = objectName.getKeyProperty("cell");
            String string2 = objectName.getKeyProperty("node");
            String string3 = objectName.getKeyProperty("server");
            Vector<String> vector = new Vector<String>();
            vector.addElement(string3);
            Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
            hashtable.put(string2, vector);
            this.removeAppAssociation(string, hashtable, new Vector(), workSpace);
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "removeAllAppsFromServer", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeAllAppsFromServer");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeAllAppsFromServer");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromServer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void removeAllAppsFromCluster(ObjectName var1_1) throws AdminException {
        if (AppAssociation.tc.isEntryEnabled()) {
            Tr.entry(AppAssociation.tc, "removeAllAppsFromCluster: " + var1_1);
        }
        var2_2 = null;
        var3_3 = false;
        try {
            var2_2 = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            var4_4 = var1_1.getKeyProperty("cell");
            var5_6 = var1_1.getKeyProperty("cluster");
            if (AppAssociation.tc.isDebugEnabled()) {
                Tr.debug(AppAssociation.tc, "cName " + var4_4);
                Tr.debug(AppAssociation.tc, "clName " + var5_6);
            }
            var6_7 = AppUtils.findContext("cells", var4_4, null, null, var2_2, true);
            if (AppAssociation.tc.isDebugEnabled()) {
                Tr.debug(AppAssociation.tc, "cellC " + var6_7);
            }
            if (var6_7 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{var4_4}));
            }
            var7_8 = new Vector<String>();
            var7_8.addElement(var5_6);
            var8_9 = new Hashtable<String, Vector<String>>();
            var9_10 = AppUtils.findContext("clusters", var5_6, var4_4, var6_7, var2_2, true);
            if (AppAssociation.tc.isDebugEnabled()) {
                Tr.debug(AppAssociation.tc, "clusterC " + var9_10);
            }
            if (var9_10 == null) {
                Tr.warning(AppAssociation.tc, AppUtils.getMessage(this.resBundle, "ADMA5051W", new Object[]{var5_6}));
            } else {
                var10_11 = URI.createURI((String)"cluster.xml");
                var11_12 = var9_10.getResourceSet().getResource(var10_11, true);
                var12_13 = (ServerCluster)var11_12.getContents().get(0);
                if (AppAssociation.tc.isDebugEnabled()) {
                    Tr.debug(AppAssociation.tc, "Cluster obj: " + var12_13);
                }
                if ((var13_14 = var12_13.getMembers()).isEmpty()) {
                    this.removeClusterDTFromDeployment(var6_7, var8_9, var7_8, var2_2);
                }
                for (var14_15 = 0; var14_15 < var13_14.size(); ++var14_15) {
                    var15_16 = (ClusterMember)var13_14.get(var14_15);
                    var16_17 = var15_16.getMemberName();
                    var17_18 = var15_16.getNodeName();
                    if (AppAssociation.tc.isDebugEnabled()) {
                        Tr.debug(AppAssociation.tc, "sName=" + var16_17 + ",nName=" + var17_18);
                    }
                    if ((var18_19 = (Vector<String>)var8_9.get(var17_18)) == null) {
                        var18_19 = new Vector<String>();
                        var8_9.put(var17_18, var18_19);
                    }
                    var18_19.addElement(var16_17);
                }
            }
            this.removeAppAssociation(var4_4, var8_9, var7_8, var2_2);
            EditApplication.doFinally(var2_2, this.workspaceID, null, var3_3 == false);
        }
        catch (Throwable var4_5) {
            try {
                var3_3 = true;
                AppAssociation.handleCatch(var4_5, "removeAllAppsFromCluster", "106", this);
                EditApplication.doFinally(var2_2, this.workspaceID, null, var3_3 == false);
            }
            catch (Throwable var19_20) {
                EditApplication.doFinally(var2_2, this.workspaceID, null, var3_3 == false);
                if (AppAssociation.tc.isEntryEnabled()) {
                    Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
                }
                throw var19_20;
            }
            if (AppAssociation.tc.isEntryEnabled()) {
                Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
            } else {
                ** GOTO lbl63
            }
        }
        if (AppAssociation.tc.isEntryEnabled()) {
            Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
        }
        if (AppAssociation.tc.isEntryEnabled()) {
            Tr.exit(AppAssociation.tc, "removeAllAppsFromCluster");
        }
    }

    private void removeClusterDTFromDeployment(RepositoryContext repositoryContext, Hashtable hashtable, Vector vector, WorkSpace workSpace) throws Exception {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeClusterDTFromDeployment");
        }
        if ((objectArray = AppUtils.getContextArray("deployments", repositoryContext, workSpace)) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl;
                RepositoryContext repositoryContext2 = (RepositoryContext)objectArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "rc=" + repositoryContext2);
                    Tr.debug(tc, "appname: " + repositoryContext2.getName());
                }
                Resource resource = ConfigRepoHelper.getAppDeploymentResource(repositoryContext2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "res " + resource.getURI());
                }
                Deployment deployment = (Deployment)resource.getContents().get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deployment " + deployment.toString());
                }
                if (!(bl = this.removeAppTargets(deployment, hashtable, vector))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "saving deployment.xml ");
                }
                resource.save(new HashMap(0));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeClusterDTFromDeployment");
        }
    }

    private void removeAppAssociation(String string, Hashtable hashtable, Vector vector, WorkSpace workSpace) throws Exception {
        URI uRI;
        RepositoryContext repositoryContext;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAppAssociation: node2svr=" + hashtable + ",cellName=" + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "clusters: " + vector);
        }
        RepositoryContext repositoryContext2 = AppUtils.findContext("cells", string, null, null, workSpace, true);
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Enumeration enumeration = hashtable.keys();
        HashMap hashMap = new HashMap();
        while (enumeration.hasMoreElements()) {
            EList eList;
            ServerEntry serverEntry;
            String string2 = (String)enumeration.nextElement();
            object = (Vector)hashtable.get(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nName " + string2);
                Tr.debug(tc, "svrs " + object);
            }
            if ((repositoryContext = AppUtils.findContext("nodes", string2, null, repositoryContext2, workSpace, false)) == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, string2 + " not found.");
                continue;
            }
            uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + repositoryContext + " SI doc res: " + resource);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            EList eList2 = serverIndex.getServerEntries();
            for (int i = 0; i < eList2.size(); ++i) {
                serverEntry = (ServerEntry)eList2.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerEntry " + serverEntry.getServerName());
                }
                if (!((Vector)object).contains(serverEntry.getServerName())) continue;
                eList = serverEntry.getDeployedApplications();
                while (eList.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app " + eList.get(0));
                    }
                    if (!vector2.contains(eList.get(0))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add to depls");
                        }
                        vector2.add(eList.get(0));
                    }
                    eList.remove(0);
                }
            }
            resource.save(new HashMap(0));
            URI uRI2 = URI.createURI((String)"systemapps.xml");
            serverEntry = repositoryContext.getResourceSet().getResource(uRI2, true);
            if (serverEntry == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "systemapps.xml not found.");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + repositoryContext + " systemapp SI doc res: " + serverEntry);
            }
            eList = (ServerIndex)serverEntry.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerIndex: " + eList);
            }
            EList eList3 = eList.getServerEntries();
            for (int i = 0; i < eList3.size(); ++i) {
                ServerEntry serverEntry2 = (ServerEntry)eList3.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ServerEntry: " + serverEntry2.getServerName());
                }
                if (!((Vector)object).contains(serverEntry2.getServerName())) continue;
                EList eList4 = serverEntry2.getDeployedApplications();
                while (eList4.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "app " + eList4.get(0));
                    }
                    if (!vector3.contains(eList4.get(0))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add to deplsSysApps");
                        }
                        vector3.add(eList4.get(0));
                    }
                    eList4.remove(0);
                }
                eList3.remove(serverEntry2);
            }
            serverEntry.save(new HashMap(0));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "depls: " + vector2);
            Tr.debug(tc, "deplsSysApp: " + vector3);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            object = ConfigRepoHelper.getAppContextFromSIEntry((String)vector2.elementAt(i), repositoryContext2, workSpace);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rc " + object);
            }
            if (object == null) {
                Tr.warning(tc, "ADMA5041E", new Object[]{vector2.get(i), ""});
                continue;
            }
            repositoryContext = ConfigRepoHelper.getAppDeploymentResource((RepositoryContext)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res " + repositoryContext.getURI());
            }
            uRI = (Deployment)repositoryContext.getContents().get(0);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deployment " + uRI.toString());
            }
            this.removeAppTargets((Deployment)uRI, hashtable, vector);
            repositoryContext.save(new HashMap(0));
        }
    }

    private boolean removeAppTargets(Deployment deployment, Hashtable hashtable, Vector vector) throws Exception {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAppTargets");
        }
        EList eList = deployment.getDeploymentTargets();
        ArrayList<DeploymentTarget> arrayList = new ArrayList<DeploymentTarget>();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dt: " + deploymentTarget.getName());
            }
            if (deploymentTarget instanceof ClusteredTarget) {
                if (!vector.contains(deploymentTarget.getName())) continue;
                arrayList.add(deploymentTarget);
                continue;
            }
            Vector vector2 = (Vector)hashtable.get(((ServerTarget)deploymentTarget).getNodeName());
            if (vector2 == null || !vector2.contains(deploymentTarget.getName())) continue;
            arrayList.add(deploymentTarget);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeDT: " + arrayList);
        }
        this.removeDTFromDeployment(deployment.getDeployedObject(), arrayList);
        EList eList2 = ((ApplicationDeployment)deployment.getDeployedObject()).getModules();
        for (n = 0; n < eList2.size(); n += 1) {
            this.removeDTFromDeployment((DeployedObject)eList2.get(n), arrayList);
        }
        for (n = 0; n < arrayList.size(); n += 1) {
            deployment.getDeploymentTargets().remove(arrayList.get(n));
        }
        int n2 = n = !arrayList.isEmpty() ? 1 : 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAppTargets", "docModified: " + (n != 0));
        }
        return n != 0;
    }

    private void removeDTFromDeployment(DeployedObject deployedObject, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDTFromDeployment");
        }
        for (int i = 0; i < deployedObject.getTargetMappings().size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)deployedObject.getTargetMappings().get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dtm: " + deploymentTargetMapping.getTarget().getName());
            }
            if (!list.contains(deploymentTargetMapping.getTarget())) continue;
            deployedObject.getTargetMappings().remove((Object)deploymentTargetMapping);
            --i;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDTFromDeployment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeServerToCluster(ObjectName objectName, ObjectName objectName2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerToCluster: " + objectName + " -to-> " + objectName2);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            RepositoryContext repositoryContext;
            RepositoryContext repositoryContext2;
            int n;
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            String string = objectName.getKeyProperty("cell");
            String string2 = objectName.getKeyProperty("node");
            String string3 = objectName.getKeyProperty("server");
            String string4 = objectName2.getKeyProperty("cluster");
            RepositoryContext repositoryContext3 = AppUtils.findContext("cells", string, null, null, workSpace, true);
            if (repositoryContext3 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string}));
            }
            RepositoryContext repositoryContext4 = AppUtils.findContext("nodes", string2, string, repositoryContext3, workSpace, true);
            if (repositoryContext4 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{objectName}));
            }
            URI uRI = URI.createURI((String)"serverindex.xml");
            Resource resource = repositoryContext4.getResourceSet().getResource(uRI, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found for node " + repositoryContext4 + " SI doc res: " + resource);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            Vector<RepositoryContext> vector = new Vector<RepositoryContext>();
            EList eList = serverIndex.getServerEntries();
            for (n = 0; n < eList.size(); ++n) {
                if (!((ServerEntry)eList.get(n)).getServerName().equals(string3)) continue;
                repositoryContext2 = ((ServerEntry)eList.get(n)).getDeployedApplications();
                for (int i = 0; i < repositoryContext2.size(); ++i) {
                    try {
                        repositoryContext = ConfigRepoHelper.getAppContextFromSIEntry((String)repositoryContext2.get(i), repositoryContext3, workSpace);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "rc: " + repositoryContext);
                        }
                        vector.addElement(repositoryContext);
                        continue;
                    }
                    catch (Exception exception) {
                        Tr.warning(tc, AppUtils.getMessage(this.resBundle, "ADMA5053W", new Object[]{exception, repositoryContext2.get(i)}));
                    }
                }
                break;
            }
            for (n = 0; n < vector.size(); ++n) {
                repositoryContext2 = (RepositoryContext)vector.elementAt(n);
                try {
                    resource = ConfigRepoHelper.getAppDeploymentResource(repositoryContext2);
                    Deployment deployment = (Deployment)resource.getContents().get(0);
                    repositoryContext = null;
                    EList eList2 = deployment.getDeploymentTargets();
                    for (int i = 0; i < eList2.size(); ++i) {
                        ServerTarget serverTarget;
                        if (!(eList2.get(i) instanceof ServerTarget) || !(serverTarget = (ServerTarget)eList2.get(i)).getName().equals(string3) || !serverTarget.getNodeName().equals(string2)) continue;
                        repositoryContext = serverTarget;
                        break;
                    }
                    if (repositoryContext == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "ServerTarget not found for " + string3 + "-" + string2 + " in " + deployment);
                        continue;
                    }
                    ClusteredTarget clusteredTarget = AppAssociation.getAppFactory().createClusteredTarget();
                    clusteredTarget.setName(string4);
                    this.replaceTarget((DeploymentTarget)repositoryContext, (DeploymentTarget)clusteredTarget, deployment);
                    resource.save(new HashMap(0));
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.warning(tc, AppUtils.getMessage(this.resBundle, "ADMA5054W", new Object[]{throwable, repositoryContext2.getName(), string3, string4}));
                }
            }
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "changeServerToCluster", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "changeServerToCluster");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "changeServerToCluster");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerToCluster");
        }
    }

    private void replaceTarget(DeploymentTarget deploymentTarget, DeploymentTarget deploymentTarget2, Deployment deployment) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceTarget: " + deploymentTarget);
        }
        deployment.getDeploymentTargets().add((Object)deploymentTarget2);
        this.replaceTarget(deploymentTarget, deploymentTarget2, deployment.getDeployedObject());
        EList eList = ((ApplicationDeployment)deployment.getDeployedObject()).getModules();
        for (int i = 0; i < eList.size(); ++i) {
            this.replaceTarget(deploymentTarget, deploymentTarget2, (DeployedObject)eList.get(i));
        }
        deployment.getDeploymentTargets().remove((Object)deploymentTarget);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceTarget");
        }
    }

    private void replaceTarget(DeploymentTarget deploymentTarget, DeploymentTarget deploymentTarget2, DeployedObject deployedObject) throws Exception {
        EList eList = deployedObject.getTargetMappings();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)eList.get(i);
            if (!deploymentTargetMapping.getTarget().equals(deploymentTarget)) continue;
            deploymentTargetMapping.setTarget(deploymentTarget2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clusterMemberAdded(ObjectName objectName, ObjectName objectName2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clusterMemberAdded: " + objectName + " to " + objectName2);
        }
        WorkSpace workSpace = null;
        boolean bl = false;
        try {
            Object object;
            ServerEntry serverEntry;
            Object object2;
            EList eList;
            Deployment deployment;
            RepositoryContext repositoryContext;
            ClusterMember clusterMember;
            workSpace = ConfigRepoHelper.getWorkSpace(this.workspaceID);
            String string = objectName.getKeyProperty("cell");
            String string2 = objectName.getKeyProperty("node");
            String string3 = objectName.getKeyProperty("server");
            String string4 = objectName2.getKeyProperty("cluster");
            RepositoryContext repositoryContext2 = AppUtils.findContext("cells", string, null, null, workSpace, true);
            if (repositoryContext2 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5047E", new Object[]{string}));
            }
            RepositoryContext repositoryContext3 = AppUtils.findContext("clusters", string4, string, repositoryContext2, workSpace, true);
            if (repositoryContext3 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5055E", new Object[]{string4, string3}));
            }
            RepositoryContext repositoryContext4 = AppUtils.findContext("nodes", string2, string, repositoryContext2, workSpace, true);
            if (repositoryContext4 == null) {
                throw new AdminException(AppUtils.getMessage(this.resBundle, "ADMA5052E", new Object[]{string2}));
            }
            URI uRI = URI.createURI((String)"cluster.xml");
            Resource resource = repositoryContext3.getResourceSet().getResource(uRI, true);
            ServerCluster serverCluster = (ServerCluster)resource.getContents().get(0);
            EList eList2 = serverCluster.getMembers();
            EList eList3 = null;
            EList eList4 = null;
            Resource resource2 = null;
            URI uRI2 = null;
            ServerEntry serverEntry2 = null;
            RepositoryContext repositoryContext5 = null;
            String string5 = null;
            Deployment deployment2 = null;
            if (eList2.size() > 1) {
                block11: for (int i = 0; i < eList2.size(); ++i) {
                    clusterMember = (ClusterMember)eList2.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Member: " + clusterMember.getMemberName() + " - " + clusterMember.getNodeName() + " sName: " + string3 + " nName: " + string2);
                    }
                    if (clusterMember.getMemberName().equals(string3) && clusterMember.getNodeName().equals(string2)) continue;
                    repositoryContext = AppUtils.findContext("nodes", clusterMember.getNodeName(), string, repositoryContext2, workSpace, true);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node context: " + repositoryContext);
                    }
                    if (repositoryContext == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Invalid member: " + clusterMember.getMemberName());
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Member: " + clusterMember.getMemberName() + " - " + clusterMember.getNodeName());
                    }
                    uRI = URI.createURI((String)"serverindex.xml");
                    deployment = repositoryContext.getResourceSet().getResource(uRI, true);
                    eList = (ServerIndex)deployment.getContents().get(0);
                    object2 = eList.getServerEntries();
                    for (int j = 0; j < object2.size(); ++j) {
                        serverEntry = (ServerEntry)object2.get(j);
                        if (!serverEntry.getServerName().equals(clusterMember.getMemberName())) continue;
                        eList3 = serverEntry.getDeployedApplications();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "add: " + eList3);
                        }
                        serverEntry2 = serverEntry;
                        string5 = clusterMember.getMemberName();
                        repositoryContext5 = repositoryContext;
                        break;
                    }
                    uRI2 = URI.createURI((String)"systemapps.xml");
                    Resource resource3 = repositoryContext.getResourceSet().getResource(uRI2, true);
                    if (resource3 == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "systemapps.xml not found.");
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found for node " + repositoryContext + " systemapp SI doc res: " + resource3);
                    }
                    serverEntry = (ServerIndex)resource3.getContents().get(0);
                    object = serverEntry.getServerEntries();
                    for (int j = 0; j < object.size(); ++j) {
                        ServerEntry serverEntry3 = (ServerEntry)object.get(j);
                        if (!serverEntry3.getServerName().equals(clusterMember.getMemberName())) continue;
                        eList4 = serverEntry3.getDeployedApplications();
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "addSysApp: " + eList4);
                        break block11;
                    }
                    break;
                }
            }
            if (eList3 == null) {
                eList3 = new ArrayList();
                Object[] objectArray = AppUtils.getContextArray("deployments", repositoryContext2, workSpace);
                block14: for (int i = 0; i < objectArray.length; ++i) {
                    repositoryContext = (RepositoryContext)objectArray[i];
                    resource = ConfigRepoHelper.getAppDeploymentResource(repositoryContext);
                    deployment = (Deployment)resource.getContents().get(0);
                    eList = deployment.getDeploymentTargets();
                    for (int j = 0; j < eList.size(); ++j) {
                        if (!(eList.get(j) instanceof ClusteredTarget) || !((ClusteredTarget)eList.get(j)).getName().equals(string4)) continue;
                        eList3.add(ConfigRepoHelper.getSIEntryText(repositoryContext));
                        continue block14;
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add is: " + eList3);
            }
            uRI = URI.createURI((String)"serverindex.xml");
            resource = repositoryContext4.getResourceSet().getResource(uRI, true);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            clusterMember = serverIndex.getServerEntries();
            for (int i = 0; i < clusterMember.size(); ++i) {
                deployment = (ServerEntry)clusterMember.get(i);
                if (!deployment.getServerName().equals(string3)) continue;
                deployment2 = deployment;
                for (int j = 0; j < eList3.size(); ++j) {
                    if (deployment.getDeployedApplications().contains(eList3.get(j))) continue;
                    deployment.getDeployedApplications().add(eList3.get(j));
                }
                break;
            }
            resource.save(new HashMap(0));
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("cell.name", string);
            hashtable.put("node.name", string2);
            ConfigRepoHelper.getReferenceToSystemAppsXML(workSpace, hashtable);
            uRI2 = URI.createURI((String)"systemapps.xml");
            resource2 = repositoryContext4.getResourceSet().getResource(uRI2, true);
            deployment = (ServerIndex)resource2.getContents().get(0);
            eList = deployment.getServerEntries();
            object2 = ConfigRepoHelper.getServerNameForServerEntries((List)eList);
            if (!object2.contains(string3)) {
                ConfigRepoHelper.createServerEntry((ServerIndex)deployment, string3);
            }
            eList = deployment.getServerEntries();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serversEntries for " + repositoryContext4.getName() + " are " + eList);
            }
            if (eList4 != null) {
                for (int i = 0; i < eList.size(); ++i) {
                    serverEntry = (ServerEntry)eList.get(i);
                    if (!serverEntry.getServerName().equals(string3)) continue;
                    for (int j = 0; j < eList4.size(); ++j) {
                        if (serverEntry.getDeployedApplications().contains(eList4.get(j))) continue;
                        serverEntry.getDeployedApplications().add(eList4.get(j));
                    }
                    break;
                }
                resource2.save(new HashMap(0));
            }
            uRI = URI.createURI((String)"deployment.xml");
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < eList3.size(); ++i) {
                try {
                    object = ConfigRepoHelper.getAppContextFromSIEntry((String)eList3.get(i), repositoryContext2, workSpace);
                    resource = object.getResourceSet().getResource(uRI, true);
                    resource.save(new HashMap(0));
                    arrayList.add(object);
                    continue;
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception: " + throwable + " in touching deployment.xml " + " in " + eList3.get(i));
                    }
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppAssociation.clusterMemberAdded", "751", this);
                    arrayList = new ArrayList();
                }
            }
            EARFile eARFile = null;
            boolean bl2 = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "appCs = " + arrayList);
            }
            try {
                String string6;
                WebAppBinding webAppBinding;
                int n;
                List list;
                ArrayList<String> arrayList2;
                ArrayList<String> arrayList3 = new ArrayList<String>();
                block21: for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList2 = (RepositoryContext)arrayList.get(i);
                    eARFile = ConfigRepoHelper.getEarFileFromDeployment(workSpace, (RepositoryContext)((Object)arrayList2));
                    list = eARFile.getWebModuleRefs();
                    for (n = 0; n < list.size(); ++n) {
                        webAppBinding = (WebAppBinding)((ModuleRef)list.get(n)).getBindings();
                        if (webAppBinding == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "null binding for " + arrayList2 + " - " + ((ModuleRef)list.get(n)).getUri());
                            continue;
                        }
                        string6 = webAppBinding.getVirtualHostName();
                        if (string6 == null) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "vhost = " + string6);
                        }
                        if (!arrayList3.contains(string6)) {
                            arrayList3.add(string6);
                        }
                        if (arrayList3.size() > 1) continue block21;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "vh = " + arrayList3);
                }
                WebAppBinding webAppBinding2 = null;
                if (arrayList3.size() == 1) {
                    arrayList2 = (String)arrayList3.get(0);
                    uRI = URI.createURI((String)"virtualhosts.xml");
                    resource = repositoryContext2.getResourceSet().getResource(uRI, true);
                    list = resource.getContents();
                    block23: for (n = 0; n < list.size(); ++n) {
                        webAppBinding = (VirtualHost)list.get(n);
                        if (!((String)((Object)arrayList2)).equals(webAppBinding.getName())) continue;
                        bl2 = true;
                        webAppBinding2 = webAppBinding;
                        string6 = webAppBinding2.getAliases();
                        for (int i = 0; i < string6.size(); ++i) {
                            HostAlias hostAlias = (HostAlias)string6.get(i);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "alias: " + hostAlias.getHostname());
                            }
                            if ("*".equals(hostAlias.getHostname())) continue;
                            bl2 = false;
                            continue block23;
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "shouldProceed: " + bl2 + ", " + webAppBinding2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string5 + ", " + repositoryContext5 + ", " + serverEntry2);
                }
                arrayList2 = new ArrayList<String>();
                if (bl2 && string5 != null && repositoryContext5 != null && serverEntry2 != null) {
                    list = webAppBinding2.getAliases();
                    for (n = 0; n < list.size(); ++n) {
                        arrayList2.add(((HostAlias)list.get(n)).getPort());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "current ports: " + arrayList2);
                    }
                    List list2 = AppAssociation.getEndPorts(string5, repositoryContext5, serverEntry2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endPorts for other: " + list2);
                    }
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        list2.remove(arrayList2.get(i));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endPorts for other after remove: " + list2);
                    }
                    if (list2.size() != 0) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    list = AppAssociation.getEndPorts(string3, repositoryContext4, (ServerEntry)deployment2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "endPorts to add: " + list);
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        if (arrayList2.contains(list.get(i))) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "port already defined, skipping -" + list.get(i));
                            continue;
                        }
                        HostAlias hostAlias = HostFactory.eINSTANCE.createHostAlias();
                        hostAlias.setHostname("*");
                        hostAlias.setPort((String)list.get(i));
                        webAppBinding2.getAliases().add((Object)hostAlias);
                    }
                    webAppBinding2.eResource().save(new HashMap());
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception in updating server with http ports: " + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppAssociation.clusterMemberAdded", "763", this);
            }
            finally {
                if (eARFile != null) {
                    eARFile.close();
                }
            }
            EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
        }
        catch (Throwable throwable) {
            try {
                bl = true;
                AppAssociation.handleCatch(throwable, "clusterMemberAdded", "106", this);
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
            }
            catch (Throwable throwable2) {
                EditApplication.doFinally(workSpace, this.workspaceID, null, !bl);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "clusterMemberAdded");
                }
                throw throwable2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "clusterMemberAdded");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clusterMemberAdded");
        }
    }

    public static List getEndPorts(String string, RepositoryContext repositoryContext, ServerEntry serverEntry) throws Exception {
        EList eList;
        EList eList2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEndPorts: " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        RepositoryContext repositoryContext2 = repositoryContext.getChild(AppUtils.getContextType("servers"), string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "contexts: node=" + repositoryContext + ", server=" + repositoryContext2);
        }
        URI uRI = URI.createURI((String)"server.xml");
        Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resource: " + resource);
        }
        Server server2 = (Server)resource.getContents().get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found server: " + server2);
        }
        EList eList3 = server2.getComponents();
        for (int i = 0; i < eList3.size(); ++i) {
            if (!(eList3.get(i) instanceof ApplicationServer)) continue;
            ApplicationServer applicationServer = (ApplicationServer)eList3.get(i);
            eList2 = applicationServer.getComponents();
            for (int j = 0; j < eList2.size(); ++j) {
                if (!(eList2.get(j) instanceof WebContainer)) continue;
                WebContainer webContainer = (WebContainer)eList2.get(j);
                eList = webContainer.getTransports();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "transports: " + eList);
                }
                for (int k = 0; k < eList.size(); ++k) {
                    Transport transport2 = (Transport)eList.get(k);
                    if (transport2.getAddress() == null || arrayList.contains("" + transport2.getAddress().getPort())) continue;
                    arrayList.add("" + transport2.getAddress().getPort());
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "After adding ports from webcontainer: " + arrayList);
            }
        }
        EList eList4 = server2.getServices();
        for (int i = 0; i < eList4.size(); ++i) {
            if (!(eList4.get(i) instanceof TransportChannelService)) continue;
            eList2 = (TransportChannelService)eList4.get(i);
            EList eList5 = eList2.getChains();
            for (int j = 0; j < eList5.size(); ++j) {
                int n;
                eList = (Chain)eList5.get(j);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "chain: " + eList);
                }
                EList eList6 = eList.getTransportChannels();
                boolean bl = false;
                for (n = 0; n < eList6.size(); ++n) {
                    if (!(eList6.get(n) instanceof WebContainerInboundChannel)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No WCInbound for this chain");
                    continue;
                }
                for (n = 0; n < eList6.size(); ++n) {
                    if (!(eList6.get(n) instanceof TCPInboundChannel)) continue;
                    TCPInboundChannel tCPInboundChannel = (TCPInboundChannel)eList6.get(n);
                    String string2 = tCPInboundChannel.getEndPointName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ep name: " + string2);
                    }
                    String string3 = AppAssociation.getPortForEP(serverEntry, string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "port: " + string3);
                    }
                    if (string3 == null || arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndPorts: " + arrayList);
        }
        return arrayList;
    }

    private static String getPortForEP(ServerEntry serverEntry, String string) {
        EList eList = serverEntry.getSpecialEndpoints();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "looking for ep port for: " + string);
        }
        for (int i = 0; i < eList.size(); ++i) {
            NamedEndPoint namedEndPoint;
            if (!(eList.get(i) instanceof NamedEndPoint) || !string.equals((namedEndPoint = (NamedEndPoint)eList.get(i)).getEndPointName())) continue;
            return "" + namedEndPoint.getEndPoint().getPort();
        }
        return null;
    }

    public static void populateDeployTargets(Deployment deployment, ModuleDeployment moduleDeployment, String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace, AppcfgFactory appcfgFactory, AppdeploymentFactory appdeploymentFactory) throws Exception {
        ConfigureTask.populateDeployTargets(deployment, moduleDeployment, string, string2, repositoryContext, workSpace, appcfgFactory, appdeploymentFactory);
    }

    public static Vector getServerNames(String string, String string2, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        return ConfigRepoHelper.getServerNames(string, string2, true, repositoryContext, workSpace);
    }

    public static Vector getServerNames(String string, String string2, boolean bl, RepositoryContext repositoryContext, WorkSpace workSpace) throws Exception {
        return ConfigRepoHelper.getServerNames(string, string2, bl, repositoryContext, workSpace);
    }

    private static int existsInNewConfig(DeploymentTargetMapping deploymentTargetMapping, Vector vector) {
        for (int i = 0; i < vector.size(); i += 2) {
            RepositoryContext repositoryContext = (RepositoryContext)vector.elementAt(i);
            String string = (String)vector.elementAt(i + 1);
            String string2 = null;
            ModuleConfig moduleConfig = (ModuleConfig)deploymentTargetMapping.getConfig();
            if (moduleConfig != null) {
                string2 = moduleConfig.getName();
            }
            if ((!AppUtils.isEmpty(string) || !AppUtils.isEmpty(string2)) && !string.equals(string2) || !repositoryContext.getName().equals(deploymentTargetMapping.getTarget().getName())) continue;
            if (deploymentTargetMapping.getTarget() instanceof ClusteredTarget && AppUtils.isCluster(repositoryContext)) {
                return i;
            }
            if (!(deploymentTargetMapping.getTarget() instanceof ServerTarget) || !AppUtils.isServer(repositoryContext) || !repositoryContext.getParent().getName().equals(((ServerTarget)deploymentTargetMapping.getTarget()).getNodeName())) continue;
            return i;
        }
        return -1;
    }

    private static ModuleConfig getOrCreateConfig(ModuleDeployment moduleDeployment, String string, AppcfgFactory appcfgFactory) throws Exception {
        EList eList = moduleDeployment.getConfigs();
        for (int i = 0; i < eList.size(); ++i) {
            ModuleConfig moduleConfig = (ModuleConfig)eList.get(i);
            if (!moduleConfig.getName().equals(string)) continue;
            return moduleConfig;
        }
        if (AppUtils.isEmpty(string)) {
            return null;
        }
        if (moduleDeployment instanceof EJBModuleDeployment) {
            EJBModuleConfiguration eJBModuleConfiguration = appcfgFactory.createEJBModuleConfiguration();
            eJBModuleConfiguration.setName(string);
            eList.add((Object)eJBModuleConfiguration);
            return eJBModuleConfiguration;
        }
        if (moduleDeployment instanceof WebModuleDeployment) {
            WebModuleConfig webModuleConfig = appcfgFactory.createWebModuleConfig();
            webModuleConfig.setName(string);
            eList.add((Object)webModuleConfig);
            return webModuleConfig;
        }
        return null;
    }

    private static DeploymentTarget getOrCreateTarget(Deployment deployment, RepositoryContext repositoryContext, AppdeploymentFactory appdeploymentFactory) throws Exception {
        EList eList = deployment.getDeploymentTargets();
        for (int i = 0; i < eList.size(); ++i) {
            DeploymentTarget deploymentTarget = (DeploymentTarget)eList.get(i);
            if (deploymentTarget instanceof ClusteredTarget && AppUtils.isCluster(repositoryContext) && deploymentTarget.getName().equals(repositoryContext.getName())) {
                return deploymentTarget;
            }
            if (!(deploymentTarget instanceof ServerTarget) || !AppUtils.isServer(repositoryContext) || !deploymentTarget.getName().equals(repositoryContext.getName()) || !repositoryContext.getParent().getName().equals(((ServerTarget)deploymentTarget).getNodeName())) continue;
            return deploymentTarget;
        }
        Object object = null;
        object = AppUtils.isCluster(repositoryContext) ? appdeploymentFactory.createClusteredTarget() : appdeploymentFactory.createServerTarget();
        object.setName(repositoryContext.getName());
        if (object instanceof ServerTarget) {
            ((ServerTarget)object).setNodeName(repositoryContext.getParent().getName());
        }
        deployment.getDeploymentTargets().add(object);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Created target: " + object);
        }
        return object;
    }
}

