/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.application;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.DistributionStatusSchedulerImpl;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.InstallSchedulerImpl;
import com.ibm.ws.management.application.RedeploymentManager;
import com.ibm.ws.management.application.ResourceLookup;
import com.ibm.ws.management.application.UninstallSchedulerImpl;
import com.ibm.ws.management.application.UpdateClusterScheduler;
import com.ibm.ws.management.application.UpdateSchedulerImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.policy.ApplicationPolicyParser;
import com.ibm.ws.security.policy.FilterPolicyParser;
import com.ibm.ws.security.policy.PolicyTemplate;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class AppManagementImpl
extends RuntimeCollaborator
implements AppManagement {
    public static final String TEMP_EXTRACT_DIR = "Temp extraction dir for multiserver";
    public static final String CONFIG_ROOT = "Config Root for variable map";
    private static TraceComponent tc = Tr.register(AppManagementImpl.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String PROPERTIES_PATH = "version.properties";
    private static final String VERSION_KEY = "app.management.roam.key";
    private static final String VERSION_VALUE = "3828436921961863062";
    private Hashtable _props;
    private static ObjectName objectName;
    private static long seqNum;
    private boolean readOnly = false;
    private String readOnlyPath = null;
    private long readOnlyTimeStamp;
    static final String RES_SCOPE = "scope";
    static final String RES_TYPE = "type";
    static final String RES_VALUE = "value";
    static final String RES_INDEX = "index";
    static /* synthetic */ Class class$java$lang$String;

    public static AppManagement createLocalImpl() {
        return AppManagementFactory.createLocalAppManagementImpl();
    }

    public static AppManagement createLocalImpl(String string) {
        return AppManagementFactory.createLocalAppManagementImpl(string);
    }

    public AppManagementImpl(Hashtable hashtable) {
        this._props = hashtable;
    }

    public Hashtable getGlobalSettings() {
        return this._props;
    }

    public void setObjectName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setObjectName: " + objectName);
        }
        super.setObjectName(objectName);
        AppManagementImpl.objectName = objectName;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setObjectName");
        }
    }

    public static boolean isLocalMode() {
        return objectName == null;
    }

    public void sendJMXEvent(Object object) {
        this.sendJMXEvent("websphere.admin.appmgmt", object);
    }

    public void sendJMXEvent(String string, Object object) {
        block5: {
            if (AppManagementImpl.isLocalMode()) {
                return;
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "sendJMXEvent");
            }
            try {
                Notification notification = new Notification("websphere.admin.appmgmt", objectName, ++seqNum);
                notification.setUserData(object);
                this.sendNotification(notification);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.sendJMXEvent", "163", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception from sending JMX event: " + throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendJMXEvent");
        }
    }

    public boolean checkIfAppExists(String string, Hashtable hashtable, String string2) throws AdminException {
        Tr.entry(tc, "checkIfAppExists: " + string);
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        final String string3 = string;
        final Hashtable hashtable2 = hashtable;
        final String string4 = string2;
        Object object = null;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            object = ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.checkIfAppExistsAsSystem(string3, hashtable2, string4);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0178E", new Object[]{string}));
        }
        catch (Exception exception) {
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0179E", new Object[]{string, exception}));
        }
        boolean bl = object != null;
        Tr.entry(tc, "checkIfAppExists: " + bl);
        return bl;
    }

    private Object checkIfAppExistsAsSystem(String string, Hashtable hashtable, String string2) throws AdminException {
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        Object object = editApplication.checkIfAppExists();
        return object;
    }

    public void installApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        this.installApplication(string, null, hashtable, string2);
    }

    public void installApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        this._installApplication(string, string2, hashtable, null, true, string3);
    }

    public void installApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener) throws AdminException {
        this._installApplication(string, string2, hashtable, listener, false, null);
    }

    public void installApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, String string3) throws AdminException {
        this._installApplication(string, string2, hashtable, listener, false, string3);
    }

    private void _installApplication(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, boolean bl, String string3) throws AdminException {
        Cloneable cloneable;
        String string4;
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (!this.isFullUpdate(hashtable)) {
            string4 = AppManagementImpl.getCellName();
            boolean bl2 = AppUtils.checkCellLevelAdminAccess(string4);
            cloneable = new Vector();
            if (!bl2 && !(bl2 = AppUtils.checkAdminAccessTarget(hashtable, "deployer", string4, string3, (Vector)cloneable))) {
                String string5 = null;
                if (cloneable != null && ((Vector)cloneable).size() > 0) {
                    string5 = (String)((Vector)cloneable).get(0);
                }
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0187E", new Object[]{string5}));
            }
        }
        string4 = string;
        final String string6 = string2;
        cloneable = hashtable;
        AppNotification.Listener listener2 = listener;
        String string7 = string3;
        boolean bl3 = bl;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction((Hashtable)cloneable, listener2, bl3, string7){
                private final /* synthetic */ Hashtable val$propertiesFinal;
                private final /* synthetic */ AppNotification.Listener val$notfFinal;
                private final /* synthetic */ boolean val$isJMXFinal;
                private final /* synthetic */ String val$workspaceIDFinal;
                {
                    this.val$propertiesFinal = hashtable;
                    this.val$notfFinal = listener;
                    this.val$isJMXFinal = bl;
                    this.val$workspaceIDFinal = string3;
                }

                public Object run() throws Exception {
                    AppManagementImpl.this._installApplicationAsSystem(string4, string6, this.val$propertiesFinal, this.val$notfFinal, this.val$isJMXFinal, this.val$workspaceIDFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0176E", new Object[]{string2, string}));
        }
        catch (Exception exception) {
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0177E", new Object[]{string2, string, exception}));
        }
    }

    private void _installApplicationAsSystem(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, boolean bl, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_installApplicationAsSystem " + string + ", " + string2);
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"installApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0041E"));
        }
        if (hashtable == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0042E"));
        }
        if (!new File(string).exists() && !AppUtils.isSystemAppOption(hashtable)) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0043E", new Object[]{string}));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create new installscheduler");
        }
        InstallSchedulerImpl installSchedulerImpl = new InstallSchedulerImpl(string, string2, hashtable, this, listener);
        try {
            installSchedulerImpl.setWorkSpaceID(string3);
            Thread thread = new Thread(installSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl._installApplication", "264", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_installAppliction");
            }
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0044E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_installAppliction");
        }
    }

    public void uninstallApplicationLocal(String string, Hashtable hashtable, AppNotification.Listener listener) throws AdminException {
        this._uninstallApplication(string, hashtable, listener, false, null);
    }

    public void uninstallApplicationLocal(String string, Hashtable hashtable, AppNotification.Listener listener, String string2) throws AdminException {
        this._uninstallApplication(string, hashtable, listener, false, string2);
    }

    public void uninstallApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        this._uninstallApplication(string, hashtable, null, true, string2);
    }

    public void _uninstallApplication(String string, Hashtable hashtable, AppNotification.Listener listener, boolean bl, String string2) throws AdminException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_uninstallApplication " + string);
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"uninstallApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0045E"));
        }
        if (!bl && hashtable == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0046E"));
        }
        final String string3 = string;
        final Hashtable hashtable2 = hashtable;
        final String string4 = string2;
        String string5 = AppManagementImpl.getCellName();
        Vector vector = new Vector();
        boolean bl2 = AppUtils.checkCellLevelAdminAccess(string5);
        if (!bl2) {
            bl2 = AppUtils.checkAdminAccessApp(hashtable, "deployer", string);
        }
        if (!bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "check the target ");
            }
            try {
                object = ContextManagerFactory.getInstance().getServerSubject();
                ContextManagerFactory.getInstance().runAsSpecified((Subject)object, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        AppUtils.loadDeploymentsToWorkSpacorkSpace(string3, hashtable2, string4);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
            }
            catch (Exception exception) {
                throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
            }
            bl2 = AppUtils.checkAdminAccessRemovedTarget(string, hashtable, "deployer", string5, string2, vector);
            if (!bl2) {
                object = null;
                if (vector != null && vector.size() > 0) {
                    object = (String)vector.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0188E", new Object[]{object}));
            }
        }
        object = listener;
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction((AppNotification.Listener)object, string4){
                private final /* synthetic */ AppNotification.Listener val$notfFinal;
                private final /* synthetic */ String val$workspaceIDFinal;
                {
                    this.val$notfFinal = listener;
                    this.val$workspaceIDFinal = string2;
                }

                public Object run() throws Exception {
                    AppManagementImpl.this._uninstallApplicationAsSystem(string3, hashtable2, this.val$notfFinal, this.val$workspaceIDFinal);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
        }
        catch (Exception exception) {
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
        }
    }

    private void _uninstallApplicationAsSystem(String string, Hashtable hashtable, AppNotification.Listener listener, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_uninstallApplicationAsSystem " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create new uninstallscheduler");
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        UninstallSchedulerImpl uninstallSchedulerImpl = new UninstallSchedulerImpl(string, hashtable, this, listener);
        try {
            uninstallSchedulerImpl.setWorkSpaceID(string2);
            Thread thread = new Thread(uninstallSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl._uninstallApplication", "328", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_uninstallAppliction");
            }
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_uninstallApplicationAsSystem " + string);
        }
    }

    public void redeployApplicationLocal(String string, String string2, Hashtable hashtable, AppNotification.Listener listener, String string3) throws AdminException {
        if (AppUtils.isEntitled()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA9008E", new Object[]{"redeployApplication"}));
        }
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        RedeploymentManager redeploymentManager = new RedeploymentManager(string, string2, hashtable, string3, listener, true, this);
        redeploymentManager.performTask();
    }

    public void redeployApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        Vector vector;
        if (AppUtils.isEntitled()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA9008E", new Object[]{"redeployApplication"}));
        }
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"redeployApplication"}));
        }
        String string4 = AppManagementImpl.getCellName();
        boolean bl = AppUtils.checkCellLevelAdminAccess(string4);
        if (!bl) {
            bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string2);
            if (!bl) {
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0187E", new Object[]{string2}));
            }
            vector = new Vector();
            bl = AppUtils.checkAdminAccessChangedTarget(string2, hashtable, "deployer", string4, string3, vector);
            if (!bl) {
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                String string5 = null;
                if (vector != null && vector.size() > 0) {
                    string5 = (String)vector.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string5, "deployer"}));
            }
        }
        vector = new RedeploymentManager(string, string2, hashtable, string3, null, false, this);
        ((RedeploymentManager)((Object)vector)).performTask();
    }

    public Vector getApplicationInfo(String string, Hashtable hashtable, String string2) throws AdminException {
        return this._getApplicationInfo(string, hashtable, null, string2);
    }

    public Vector getModuleInfo(String string, Hashtable hashtable, String string2, String string3) throws AdminException {
        return this._getApplicationInfo(string, hashtable, string2, string3);
    }

    private Vector _getApplicationInfo(String string, Hashtable hashtable, String string2, String string3) throws AdminException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationInfo:" + string + ", " + string2);
        }
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isServantJvm() && hashtable != null && (object2 = (String)hashtable.get("REQUEST_CLIENT_VERSION")) != null) {
            object = new JMXVersionValidation();
            Tr.debug(tc, "client version is " + (String)object2);
            JMXVersionValidation.setClientVersion((String)object2);
            hashtable.remove("REQUEST_CLIENT_VERSION");
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        object2 = new EditApplication(string, hashtable, string2, string3, this);
        object = ((EditApplication)object2).getApplicationInfo();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationInfo");
        }
        return object;
    }

    public void setApplicationInfo(String string, Hashtable hashtable, String string2, Vector vector) throws AdminException {
        this._setApplicationInfo(string, hashtable, null, string2, vector);
    }

    public void setModuleInfo(String string, Hashtable hashtable, String string2, String string3, Vector vector) throws AdminException {
        this._setApplicationInfo(string, hashtable, string2, string3, vector);
    }

    private void _setApplicationInfo(String string, Hashtable hashtable, String string2, String string3, Vector vector) throws AdminException {
        Object object;
        String string4;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_setApplicationInfo: " + string + ", " + string2);
        }
        if (!(bl = AppUtils.checkCellLevelAdminAccess(string4 = AppManagementImpl.getCellName()))) {
            bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string);
            if (!bl) {
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0170E", new Object[]{string}));
            }
            object = "";
            Vector vector2 = new Vector();
            bl = AppUtils.checkAdminAccessChangedTarget(string, hashtable, "deployer", string4, string3, vector2, vector);
            if (!bl) {
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                if (vector2 != null && vector2.size() > 0) {
                    object = (String)vector2.get(0);
                }
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{object, "deployer"}));
            }
        }
        object = new EditApplication(string, hashtable, string2, string3, this);
        ((EditApplication)object).setApplicationInfo(vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setApplicationInfo");
        }
    }

    public void moveModule(String string, Hashtable hashtable, String string2, ObjectName objectName, String string3) throws AdminException {
    }

    public void exportApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportApplication: " + string);
        }
        if (!(bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        editApplication.exportApplication(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportApplication: " + string);
        }
    }

    public void extractDDL(String string, String string2, String string3, Hashtable hashtable, String string4) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDDL: " + string);
        }
        if (!(bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string4, this);
        editApplication.extractDDL(string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDDL: " + string);
        }
    }

    public void publishWSDL(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishWSDL: " + string);
        }
        if (!(bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        editApplication.publishWSDL(string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishWSDL: " + string);
        }
    }

    public Vector listSystemApplications(Hashtable hashtable, String string) throws AdminException {
        Vector vector;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listSystemApplications");
            }
            String string2 = AppManagementImpl.getCellName();
            String string3 = "cells/" + string2;
            boolean bl = AppUtils.checkAdminAccess("monitor", string3);
            if (!bl) {
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0192E", new Object[]{string3, "monitor", "System Application"}));
            }
            vector = new Vector();
            try {
                vector = AppUtils.listSystemApps(hashtable, string);
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Exception from listSystemApps " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSystemApplications: " + vector);
        }
        return vector;
    }

    public Vector listApplicationsAsSystem(Hashtable hashtable, String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications");
        }
        Vector vector = EditApplication.listApplications(hashtable, string, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + vector);
        }
        return vector;
    }

    public Vector listApplications(Hashtable hashtable, String string) throws AdminException {
        Object object;
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        final Hashtable hashtable2 = hashtable;
        final String string2 = string;
        Vector vector = null;
        try {
            object = ContextManagerFactory.getInstance().getServerSubject();
            vector = (Vector)ContextManagerFactory.getInstance().runAsSpecified((Subject)object, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.listApplicationsAsSystem(hashtable2, string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0044E", new Object[]{null}));
        }
        catch (Exception exception) {
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0044E", new Object[]{null}));
        }
        object = AppManagementImpl.getCellName();
        String string3 = "cells/" + (String)object;
        boolean bl = AppUtils.checkAdminAccess("monitor", string3);
        if (!bl) {
            String string4 = null;
            Vector vector2 = new Vector();
            for (int i = vector.size() - 1; i >= 0; --i) {
                final String string5 = string4 = (String)vector.get(i);
                bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string4);
                if (bl) continue;
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            AppUtils.loadDeploymentsToWorkSpacorkSpace(string5, hashtable2, string2);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string4}));
                }
                catch (Exception exception) {
                    throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string4}));
                }
                bl = AppUtils.checkAdminAccessRemovedTarget(string4, hashtable, "deployer", (String)object, string, vector2);
                if (bl) continue;
                vector.removeElementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + vector);
        }
        return vector;
    }

    public Object listModules(String string, Hashtable hashtable, String string2) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listModules: " + string);
        }
        if (!(bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        AppDeploymentTask appDeploymentTask = editApplication.listModules();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listModules: " + string + ", " + appDeploymentTask);
        }
        return appDeploymentTask;
    }

    public List listURIs(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listURIs: " + string + ", " + string2);
        }
        if (!(bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, string2, string3, this);
        List list = editApplication.listURIs();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listURIs");
        }
        return list;
    }

    public void removeAllAppsFromNode(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        Object object;
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromNode"}));
        }
        String string4 = "cells/" + string2;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string2);
        if (!bl) {
            bl = AppUtils.checkAdminAccess("deployer", string4 = string4 + "/nodes/" + string);
            if (!bl) {
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string4, "deployer"}));
            }
            object = new Hashtable(10);
            String string5 = "WebSphere:cell=" + string2 + ",node=" + string;
            Vector vector = EditApplication.listApplications(string5, hashtable, string3);
            String string6 = null;
            for (int i = 0; i < vector.size(); ++i) {
                string6 = (String)vector.get(i);
                bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string6);
                if (bl) continue;
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0170E", new Object[]{string6}));
            }
        }
        object = new AppAssociation(this, hashtable, string3);
        ((AppAssociation)object).removeAllAppsFromNode(string, string2);
    }

    public void removeAllAppsFromServer(ObjectName objectName, Hashtable hashtable, String string) throws AdminException {
        Object object;
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromServer"}));
        }
        String string2 = objectName.getKeyProperty("cell");
        Object var5_6 = null;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string2);
        if (!bl) {
            object = objectName.getKeyProperty("node");
            String string3 = objectName.getKeyProperty("server");
            String string4 = "/cells/" + string2 + "/nodes/" + (String)object + "/servers/" + string3;
            bl = AppUtils.checkAdminAccess("deployer", string4);
            if (!bl) {
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string4, "deployer"}));
            }
            Vector vector = EditApplication.listApplications(string4, hashtable, string);
            for (int i = 0; i < vector.size(); ++i) {
                String string5 = (String)vector.get(i);
                bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string5);
                if (bl) continue;
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0170E", new Object[]{string5}));
            }
        }
        object = new AppAssociation(this, hashtable, string);
        ((AppAssociation)object).removeAllAppsFromServer(objectName);
    }

    public void removeAllAppsFromCluster(ObjectName objectName, Hashtable hashtable, String string) throws AdminException {
        Object object;
        if (this.isReadOnlyMode()) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"removeAllAppsFromCluster"}));
        }
        String string2 = objectName.getKeyProperty("cell");
        Object var5_6 = null;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string2);
        if (!bl) {
            object = objectName.getKeyProperty("cluster");
            String string3 = "/cells/" + string2 + "/clusters/" + (String)object;
            Vector vector = EditApplication.listApplications(string3, hashtable, string);
            for (int i = 0; i < vector.size(); ++i) {
                String string4 = (String)vector.get(i);
                bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string4);
                if (bl) continue;
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0170E", new Object[]{string4}));
            }
        }
        object = new AppAssociation(this, hashtable, string);
        ((AppAssociation)object).removeAllAppsFromCluster(objectName);
    }

    public void changeServerToCluster(ObjectName objectName, ObjectName objectName2, Hashtable hashtable, String string) throws AdminException {
        String string2 = objectName.getKeyProperty("cell");
        Object var6_6 = null;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string2);
        if (!bl) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            String string3 = "/cell/" + string2;
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string3, "configurator"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.changeServerToCluster(objectName, objectName2);
    }

    public void clusterMemberAdded(ObjectName objectName, ObjectName objectName2, Hashtable hashtable, String string) throws AdminException {
        String string2 = objectName.getKeyProperty("cell");
        Object var6_6 = null;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string2);
        if (!bl) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            String string3 = "/cell/" + string2;
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string3, "configurator"}));
        }
        AppAssociation appAssociation = new AppAssociation(this, hashtable, string);
        appAssociation.clusterMemberAdded(objectName, objectName2);
    }

    public void updateAccessIDs(String string, Boolean bl, Hashtable hashtable, String string2) throws AdminException {
        String string3 = AppManagementImpl.getCellName();
        boolean bl2 = AppUtils.checkCellLevelAdminAccess(string3);
        if (!bl2 && !(bl2 = AppUtils.checkAdminAccessApp(hashtable, "deployer", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0193E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        editApplication.updateAccessIDs(bl);
    }

    public void deleteUserAndGroupEntries(String string, Hashtable hashtable, String string2) throws AdminException {
        String string3 = AppManagementImpl.getCellName();
        boolean bl = AppUtils.checkCellLevelAdminAccess(string3);
        if (!bl && !(bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0193E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string2, this);
        editApplication.deleteUserAndGroupEntries();
    }

    public String startApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startApplication: " + string);
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        if (!AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
            AdminHelper.getInstance().audit("ADMN1008I", "ADMN1009I", new Object[]{string, null});
        }
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string2);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{string}, "Unable to obtain context for {0}"));
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            ApplicationDeployment applicationDeployment = ConfigRepoHelper.getAppDeploymentForApp(repositoryContext);
            Vector vector = ConfigRepoHelper.getServersForAppDeployment(applicationDeployment, null, repositoryContext2, workSpace, false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All targets: " + vector);
            }
            String string3 = this._startApplication(string, vector, workSpace, hashtable);
            return string3;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.startApplication", "670", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in startApplication: " + throwable);
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "");
        }
        finally {
            AppManagementImpl.discardWorkSpace(string2, workSpace);
        }
    }

    public String startApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startApplication: " + string);
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"startApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        if (string2 == null) {
            return this.startApplication(string, hashtable, string3);
        }
        if (!AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
            AdminHelper.getInstance().audit("ADMN1008I", "ADMN1009I", new Object[]{string, null});
        }
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string3);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{string}, "Unable to obtain context for {0}"));
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            Vector vector = ConfigRepoHelper.getServerNames(string2, string, false, repositoryContext2, workSpace);
            String string4 = this._startApplication(string, vector, workSpace, hashtable);
            return string4;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.startApplication", "720", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in startApplication: " + throwable);
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "");
        }
        finally {
            AppManagementImpl.discardWorkSpace(string3, workSpace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _startApplication(String string, Vector vector, WorkSpace workSpace, Hashtable hashtable) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Properties properties;
        String string2 = AppManagementImpl.getCellName();
        String string3 = "cells/" + string2;
        boolean bl = AppUtils.checkAdminAccess("operator", string3);
        if (!(bl || (bl = AppUtils.checkAdminAccess("deployer", string3)) || (bl = AppUtils.checkAdminAccessApp(hashtable, "operator", string)) || (bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string)))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0194E", new Object[]{string}));
        }
        RepositoryContext repositoryContext = null;
        vector = ConfigRepoHelper.getAllServers(workSpace, vector);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "All server targets: " + vector);
        }
        if (EditionHelper.isEditionSupportEnabled() && (properties = AppUtils.getEditionProps((RepositoryContext)(object3 = AppUtils.findAppContextFromConfig(string, workSpace, (Hashtable)(serializable = new Hashtable()))))) != null) {
            object2 = EditionHelper.getEditionStatePropName(string);
            object = (String)properties.get(object2);
            if (object == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_startApplication");
                }
                throw new AdminException("Application " + string + " is not active");
            }
            if (!((String)object).equalsIgnoreCase("ACTIVE")) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "_startApplication");
                }
                throw new AdminException("Application " + string + " is not active");
            }
        }
        serializable = SecurityHelper.retrieveSubject();
        object3 = null;
        if (serializable != null) {
            serializable = SecurityHelper.pushInvocationSubject(serializable);
        }
        try {
            for (int i = 0; i < vector.size(); ++i) {
                repositoryContext = (RepositoryContext)vector.elementAt(i);
                object2 = new ObjectName("WebSphere:type=ApplicationManager,node=" + repositoryContext.getParent().getName() + ",process=" + repositoryContext.getName() + ",*");
                try {
                    object = AdminServiceFactory.getAdminService().queryNames((ObjectName)object2, null).iterator();
                    if (object.hasNext()) {
                        object2 = (ObjectName)object.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Starting app: " + string + " using " + object2);
                        }
                        AdminServiceFactory.getAdminService().invoke((ObjectName)object2, "startApplication", new Object[]{string}, new String[]{(class$java$lang$String == null ? AppManagementImpl.class$("java.lang.String") : class$java$lang$String).getName()});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Started app: " + string + " using " + object2);
                        }
                        String string4 = "WebSphere:cell=" + repositoryContext.getParent().getParent().getName() + ",node=" + repositoryContext.getParent().getName() + ",server=" + repositoryContext.getName();
                        object3 = object3 == null ? string4 : (String)object3 + "+" + string4;
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "No ApplicationManager MBean on: " + repositoryContext);
                    continue;
                }
                catch (Throwable throwable) {
                    Tr.warning(tc, "Unable to start: " + string + " using: " + object2 + " exception is: " + throwable);
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.startApplication", "815", this);
                }
            }
            RepositoryContext repositoryContext2 = object3;
            return repositoryContext2;
        }
        finally {
            if (serializable != null) {
                SecurityHelper.popInvocationSubject(serializable);
            }
        }
    }

    public String stopApplication(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopApplication: " + string);
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        if (!AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
            AdminHelper.getInstance().audit("ADMN1010I", "ADMN1011I", new Object[]{string, null});
        }
        String string3 = null;
        Subject subject = SecurityHelper.retrieveSubject();
        try {
            if (subject != null) {
                subject = SecurityHelper.pushInvocationSubject(subject);
            }
            ObjectName objectName = new ObjectName("WebSphere:type=Application,name=" + string + ",*");
            Set set = AdminServiceFactory.getAdminService().queryNames(objectName, null);
            String string4 = string3 = this._stopApplication(string, set, hashtable, string2);
            return string4;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.stopApplication", "864", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in stopApplication: " + throwable);
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "");
        }
        finally {
            if (subject != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
        }
    }

    public String stopApplication(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopApplication: " + string);
        }
        if (string2 == null) {
            return this.stopApplication(string, hashtable, string3);
        }
        if (AppManagementImpl.isLocalMode()) {
            throw new AdminException(nls.getFormattedMessage("ADMA0090", new Object[]{"stopApplication"}, "Invalid usage of {0}. Operation {0} can only be called in JMX mode of AppManagement"));
        }
        if (string == null) {
            throw new AdminException(nls.getFormattedMessage("ADMA0016E", new Object[0], "appName can not be null."));
        }
        if (!AdminServiceFactory.getAdminService().getProcessType().equals("UnManagedProcess")) {
            AdminHelper.getInstance().audit("ADMN1010I", "ADMN1011I", new Object[]{string, null});
        }
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string3);
            RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string, workSpace, hashtable);
            if (repositoryContext == null) {
                throw new AdminException(nls.getFormattedMessage("ADMA0017E", new Object[]{string}, "Unable to obtain context for {0}"));
            }
            RepositoryContext repositoryContext2 = repositoryContext.getParent().getParent();
            Vector vector = ConfigRepoHelper.getServerNames(string2, string, false, repositoryContext2, workSpace);
            Vector vector2 = ConfigRepoHelper.getAllServers(workSpace, vector);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All server targets: " + vector2);
            }
            HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
            for (int i = 0; i < vector2.size(); ++i) {
                repositoryContext = (RepositoryContext)vector2.elementAt(i);
                ObjectName objectName = new ObjectName("WebSphere:type=Application,name=" + string + ",node=" + repositoryContext.getParent().getName() + ",process=" + repositoryContext.getName() + ",*");
                hashSet.add(objectName);
            }
            String string4 = this._stopApplication(string, hashSet, hashtable, string3);
            return string4;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.stopApplication", "933", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in stopApplication: " + throwable);
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "");
        }
        finally {
            AppManagementImpl.discardWorkSpace(string3, workSpace);
        }
    }

    private String _stopApplication(String string, Set set, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_stopApplication: " + string);
        }
        String string3 = AppManagementImpl.getCellName();
        String string4 = "cells/" + string3;
        boolean bl = AppUtils.checkAdminAccess("operator", string4);
        if (!bl && !(bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0194E", new Object[]{string}));
        }
        Object object = null;
        Subject subject = SecurityHelper.retrieveSubject();
        try {
            ObjectName objectName;
            if (subject != null) {
                subject = SecurityHelper.pushInvocationSubject(subject);
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stopping: " + objectName);
                }
                objectName = new ObjectName("WebSphere:type=ApplicationManager,node=" + objectName.getKeyProperty("node") + ",process=" + objectName.getKeyProperty("process") + ",*");
                try {
                    Iterator iterator2 = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                    if (iterator2.hasNext()) {
                        objectName = (ObjectName)iterator2.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Stopping app: " + string + " using " + objectName);
                        }
                        AdminServiceFactory.getAdminService().invoke(objectName, "stopApplication", new Object[]{string}, new String[]{(class$java$lang$String == null ? AppManagementImpl.class$("java.lang.String") : class$java$lang$String).getName()});
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Stopped app: " + string + " using " + objectName);
                        }
                        object = ConfigRepoHelper.getTargetString(objectName, (String)object);
                        continue;
                    }
                    Tr.warning(tc, "ADMA0118W", new Object[]{objectName});
                }
                catch (Throwable throwable) {
                    Tr.warning(tc, "ADMA0117W", new Object[]{string, objectName, throwable});
                    FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.stopApplication", "989", this);
                }
            }
            objectName = object;
            return objectName;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.stopApplication", "997", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown in stopApplication: " + throwable);
            }
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, "");
        }
        finally {
            if (subject != null) {
                SecurityHelper.popInvocationSubject(subject);
            }
        }
    }

    public void installStandaloneRAR(String string, Hashtable hashtable, String string2) throws AdminException {
    }

    public Vector compareSecurityPolicy(String string, Hashtable hashtable, String string2) throws AdminException {
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        final String string3 = string;
        final Hashtable hashtable2 = hashtable;
        final String string4 = string2;
        Vector vector = new Vector();
        try {
            Subject subject = ContextManagerFactory.getInstance().getServerSubject();
            vector = (Vector)ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.compareSecurityPolicyAsSystem(string3, hashtable2, string4);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0180E"));
            if (exception instanceof AdminException) {
                throw (AdminException)exception;
            }
        }
        catch (Exception exception) {
            vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0181E", new Object[]{exception}));
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector compareSecurityPolicyAsSystem(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareSecurityPolicy");
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (string != null && !string.trim().equals("")) {
            WorkSpace workSpace = null;
            try {
                Object object;
                workSpace = ConfigRepoHelper.getWorkSpace(string2);
                RepositoryContext repositoryContext = null;
                Object[] objectArray = AppUtils.getContextArray("cells", null, workSpace);
                if (objectArray != null) {
                    object = (String)hashtable.get("cell.name");
                    repositoryContext = object != null ? AppUtils.getContextFromArray(objectArray, (String)object, null, true) : (RepositoryContext)objectArray[0];
                }
                if (objectArray == null || repositoryContext == null) {
                    Tr.warning(tc, "ADMA0070W");
                    vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0070W"));
                    object = vector;
                    return object;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "context found: " + repositoryContext);
                }
                if (repositoryContext.isAvailable("filter.policy")) {
                    repositoryContext.extract("filter.policy", false);
                    object = repositoryContext.getInputStream("filter.policy");
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object);
                    String string3 = Security.getProperty("policy.expandProperties");
                    boolean bl = false;
                    if (string3 != null) {
                        bl = string3.equalsIgnoreCase("true");
                    }
                    FilterPolicyParser filterPolicyParser = new FilterPolicyParser(inputStreamReader, bl);
                    filterPolicyParser.parse();
                    ArrayList arrayList = filterPolicyParser.getFilterPermissions();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Permissions to be filtered: " + arrayList);
                    }
                    ((InputStream)object).close();
                    byte[] byArray = string.getBytes();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    InputStreamReader inputStreamReader2 = new InputStreamReader(byteArrayInputStream);
                    ApplicationPolicyParser applicationPolicyParser = new ApplicationPolicyParser(inputStreamReader2, bl);
                    applicationPolicyParser.parse();
                    PolicyTemplate policyTemplate = applicationPolicyParser.getPolicyTemplate();
                    String[] stringArray = policyTemplate.getSymbols();
                    for (int i = 0; i < stringArray.length; ++i) {
                        ArrayList arrayList2 = policyTemplate.get(stringArray[i]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Permissions for symbol " + stringArray[i] + ": " + arrayList2);
                        }
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext()) {
                            boolean bl2 = true;
                            Permission permission = (Permission)iterator.next();
                            String string4 = permission.toString();
                            if (!(string4.startsWith("(java") || string4.startsWith("(javax") || string4.startsWith("(unresolved java") || string4.startsWith("(unresolved javax"))) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Custom permission found: " + permission);
                                }
                                vector3.addElement(string4);
                                continue;
                            }
                            Iterator iterator2 = arrayList.iterator();
                            while (iterator2.hasNext() && bl2) {
                                Permission permission2 = (Permission)iterator2.next();
                                if (!permission2.implies(permission)) continue;
                                bl2 = false;
                            }
                            if (bl2) continue;
                            vector2.addElement(string4);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0071W", new Object[]{throwable.toString()}));
                Tr.warning(tc, "ADMA0071W", throwable);
            }
            finally {
                AppManagementImpl.discardWorkSpace(string2, workSpace);
            }
        }
        if (!vector2.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "policy file contains filter permissions: " + vector2);
            }
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0072E"));
        }
        if (!vector3.isEmpty()) {
            vector.addElement(AppUtils.getMessage(resourceBundle, "ADMA0073W", new Object[]{vector3}));
            Tr.warning(tc, "ADMA0073W", vector3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareSecurityPolicy");
        }
        return vector;
    }

    private boolean isReadOnlyMode() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp);
        }
        if (this.readOnlyPath == null) {
            this.findReadOnlyFiles(classLoader);
        } else {
            File file = new File(this.readOnlyPath);
            if (!file.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "File not found: " + this.readOnlyPath + ", so look again");
                }
                this.findReadOnlyFiles(classLoader);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "File exists: " + this.readOnlyPath);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "readOnlyTimeStamp: " + this.readOnlyTimeStamp);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "file.lastModified: " + file.lastModified());
                    }
                }
                if (file.lastModified() == this.readOnlyTimeStamp) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "lock not changed: " + this.readOnly);
                    }
                } else {
                    this.readOnly = AppManagementImpl.getReadOnlyFlag(file);
                    this.readOnlyTimeStamp = file.lastModified();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "timestamp changed: " + this.readOnly + ", " + this.readOnlyTimeStamp);
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "readOnly: " + this.readOnly);
        }
        if (this.readOnly) {
            Tr.audit(tc, "ADMA0097I");
        }
        return this.readOnly;
    }

    private void findReadOnlyFiles(ClassLoader classLoader) {
        Enumeration<URL> enumeration;
        block16: {
            enumeration = null;
            try {
                enumeration = classLoader.getResources(PROPERTIES_PATH);
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug(tc, "Ignoring exception:  " + iOException.getMessage());
            }
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "file not in classpath");
            }
            this.readOnlyTimeStamp = 0L;
            this.readOnly = true;
        } else {
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "url: " + uRL);
                }
                if (uRL == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "empty url");
                    }
                    this.readOnlyTimeStamp = 0L;
                    this.readOnly = true;
                    continue;
                }
                this.readOnlyPath = uRL.getFile();
                try {
                    this.readOnlyPath = URLDecoder.decode(this.readOnlyPath, "UTF-8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Decoded url: " + this.readOnlyPath);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "exception in decoding url: " + unsupportedEncodingException);
                    }
                    FFDCFilter.processException(unsupportedEncodingException, "com.ibm.websphere.management.application.AppManagementBaseFactory", "1819");
                }
                File file = new File(this.readOnlyPath);
                this.readOnly = AppManagementImpl.getReadOnlyFlag(file);
                if (this.readOnly) continue;
                this.readOnlyTimeStamp = file.lastModified();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "new: " + this.readOnlyPath + ", " + this.readOnly + ", " + this.readOnlyTimeStamp);
                break;
            }
            if (this.readOnly) {
                this.readOnlyTimeStamp = 0L;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "url not found");
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "findReadOnlyFiles() readOnly: " + this.readOnly);
        }
    }

    private static boolean getReadOnlyFlag(final File file) {
        boolean bl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getReadOnlyFlag: " + file.getAbsolutePath());
        }
        Properties properties = null;
        try {
            properties = (Properties)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Properties properties = new Properties();
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                        if (fileInputStream != null) {
                            properties.load(fileInputStream);
                        }
                        Properties properties2 = properties;
                        return properties2;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.websphere.management.application.AppManagementBaseFactory", "1866");
                        Object var4_6 = null;
                        return var4_6;
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                ((InputStream)fileInputStream).close();
                            }
                            catch (IOException iOException) {
                                FFDCFilter.processException(iOException, "com.ibm.websphere.management.application.AppManagementBaseFactory", "1878");
                            }
                        }
                    }
                }
            });
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception reading file : " + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.application.AppManagementBaseFactory", "1887");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "props: " + properties);
        }
        if (properties == null) {
            bl = true;
        } else {
            if (!properties.containsKey(VERSION_KEY)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "props does not contains app.management.roam.key, flag=true");
                }
                Tr.audit(tc, "ADMA0097I");
                return true;
            }
            String string = properties.getProperty(VERSION_KEY);
            if (VERSION_VALUE.equals(string)) {
                bl = false;
            } else {
                bl = true;
                Tr.audit(tc, "ADMA0096I");
            }
        }
        if (bl) {
            Tr.audit(tc, "ADMA0097I");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "flag=" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable searchJNDIReferences(List list, String string, Hashtable hashtable, String string2) throws AdminException {
        Object object;
        Object object2;
        Object object3;
        String string3;
        Object object4;
        Object object5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchJNDIReferences: " + list + " nodes: " + string + " prefs: " + hashtable + " wID: " + string2);
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (list == null) {
            return null;
        }
        String string4 = AppManagementImpl.getCellName();
        String string5 = "cells/" + string4;
        boolean bl = AppUtils.checkAdminAccess("monitor", string5);
        if (!bl) {
            object5 = string.split("\\+");
            object4 = null;
            for (int i = 0; i < ((String[])object5).length; ++i) {
                try {
                    object4 = new ObjectName(object5[i]);
                }
                catch (Exception exception) {
                    continue;
                }
                string4 = ((ObjectName)object4).getKeyProperty("cell");
                string5 = "cells/" + string4;
                string3 = ((ObjectName)object4).getKeyProperty("node");
                bl = AppUtils.checkAdminAccess("monitor", string5);
                if (bl) continue;
                object3 = new Hashtable(10);
                object2 = "WebSphere:cell=" + string4 + ",node=" + string3;
                Vector vector = EditApplication.listApplications((String)object2, hashtable, string2);
                object = null;
                for (int j = 0; j < vector.size(); ++j) {
                    object = (String)vector.get(j);
                    bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", (String)object);
                    if (bl) continue;
                    throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0170E", new Object[]{object, "monitor"}));
                }
            }
        }
        object5 = new Hashtable(5);
        object4 = null;
        try {
            object4 = ConfigRepoHelper.getWorkSpace(string2);
            if (object4 == null) {
                Tr.error(tc, "ADMA0106E", string2);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0106E", new Object[]{string2}));
            }
            Hashtable hashtable2 = hashtable;
            if (hashtable2 == null) {
                hashtable2 = new Hashtable();
            }
            string3 = null;
            object3 = string;
            object2 = new String[]{object3};
            if (((String)object3).indexOf(43) != -1) {
                object2 = ((String)object3).split("\\+");
            }
            for (int i = 0; i < ((String[])object2).length; ++i) {
                object = null;
                try {
                    object = new ObjectName(object2[i]);
                    string4 = null;
                    String string6 = null;
                    String string7 = null;
                    string4 = ((ObjectName)object).getKeyProperty("cell");
                    string6 = ((ObjectName)object).getKeyProperty("node");
                    string7 = ((ObjectName)object).getKeyProperty("server");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cell =" + string4 + " node = " + string6 + " server =" + string7);
                    }
                    Vector vector = null;
                    String string8 = null;
                    string8 = string6 != null ? "WebSphere:cell=" + string4 + ",node=" + string6 : "WebSphere:cell=" + string4;
                    vector = EditApplication.listApplications(string8, hashtable2, string2);
                    Iterator iterator = vector.iterator();
                    while (iterator.hasNext()) {
                        string3 = (String)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appName:" + string3);
                        }
                        Vector vector2 = null;
                        vector2 = this.getApplicationInfo(string3, hashtable2, string2);
                        Object var23_30 = null;
                        AppDeploymentTask appDeploymentTask = null;
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int j = 0; j < vector2.size(); ++j) {
                            appDeploymentTask = (AppDeploymentTask)vector2.elementAt(j);
                            String string9 = appDeploymentTask.getName();
                            if (string9.equals("EmbeddedRar")) continue;
                            String[] stringArray = appDeploymentTask.getColumnNames();
                            int n = stringArray.length;
                            int n2 = -1;
                            int n3 = -1;
                            int n4 = -1;
                            for (int k = 0; k < n; ++k) {
                                if ("module".equals(stringArray[k])) {
                                    n4 = k;
                                }
                                if ("EJBModule".equals(stringArray[k])) {
                                    n4 = k;
                                }
                                if ("JNDI".equals(stringArray[k])) {
                                    n2 = k;
                                }
                                if (!"jndi.dest".equals(stringArray[k])) continue;
                                n3 = k;
                            }
                            if (n2 == -1 && n3 == -1) continue;
                            String[][] stringArray2 = appDeploymentTask.getTaskData();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "jndi column found " + string3 + "  task: " + string9);
                            }
                            if (stringArray2 == null) continue;
                            String string10 = null;
                            String string11 = null;
                            String string12 = null;
                            boolean bl2 = false;
                            for (int k = 1; k < stringArray2.length; ++k) {
                                string11 = stringArray2[k][n2];
                                if (n3 != -1) {
                                    string12 = stringArray2[k][n3];
                                }
                                if (tc.isDebugEnabled()) {
                                    if (string11 != null) {
                                        Tr.debug(tc, "jndi name  " + string11);
                                    }
                                    if (string12 != null) {
                                        Tr.debug(tc, "djndi name  " + string12);
                                    }
                                }
                                if (string11 != null && list.contains(string11)) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "data matched" + string11);
                                    }
                                    bl2 = true;
                                    string10 = "  " + string9 + " :";
                                    if (n4 != -1) {
                                        string10 = string10 + stringArray2[k][n4];
                                    }
                                    string10 = string10 + " : [" + string11 + "]\n";
                                }
                                if (string12 == null || !list.contains(string12)) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "data matched" + string12);
                                }
                                bl2 = true;
                                string10 = "  " + string9 + " :";
                                if (n4 != -1) {
                                    string10 = string10 + stringArray2[k][n4];
                                }
                                string10 = string10 + " : [" + string12 + "]\n";
                            }
                            if (!bl2) continue;
                            stringBuffer.append(string10);
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "search result " + string10);
                        }
                        String string13 = stringBuffer.toString();
                        if (string13 != null && string13.length() != 0) {
                            ((Hashtable)object5).put(string3, string13);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "List:" + string3 + " Ref:" + string13);
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            Tr.warning(tc, "ADMA0104W", exception);
        }
        finally {
            AppManagementImpl.discardWorkSpace(string2, (WorkSpace)object4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchJNDIReferences: " + object5);
        }
        return object5;
    }

    private boolean isFullUpdate(Hashtable hashtable) {
        return hashtable != null && "app".equals(hashtable.get("contenttype"));
    }

    public void updateApplication(String string, String string2, String string3, String string4, Hashtable hashtable, String string5) throws AdminException {
        if (this.isFullUpdate(hashtable)) {
            if (string4 != null && !"update".equals(string4)) {
                this.sendJMXEvent(new AppNotification("UpdateApplication", "", "Failed", "", "ERROR: " + string4 + " is not a valid operation for full application."));
                throw new AdminException("ERROR: " + string4 + " is not a valid operation for full application.");
            }
            this.redeployApplication(string3, string, hashtable, string5);
        } else {
            this._updateApplication(string, string2, string3, string4, hashtable, null, string5);
        }
    }

    public void updateApplicationLocal(String string, String string2, String string3, String string4, Hashtable hashtable, AppNotification.Listener listener, String string5) throws AdminException {
        if (this.isFullUpdate(hashtable)) {
            if (string4 != null && !"update".equals(string4)) {
                listener.appEventReceived(new AppNotification("UpdateApplication", "", "Failed", "", "ERROR: " + string4 + " is not a valid operation for full application."));
                throw new AdminException("ERROR: " + string4 + " is not a valid operation for full application.");
            }
            this.redeployApplicationLocal(string3, string, hashtable, listener, string5);
        } else {
            this._updateApplication(string, string2, string3, string4, hashtable, listener, string5);
        }
    }

    public void _updateApplication(String string, String string2, String string3, String string4, Hashtable hashtable, AppNotification.Listener listener, String string5) throws AdminException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_updateApplication " + string);
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        if (AppUtils.isEntitled() && !string.equalsIgnoreCase("isclite")) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA9008E", new Object[]{"updateApplication"}));
        }
        if (this.isReadOnlyMode()) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"updateApplication"}));
        }
        if (string == null) {
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0045E"));
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create new updatescheduler");
        }
        String string6 = AppManagementImpl.getCellName();
        String string7 = "cells/" + string6;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string6);
        if (!bl) {
            bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string);
            resourceBundle = AppUtils.getBundle(hashtable);
            if (!bl) {
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0170E", new Object[]{string}));
            }
            string7 = null;
            object = new Vector();
            if ("add".equals(string4)) {
                bl = AppUtils.checkAdminAccessTarget(hashtable, "deployer", string6, string5, (Vector)object);
                if (!bl) {
                    if (object != null && ((Vector)object).size() > 0) {
                        string7 = (String)((Vector)object).get(0);
                    }
                    throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string7, "deployer"}));
                }
            } else if ("delete".equals(string4)) {
                bl = AppUtils.checkAdminAccessRemovedTargetForModule(string, hashtable, "deployer", string6, string5, (Vector)object, string2);
                if (!bl) {
                    if (object != null && ((Vector)object).size() > 0) {
                        string7 = (String)((Vector)object).get(0);
                    }
                    throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string7, "deployer"}));
                }
            } else if (("update".equals(string4) || "addupdate".equals(string4)) && !(bl = AppUtils.checkAdminAccessChangedTarget(string, hashtable, "deployer", string6, string5, (Vector)object))) {
                if (object != null && ((Vector)object).size() > 0) {
                    string7 = (String)((Vector)object).get(0);
                }
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string7, "deployer"}));
            }
        }
        object = new UpdateSchedulerImpl(string, string2, string3, string4, hashtable, this, listener);
        try {
            object.setWorkSpaceID(string5);
            Thread thread = new Thread((Runnable)object);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.updateApplication", "1672", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_updateApplication");
            }
            throw new AdminException(throwable, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_updateApplication " + string);
        }
    }

    public void updateClusterLocal(String[] stringArray, Integer n, Hashtable hashtable, String string, AppNotification.Listener listener) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateClusterLocal " + stringArray);
        }
        this._updateCluster(stringArray, n, hashtable, string, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateClusterLocal " + stringArray);
        }
    }

    public void updateCluster(String[] stringArray, Integer n, Hashtable hashtable, String string) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCluster " + stringArray);
        }
        this._updateCluster(stringArray, n, hashtable, string, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_updateCluster " + stringArray);
        }
    }

    private void _updateCluster(String[] stringArray, Integer n, Hashtable hashtable, String string, AppNotification.Listener listener) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_updateCluster " + stringArray);
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        String string2 = AppManagementImpl.getCellName();
        String string3 = "cells/" + string2;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string2);
        if (!bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", string4);
                if (bl) continue;
                resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0170E", new Object[]{string4}));
            }
        }
        String string5 = new String();
        for (int i = 0; i < stringArray.length; ++i) {
            string5 = string5.concat(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            string5 = string5.concat(";");
        }
        Tr.debug(tc, " in  _updateCluster -> LAUNCH_TIMEOUT " + n);
        hashtable.put("LAUNCH_TIMEOUT", n);
        UpdateClusterScheduler updateClusterScheduler = new UpdateClusterScheduler(stringArray, string5, hashtable, this, listener);
        Locale locale = null;
        if (hashtable != null) {
            locale = (Locale)hashtable.get("app.client.locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        updateClusterScheduler.setLocale(locale);
        try {
            updateClusterScheduler.setWorkSpaceID(string);
            Thread thread = new Thread(updateClusterScheduler);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl._updateCluster", "1728", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_updateCluster");
            }
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0094E", new Object[]{"updateCluster"}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_updateCluster " + stringArray);
        }
    }

    public List searchResources(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchResources(" + string + "," + hashtable + "," + string2 + ")");
        }
        Hashtable hashtable2 = hashtable;
        if (hashtable == null) {
            hashtable2 = new Hashtable();
        }
        Vector vector = null;
        vector = this.getApplicationInfo(string, hashtable2, string2);
        List list = ResourceLookup.searchResources(string, hashtable, string2, vector);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchResources returns : " + list);
        }
        return list;
    }

    public List convertRefToConfigID(String string, List list, Hashtable hashtable, String string2) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertRefToConfigID(" + string + "," + list + "." + string2);
        }
        if (!(bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        List list2 = ResourceLookup.convertRefToConfigID(string, list, hashtable, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertRefToConfigID returns " + list2);
        }
        return list2;
    }

    public byte[] getApplicationContents(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        boolean bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string);
        if (!bl) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        return editApplication.getApplicationContents(string2);
    }

    public void getDistributionStatus(String string, Hashtable hashtable, String string2) throws AdminException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributionStatus " + string);
        }
        if (!(bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string))) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        DistributionStatusSchedulerImpl distributionStatusSchedulerImpl = new DistributionStatusSchedulerImpl(string, hashtable, this, null);
        try {
            distributionStatusSchedulerImpl.setWorkSpaceID(string2);
            Thread thread = new Thread(distributionStatusSchedulerImpl);
            thread.start();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.getDistributionStatus", "1802", this);
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable, throwable.getMessage());
        }
        finally {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDistributionStatus " + string);
            }
        }
    }

    public String[] getAppAssociation(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        String string4 = AppManagementImpl.getCellName();
        String string5 = "cells/" + string4;
        boolean bl = AppUtils.checkAdminAccess("monitor", string5);
        if (!bl) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0171E", new Object[]{string5, "monitor"}));
        }
        EditApplication editApplication = new EditApplication(null, hashtable, null, string3, this);
        return editApplication.getAppAssociation(string, string2);
    }

    public EditionInfo[] getEditionInfo(String string, String string2, Hashtable hashtable, String string3) throws AdminException {
        boolean bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string);
        if (!bl) {
            ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
            throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0190E", new Object[]{string}));
        }
        EditApplication editApplication = new EditApplication(string, hashtable, null, string3, this);
        return editApplication.getEditionInfo(string2);
    }

    public void setEditionInfo(EditionInfo[] editionInfoArray, Hashtable hashtable, String string) throws AdminException {
        Object object;
        String string2 = AppManagementImpl.getCellName();
        String string3 = "cells/" + string2;
        boolean bl = AppUtils.checkCellLevelAdminAccess(string2);
        if (!bl) {
            object = null;
            for (int i = 0; i < editionInfoArray.length; ++i) {
                object = editionInfoArray[i].getAppName();
                bl = AppUtils.checkAdminAccessApp(hashtable, "deployer", (String)object);
                if (bl) continue;
                ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
                throw new AdminException(AppUtils.getMessage(resourceBundle, "ADMA0193E", new Object[]{object}));
            }
        }
        object = new EditApplication(null, hashtable, null, string, this);
        ((EditApplication)object).setEditionInfo(editionInfoArray);
    }

    public Vector listApplications(String string, Hashtable hashtable, String string2) throws AdminException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications: target:" + string);
        }
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        final String string3 = string;
        final Hashtable hashtable2 = hashtable;
        final String string4 = string2;
        Vector vector = null;
        try {
            object = ContextManagerFactory.getInstance().getServerSubject();
            vector = (Vector)ContextManagerFactory.getInstance().runAsSpecified((Subject)object, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return AppManagementImpl.this.listApplicationsAsSystem(string3, hashtable2, string4);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0044E", new Object[]{null}));
        }
        catch (Exception exception) {
            throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0044E", new Object[]{null}));
        }
        object = AppManagementImpl.getCellName();
        String string5 = "cells/" + (String)object;
        boolean bl = AppUtils.checkAdminAccess("monitor", string5);
        if (!bl) {
            String string6 = null;
            Vector vector2 = new Vector();
            for (int i = vector.size() - 1; i >= 0; --i) {
                final String string7 = string6 = (String)vector.get(i);
                bl = AppUtils.checkAdminAccessApp(hashtable, "monitor", string6);
                if (bl) continue;
                try {
                    Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                    ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            AppUtils.loadDeploymentsToWorkSpacorkSpace(string7, hashtable2, string4);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string6}));
                }
                catch (Exception exception) {
                    throw new AdminException(exception, AppUtils.getMessage(resourceBundle, "ADMA0047E", new Object[]{string6}));
                }
                bl = AppUtils.checkAdminAccessRemovedTarget(string6, hashtable, "deployer", (String)object, string2, vector2);
                if (bl) continue;
                vector.removeElementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + vector);
        }
        return vector;
    }

    public Vector listApplicationsAsSystem(String string, Hashtable hashtable, String string2) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications");
        }
        Vector vector = EditApplication.listApplications(string, hashtable, string2, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications: " + vector);
        }
        return vector;
    }

    public static String getCellName() {
        AdminService adminService = AdminServiceFactory.getAdminService();
        String string = null;
        if (adminService != null) {
            string = adminService.getCellName();
        }
        if (string == null) {
            string = System.getProperty("local.cell");
        }
        return string;
    }

    private static void discardWorkSpace(String string, WorkSpace workSpace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discardWorkSpace", new String[]{"workSpaceID=" + string, "workSpace=" + workSpace});
        }
        if (workSpace != null && string == null) {
            try {
                ConfigRepoHelper.removeWorkSpace(false, workSpace);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.application.AppManagementImpl.discardWorkSpace", "2670", null, new Object[]{string, workSpace});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "discardWorkSpace", throwable);
                }
                Tr.warning(tc, "ADMA0077W", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discardWorkSpace");
        }
    }

    static {
        seqNum = 0L;
    }
}

